/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.treegrid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class HierarchyColumnComponentRenderer<COMPONENT extends Component, SOURCE>
extends ComponentRenderer<COMPONENT, SOURCE> {
    public HierarchyColumnComponentRenderer(ValueProvider<SOURCE, COMPONENT> componentProvider, TreeGrid<SOURCE> grid) {
        super(componentProvider);
        this.withFunction("onClick", (SerializableConsumer & Serializable)item -> {
            if (grid.isExpanded(item)) {
                grid.collapse((Collection)List.of(item), true);
            } else {
                grid.expand((Collection)List.of(item), true);
            }
        });
    }

    protected String getTemplateExpression() {
        String clickListener = "e => requestAnimationFrame(() => { e.defaultPrevented && onClick(e) })";
        return "<vaadin-grid-tree-toggle @click=${" + clickListener + "} class=${item.cssClassName} .leaf=${!model.hasChildren} .expanded=${live(model.expanded)} .level=${model.level}>" + super.getTemplateExpression() + "</vaadin-grid-tree-toggle>";
    }
}

