/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.contextmenu.ContextMenuBase;
import com.vaadin.flow.component.contextmenu.MenuManager;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.contextmenu.GridMenuItem;
import com.vaadin.flow.component.grid.contextmenu.GridSubMenu;
import com.vaadin.flow.component.grid.contextmenu.HasGridMenuItems;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Optional;
import tools.jackson.databind.node.ObjectNode;

public class GridContextMenu<T>
extends ContextMenuBase<GridContextMenu<T>, GridMenuItem<T>, GridSubMenu<T>>
implements HasGridMenuItems<T> {
    private SerializablePredicate<T> dynamicContentHandler;

    public GridContextMenu() {
    }

    public GridContextMenu(Grid<T> target) {
        this();
        this.setTarget(target);
    }

    public void setTarget(Component target) {
        if (target != null && !(target instanceof Grid)) {
            throw new IllegalArgumentException("Only an instance of Grid can be used as the target for GridContextMenu. Use ContextMenu for any other component.");
        }
        super.setTarget(target);
    }

    @Override
    public GridMenuItem<T> addItem(String text, ComponentEventListener<GridContextMenuItemClickEvent<T>> clickListener) {
        GridMenuItem menuItem = (GridMenuItem)this.getMenuManager().addItem(text);
        if (clickListener != null) {
            menuItem.addMenuItemClickListener(clickListener);
        }
        return menuItem;
    }

    @Override
    public GridMenuItem<T> addItem(Component component, ComponentEventListener<GridContextMenuItemClickEvent<T>> clickListener) {
        GridMenuItem menuItem = (GridMenuItem)this.getMenuManager().addItem(component);
        if (clickListener != null) {
            menuItem.addMenuItemClickListener(clickListener);
        }
        return menuItem;
    }

    protected MenuManager<GridContextMenu<T>, GridMenuItem<T>, GridSubMenu<T>> createMenuManager(SerializableRunnable contentReset) {
        SerializableBiFunction & Serializable itemFactory = (SerializableBiFunction & Serializable)(menu, reset) -> new GridMenuItem((GridContextMenu)menu, (SerializableRunnable)reset);
        return new MenuManager((Component)this, contentReset, (SerializableBiFunction)itemFactory, GridMenuItem.class, null);
    }

    public Registration addGridContextMenuOpenedListener(ComponentEventListener<GridContextMenuOpenedEvent<T>> listener) {
        return super.addOpenedChangeListener((ComponentEventListener & Serializable)ev -> listener.onComponentEvent(new GridContextMenuOpenedEvent((GridContextMenu)ev.getSource(), ev.isFromClient())));
    }

    public SerializablePredicate<T> getDynamicContentHandler() {
        return this.dynamicContentHandler;
    }

    public void setDynamicContentHandler(SerializablePredicate<T> dynamicContentHandler) {
        this.dynamicContentHandler = dynamicContentHandler;
    }

    protected boolean onBeforeOpenMenu(ObjectNode eventDetail) {
        Grid grid = (Grid)this.getTarget();
        String key = eventDetail.get("key").asString();
        if (this.getDynamicContentHandler() != null) {
            Object item = grid.getDataCommunicator().getKeyMapper().get(key);
            return this.getDynamicContentHandler().test(item);
        }
        return super.onBeforeOpenMenu(eventDetail);
    }

    public static class GridContextMenuOpenedEvent<T>
    extends ContextMenuBase.OpenedChangeEvent<GridContextMenu<T>> {
        private final Grid<T> grid = (Grid)((GridContextMenu)this.getSource()).getTarget();
        private final transient Optional<T> item = Optional.ofNullable(this.grid.getDataCommunicator().getKeyMapper().get(this.grid.getElement().getProperty("_contextMenuTargetItemKey")));
        private final transient Optional<String> columnId = Optional.ofNullable(this.grid.getElement().getProperty("_contextMenuTargetColumnId"));

        public GridContextMenuOpenedEvent(GridContextMenu<T> source, boolean fromClient) {
            super(source, fromClient);
        }

        public Optional<T> getItem() {
            return this.item;
        }

        public Optional<String> getColumnId() {
            return this.columnId;
        }
    }

    public static class GridContextMenuItemClickEvent<T>
    extends ComponentEvent<GridMenuItem<T>> {
        private Grid<T> grid = (Grid)((GridContextMenu)((GridMenuItem)this.getSource()).getContextMenu()).getTarget();
        private transient Optional<T> item = Optional.ofNullable(this.grid.getDataCommunicator().getKeyMapper().get(this.grid.getElement().getProperty("_contextMenuTargetItemKey")));

        GridContextMenuItemClickEvent(GridMenuItem<T> source, boolean fromClient) {
            super(source, fromClient);
        }

        public Grid<T> getGrid() {
            return this.grid;
        }

        public Optional<T> getItem() {
            return this.item;
        }
    }
}

