/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.ColumnBase;
import com.vaadin.flow.component.grid.ColumnGroup;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.HtmlUtils;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

abstract class AbstractColumn<T extends AbstractColumn<T>>
extends Component
implements ColumnBase<T> {
    protected final Grid<?> grid;
    private boolean headerRenderingScheduled;
    private boolean footerRenderingScheduled;
    private boolean sortingIndicators;
    private String headerText;
    private Component headerComponent;
    private String footerText;
    private Component footerComponent;

    public AbstractColumn(Grid<?> grid) {
        this.grid = grid;
        this.addAttachListener((ComponentEventListener & Serializable)e -> {
            this.scheduleHeaderRendering();
            this.scheduleFooterRendering();
        });
    }

    public Grid<?> getGrid() {
        return this.grid;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private void scheduleHeaderRendering() {
        if (this.headerRenderingScheduled) {
            return;
        }
        this.headerRenderingScheduled = true;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            if (!this.headerRenderingScheduled) {
                return;
            }
            this.renderHeader();
            this.headerRenderingScheduled = false;
        }));
    }

    private void renderHeader() {
        String headerContent = this.headerComponent != null ? this.headerComponent.getElement() : this.headerText;
        boolean showSorter = this.hasSortingIndicators();
        String sorterPath = showSorter ? HtmlUtils.escape((String)this.getBottomLevelColumn().getInternalId()) : null;
        String jsExpression = "this.$connector.setHeaderRenderer($0, { content: $1, showSorter: $2, sorterPath: $3 });";
        if (this.headerComponent != null && !this.headerComponent.isVisible()) {
            this.grid.getElement().executeJs(jsExpression, new Object[]{this.getElement(), "", showSorter, sorterPath});
        }
        this.grid.getElement().executeJs(jsExpression, new Object[]{this.getElement(), headerContent, showSorter, sorterPath});
    }

    private void scheduleFooterRendering() {
        if (this.footerRenderingScheduled) {
            return;
        }
        this.footerRenderingScheduled = true;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            if (!this.footerRenderingScheduled) {
                return;
            }
            this.renderFooter();
            this.footerRenderingScheduled = false;
        }));
    }

    private void renderFooter() {
        String footerContent = this.footerComponent != null ? this.footerComponent.getElement() : this.footerText;
        this.grid.getElement().executeJs("this.$connector.setFooterRenderer($0, { content: $1 })", new Object[]{this.getElement(), footerContent});
    }

    public String getHeaderText() {
        return this.headerText;
    }

    protected void setHeaderText(String text) {
        this.setHeaderContent(text, null);
    }

    public String getFooterText() {
        return this.footerText;
    }

    protected void setFooterText(String text) {
        this.setFooterContent(text, null);
    }

    public Component getHeaderComponent() {
        return this.headerComponent;
    }

    protected void setHeaderComponent(Component component) {
        this.setHeaderContent(null, component);
    }

    public Component getFooterComponent() {
        return this.footerComponent;
    }

    protected void setFooterComponent(Component component) {
        this.setFooterContent(null, component);
    }

    void setHeaderContent(String text, Component component) {
        this.headerText = text;
        this.headerComponent = this.replaceChildComponent(this.headerComponent, component);
        this.scheduleHeaderRendering();
    }

    void setFooterContent(String text, Component component) {
        this.footerText = text;
        this.footerComponent = this.replaceChildComponent(this.footerComponent, component);
        this.scheduleFooterRendering();
    }

    private Component replaceChildComponent(Component oldComponent, Component newComponent) {
        if (oldComponent != null && oldComponent.getParent().isPresent() && oldComponent.getParent().get() == this) {
            this.getElement().removeVirtualChild(new Element[]{oldComponent.getElement()});
        }
        if (newComponent != null) {
            if (newComponent.getElement().getParent() != null) {
                newComponent.getElement().getParent().removeVirtualChild(new Element[]{newComponent.getElement()});
            }
            this.getElement().appendVirtualChild(new Element[]{newComponent.getElement()});
        }
        return newComponent;
    }

    protected void moveHeaderContent(AbstractColumn<?> otherColumn) {
        otherColumn.setHeaderContent(this.headerText, this.headerComponent);
        this.setHeaderContent(null, null);
    }

    protected void moveFooterContent(AbstractColumn<?> otherColumn) {
        otherColumn.setFooterContent(this.footerText, this.footerComponent);
        this.setFooterContent(null, null);
    }

    protected void updateSortingIndicators(boolean sortable) {
        if (sortable) {
            this.setSortingIndicators(this.getBottomLevelColumn().isSortable());
        } else {
            this.setSortingIndicators(false);
        }
    }

    protected void setSortingIndicators(boolean sortingIndicators) {
        if (this.sortingIndicators == sortingIndicators) {
            return;
        }
        this.sortingIndicators = sortingIndicators;
        this.scheduleHeaderRendering();
    }

    protected boolean hasSortingIndicators() {
        return this.sortingIndicators;
    }

    protected abstract Grid.Column<?> getBottomLevelColumn();

    protected List<Grid.Column<?>> getBottomChildColumns() {
        List<Grid.Column<?>> columnChildren = this.getChildren().filter(child -> child instanceof Grid.Column).map(child -> (Grid.Column)child).collect(Collectors.toList());
        columnChildren.addAll(this.getChildren().filter(child -> child instanceof ColumnGroup).flatMap(child -> ((ColumnGroup)child).getBottomChildColumns().stream()).collect(Collectors.toList()));
        return columnChildren;
    }
}

