/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.treegrid;

import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

class TreeGridDataCommunicator<T>
extends HierarchicalDataCommunicator<T> {
    private final Element element;

    public TreeGridDataCommunicator(Element element, CompositeDataGenerator<T> dataGenerator, ArrayUpdater arrayUpdater, SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier) {
        super(dataGenerator, arrayUpdater, element.getNode(), uniqueKeyProviderSupplier);
        this.element = element;
    }

    public void reset() {
        super.reset();
        if (this.element != null) {
            this.element.callJsFunction("$connector.reset", new Object[0]);
        }
    }

    public List<T> preloadFlatRangeForward(int start, int length) {
        return super.preloadFlatRangeForward(start, length);
    }

    public List<T> preloadFlatRangeBackward(int start, int length) {
        return super.preloadFlatRangeBackward(start, length);
    }

    public int resolveIndexPath(int ... path) {
        return super.resolveIndexPath(path);
    }

    public int[] resolveItem(T item) {
        List<T> ancestors = this.getAncestors(item);
        this.expand(ancestors);
        return this.getIndexPath(item, ancestors);
    }

    private int[] getIndexPath(T item, List<T> ancestors) {
        int itemIndex;
        ArrayList<Integer> path = new ArrayList<Integer>();
        if (this.getDataProvider().getHierarchyFormat().equals((Object)HierarchicalDataProvider.HierarchyFormat.NESTED)) {
            path.addAll(this.getAncestorPath(ancestors));
        }
        if ((itemIndex = this.getItemIndex(item, path.isEmpty() ? null : (T)ancestors.get(ancestors.size() - 1))) == -1) {
            throw new NoSuchElementException("Item does not exist.");
        }
        path.add(itemIndex);
        return path.stream().mapToInt(i -> i).toArray();
    }

    private List<T> getAncestors(T item) {
        LinkedList<T> ancestors = new LinkedList<T>();
        while ((item = this.getDataProvider().getParent(item)) != null) {
            ancestors.addFirst(item);
        }
        return ancestors;
    }

    private List<Integer> getAncestorPath(List<T> ancestors) {
        ArrayList<Integer> ancestorPath = new ArrayList<Integer>();
        for (int i = 0; i < ancestors.size(); ++i) {
            int ancestorIndex = this.getItemIndex(ancestors.get(i), i == 0 ? null : (T)ancestors.get(i - 1));
            if (ancestorIndex == -1) {
                throw new NoSuchElementException("Item does not exist.");
            }
            ancestorPath.add(ancestorIndex);
        }
        return ancestorPath;
    }

    private int getItemIndex(T item, T parent) {
        HierarchicalQuery query = this.buildQuery(parent, 0, Integer.MAX_VALUE);
        return this.getDataProvider().getItemIndex(item, query);
    }
}

