/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.SerializableRunnable;

@Tag(value="vaadin-grid-flow-selection-column")
@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.1.5")
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="./vaadin-grid-flow-selection-column.js")})
public class GridSelectionColumn
extends Component {
    private final SerializableRunnable selectAllCallback;
    private final SerializableRunnable deselectAllCallback;

    public GridSelectionColumn(SerializableRunnable selectAllCallback, SerializableRunnable deselectAllCallback) {
        this.selectAllCallback = selectAllCallback;
        this.deselectAllCallback = deselectAllCallback;
    }

    public void setSelectAllCheckboxState(boolean selectAll) {
        this.getElement().setProperty("selectAll", selectAll);
    }

    public void setSelectAllCheckboxIndeterminateState(boolean indeterminate) {
        this.getElement().setProperty("indeterminate", indeterminate);
    }

    public void setSelectAllCheckBoxVisibility(boolean visible) {
        this.getElement().setProperty("selectAllHidden", !visible);
    }

    public void setFrozen(boolean frozen) {
        this.getElement().setProperty("frozen", frozen);
    }

    @Synchronize(value={"frozen-changed"})
    public boolean isFrozen() {
        return this.getElement().getProperty("frozen", false);
    }

    @ClientCallable
    private void selectAll() {
        this.selectAllCallback.run();
    }

    @ClientCallable
    private void deselectAll() {
        this.deselectAllCallback.run();
    }
}

