/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.component.grid.AbstractRow;
import com.vaadin.flow.component.grid.ColumnLayer;
import com.vaadin.flow.component.grid.Grid;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class HeaderRow
extends AbstractRow<HeaderCell> {
    HeaderRow(ColumnLayer layer) {
        super(layer, HeaderCell::new);
    }

    @Override
    public HeaderCell join(Grid.Column<?> ... columnsToMerge) {
        return this.join((Collection)Arrays.stream(columnsToMerge).map(this::getCell).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    @Override
    public HeaderCell join(Collection<HeaderCell> cells) {
        Grid<?> grid = this.layer.getGrid();
        if (this.equals(grid.getDefaultHeaderRow())) {
            throw new UnsupportedOperationException("Cells cannot be joined on the first created header row. This row is used as the default row for setting column headers and for displaying sorting indicators, so each cell in it should have maximum one related column.");
        }
        return super.join(cells);
    }

    @Override
    protected boolean isOutmostRow() {
        List<ColumnLayer> layers = this.layer.getGrid().getColumnLayers();
        for (int i = layers.size() - 1; i >= 0; --i) {
            ColumnLayer layer = layers.get(i);
            if (!layer.isHeaderRow()) continue;
            return this.equals(layer.asHeaderRow());
        }
        return false;
    }

    public static class HeaderCell
    extends AbstractRow.AbstractCell {
        HeaderCell(AbstractColumn<?> column) {
            super(column);
            if (column.getHeaderRenderer() == null) {
                column.setHeaderText("");
            }
        }

        @Override
        public String getText() {
            return this.getColumn().getHeaderText();
        }

        @Override
        public void setText(String text) {
            this.getColumn().setHeaderText(text);
        }

        @Override
        public Component getComponent() {
            return this.getColumn().getHeaderComponent();
        }

        @Override
        public void setComponent(Component component) {
            this.getColumn().setHeaderComponent(component);
        }
    }
}

