/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.component.grid.ColumnBase;
import com.vaadin.flow.component.grid.ColumnLayer;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSelectionColumn;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;

class GridColumnOrderHelper<T> {
    private final Grid<T> grid;

    GridColumnOrderHelper(Grid<T> grid) {
        this.grid = Objects.requireNonNull(grid);
    }

    void setColumnOrder(List<Grid.Column<T>> columns) {
        Objects.requireNonNull(columns, "columns");
        HashSet<Grid.Column<T>> newColumns = new HashSet<Grid.Column<T>>(columns);
        if (newColumns.size() < columns.size()) {
            throw new IllegalArgumentException("A column is present multiple times in the list of columns: " + columns.stream().map(Grid.Column::getKey).collect(Collectors.joining(", ")));
        }
        List<Grid.Column<T>> currentColumns = this.grid.getColumns();
        if (newColumns.size() < currentColumns.size()) {
            String missingColumnKeys = currentColumns.stream().filter(col -> !newColumns.contains(col)).map(Grid.Column::getKey).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("The 'columns' list is missing the following columns: " + missingColumnKeys);
        }
        for (Grid.Column column : newColumns) {
            this.grid.ensureOwner(column);
        }
        List<String> newOrderIDs = columns.stream().map(Grid.Column::getInternalId).collect(Collectors.toList());
        GraphNodeLeafCache graphNodeLeafCache = new GraphNodeLeafCache();
        this.reorderColumnsAndConsumeIDs(this.grid, new IdQueue(newOrderIDs), graphNodeLeafCache, true);
        this.reorderColumnsAndConsumeIDs(this.grid, new IdQueue(newOrderIDs), graphNodeLeafCache, false);
        List<ColumnBase<?>> columnsPreOrder = this.getColumnsPreOrder();
        for (ColumnLayer columnLayer : this.grid.getColumnLayers()) {
            columnLayer.updateColumnOrder(columnsPreOrder);
        }
        this.grid.getElement().executeJs("this._updateOrders(this._columnTree, null)", new Serializable[0]);
    }

    private List<ColumnBase<?>> getColumnsPreOrder() {
        return this.getColumnsPreOrder(this.grid);
    }

    private List<ColumnBase<?>> getColumnsPreOrder(Component parent) {
        ArrayList list = new ArrayList();
        if (parent instanceof AbstractColumn) {
            list.add((ColumnBase)parent);
        }
        parent.getChildren().filter(col -> col instanceof AbstractColumn).forEach(col -> list.addAll(this.getColumnsPreOrder((Component)col)));
        return list;
    }

    private void reorderColumnsAndConsumeIDs(Component column, IdQueue unconsumedIDs, GraphNodeLeafCache nodeLeafCache, boolean dryRun) {
        Objects.requireNonNull(column);
        if (column instanceof Grid.Column) {
            unconsumedIDs.consumeIdFor((Grid.Column)column);
            return;
        }
        HashSet childColumns = new HashSet();
        column.getChildren().filter(c -> !(c instanceof GridSelectionColumn)).forEach(it -> childColumns.add((AbstractColumn)it));
        ArrayList newOrder = new ArrayList();
        while (!childColumns.isEmpty()) {
            String id = unconsumedIDs.element();
            AbstractColumn<?> child = nodeLeafCache.findFirstContaining(id, childColumns);
            if (child == null) {
                throw new IllegalArgumentException(this.dumpColumnHierarchyFromDOM() + ": Cannot reorder columns, at ID: " + unconsumedIDs);
            }
            this.reorderColumnsAndConsumeIDs(child, unconsumedIDs, nodeLeafCache, dryRun);
            childColumns.remove(child);
            newOrder.add(child);
        }
        if (!dryRun) {
            newOrder.forEach(it -> it.getElement().removeFromParent());
            newOrder.forEach(it -> {
                Element cfr_ignored_0 = (Element)column.getElement().appendChild(new Element[]{it.getElement()});
            });
        }
    }

    private String dumpColumnHierarchyFromDOM() {
        return this.dumpColumnHierarchyFromDOM(this.grid);
    }

    private String dumpColumnHierarchyFromDOM(Component component) {
        return component.getChildren().map(child -> {
            if (child instanceof Grid.Column) {
                return ((Grid.Column)child).getInternalId() + "/" + ((Grid.Column)child).getKey();
            }
            return "(" + this.dumpColumnHierarchyFromDOM((Component)child) + ")";
        }).collect(Collectors.joining(", "));
    }

    private static class GraphNodeLeafCache {
        private final Map<Component, Set<String>> nodeLeafsCache = new HashMap<Component, Set<String>>();

        private GraphNodeLeafCache() {
        }

        private Set<String> getColumnIDs(Component component) {
            Objects.requireNonNull(component);
            if (this.nodeLeafsCache.get(component) == null) {
                Set<String> computeNodeLeafs = this.computeNodeLeafs(component);
                if (computeNodeLeafs != null) {
                    this.nodeLeafsCache.put(component, computeNodeLeafs);
                } else {
                    return new HashSet<String>();
                }
            }
            return this.nodeLeafsCache.get(component);
        }

        public AbstractColumn<?> findFirstContaining(String columnID, Collection<AbstractColumn<?>> columns) {
            Objects.requireNonNull(columnID);
            for (AbstractColumn<?> column : columns) {
                if (!this.getColumnIDs(column).contains(columnID)) continue;
                return column;
            }
            return null;
        }

        private Set<String> computeNodeLeafs(Component component) {
            if (component instanceof Grid.Column) {
                return Collections.singleton(((Grid.Column)component).getInternalId());
            }
            if (component instanceof Grid || component instanceof AbstractColumn) {
                return component.getChildren().filter(col -> col instanceof AbstractColumn).flatMap(col -> this.getColumnIDs((Component)col).stream()).collect(Collectors.toSet());
            }
            throw new IllegalArgumentException("Parameter component: invalid value " + component + ": must be Grid or AbstractColumn");
        }
    }

    private class IdQueue {
        private final String originalIDs;
        private final Queue<String> unconsumedIDs;

        public IdQueue(Collection<String> internalIDs) {
            this.unconsumedIDs = new LinkedList<String>(internalIDs);
            this.originalIDs = String.join((CharSequence)", ", internalIDs);
        }

        public String toString() {
            return this.unconsumedIDs.toString();
        }

        public String element() {
            if (this.unconsumedIDs.isEmpty()) {
                throw new IllegalArgumentException(GridColumnOrderHelper.this.dumpColumnHierarchyFromDOM() + ": all IDs have been consumed but there are still columns left. Original set of IDs: " + this.originalIDs);
            }
            return this.unconsumedIDs.element();
        }

        public void consumeIdFor(Grid.Column<T> column) {
            if (!this.element().equals(column.getInternalId())) {
                throw new IllegalArgumentException(GridColumnOrderHelper.this.dumpColumnHierarchyFromDOM() + ": Cannot reorder columns at ID: " + this.unconsumedIDs);
            }
            this.unconsumedIDs.remove();
        }
    }
}

