/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.component.grid.GridArrayUpdater;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CommunicationController;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchyMapper;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeUpdate;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.Range;
import com.vaadin.flow.internal.StateNode;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class HierarchicalDataCommunicator<T>
extends DataCommunicator<T> {
    private final GridArrayUpdater arrayUpdater;
    private final StateNode stateNode;
    private HierarchyMapper<T, ?> mapper;
    private DataGenerator<T> dataGenerator;
    private final SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier;
    private final Map<String, CommunicationController<T>> dataControllers = new HashMap<String, CommunicationController<T>>();
    private KeyMapper<T> uniqueKeyMapper = new KeyMapper<T>(){
        private T object;

        public String key(T o) {
            this.object = o;
            try {
                String string = super.key(o);
                return string;
            }
            finally {
                this.object = null;
            }
        }

        protected String createKey() {
            return Optional.ofNullable(HierarchicalDataCommunicator.this.uniqueKeyProviderSupplier.get()).map(provider -> (String)provider.apply(this.object)).orElse(super.createKey());
        }
    };

    public HierarchicalDataCommunicator(CompositeDataGenerator<T> dataGenerator, GridArrayUpdater arrayUpdater, SerializableConsumer<JsonArray> dataUpdater, StateNode stateNode, SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier) {
        super(dataGenerator, (ArrayUpdater)arrayUpdater, dataUpdater, stateNode);
        this.dataGenerator = dataGenerator;
        this.arrayUpdater = arrayUpdater;
        this.stateNode = stateNode;
        this.uniqueKeyProviderSupplier = uniqueKeyProviderSupplier;
        try {
            Field keyMapperField = DataCommunicator.class.getDeclaredField("keyMapper");
            keyMapperField.setAccessible(true);
            keyMapperField.set((Object)this, this.uniqueKeyMapper);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Error accessing the keyMapper field", e);
        }
        dataGenerator.addDataGenerator(this::generateTreeData);
        this.setDataProvider(new TreeDataProvider(new TreeData()), (Object)null);
    }

    private void generateTreeData(T item, JsonObject jsonObject) {
        Optional.ofNullable(this.getParentItem(item)).ifPresent(parent -> jsonObject.put("parentUniqueKey", (String)((ValueProvider)this.uniqueKeyProviderSupplier.get()).apply(parent)));
    }

    private void requestFlush(TreeUpdate update) {
        SerializableConsumer & Serializable flushRequest = (SerializableConsumer & Serializable)context -> update.commit();
        this.stateNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.stateNode, flushRequest));
    }

    private void requestFlush(CommunicationController<T> update) {
        SerializableConsumer & Serializable flushRequest = (SerializableConsumer & Serializable)context -> update.flush();
        this.stateNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.stateNode, flushRequest));
    }

    public void reset() {
        super.reset();
        if (!this.dataControllers.isEmpty()) {
            this.dataControllers.values().forEach(CommunicationController::unregisterPassivatedKeys);
            this.dataControllers.clear();
            TreeUpdate update = (TreeUpdate)this.arrayUpdater.startUpdate(this.getHierarchyMapper().getRootSize());
            update.enqueue("$connector.ensureHierarchy", new Serializable[0]);
            this.requestFlush(update);
        }
    }

    public Stream<T> fetchFromProvider(int offset, int limit) {
        return this.mapper.fetchRootItems(Range.withLength((int)offset, (int)limit));
    }

    public void setParentRequestedRange(int start, int length, T parentItem) {
        String parentKey = (String)((ValueProvider)this.uniqueKeyProviderSupplier.get()).apply(parentItem);
        CommunicationController controller = this.dataControllers.computeIfAbsent(parentKey, key -> new CommunicationController<T>(parentKey, this.getKeyMapper(), this.mapper, this.dataGenerator, (SerializableFunction<Integer, TreeUpdate>)(SerializableFunction & Serializable)size -> (TreeUpdate)this.arrayUpdater.startUpdate(this.getDataProviderSize()), (SerializableBiFunction & Serializable)(pkey, range) -> this.mapper.fetchChildItems(this.getKeyMapper().get(pkey), (Range)range)));
        controller.setRequestRange(start, length);
        this.requestFlush(controller);
    }

    public HierarchicalDataProvider<T, ?> getDataProvider() {
        return (HierarchicalDataProvider)super.getDataProvider();
    }

    public <F> SerializableConsumer<F> setDataProvider(HierarchicalDataProvider<T, F> dataProvider, F initialFilter) {
        SerializableConsumer consumer = super.setDataProvider(dataProvider, initialFilter);
        if (this.mapper != null) {
            this.mapper.destroyAllData();
        }
        this.mapper = this.createHierarchyMapper(dataProvider);
        this.mapper.setBackEndSorting(this.getBackEndSorting());
        this.mapper.setInMemorySorting((Comparator<T>)this.getInMemorySorting());
        this.mapper.setFilter(this.getFilter());
        return consumer;
    }

    protected <F> HierarchyMapper<T, F> createHierarchyMapper(HierarchicalDataProvider<T, F> dataProvider) {
        return new HierarchyMapper<T, F>(dataProvider);
    }

    public <F> SerializableConsumer<F> setDataProvider(DataProvider<T, F> dataProvider, F initialFilter) {
        if (dataProvider instanceof HierarchicalDataProvider) {
            return this.setDataProvider((HierarchicalDataProvider)dataProvider, initialFilter);
        }
        throw new IllegalArgumentException("Only " + HierarchicalDataProvider.class.getName() + " and subtypes supported.");
    }

    public void confirmUpdate(int id, String parentKey) {
        Optional.ofNullable(this.dataControllers.get(parentKey)).ifPresent(controller -> {
            controller.confirmUpdate(id);
            this.requestFlush((CommunicationController<T>)controller);
        });
    }

    public void collapse(T item) {
        this.collapse(item, true);
    }

    protected void collapse(T item, boolean syncClient) {
        this.doCollapse(Arrays.asList(item), syncClient);
    }

    public Collection<T> collapse(Collection<T> items) {
        return this.doCollapse(items, true);
    }

    private Collection<T> doCollapse(Collection<T> items, boolean syncClient) {
        ArrayList collapsedItems = new ArrayList();
        items.forEach(item -> {
            if (this.mapper.collapse(item)) {
                collapsedItems.add(item);
                CommunicationController<T> controller = this.dataControllers.remove(this.getKeyMapper().key(item));
                if (controller != null) {
                    controller.unregisterPassivatedKeys();
                }
            }
        });
        if (syncClient && !collapsedItems.isEmpty()) {
            TreeUpdate update = (TreeUpdate)this.arrayUpdater.startUpdate(this.getHierarchyMapper().getRootSize());
            update.enqueue("$connector.collapseItems", (Serializable)collapsedItems.stream().map(this::generateJsonForExpandedOrCollapsedItem).collect(JsonUtils.asArray()));
            this.requestFlush(update);
        }
        return collapsedItems;
    }

    public void expand(T item) {
        this.expand(item, true);
    }

    public Collection<T> expand(Collection<T> items) {
        return this.doExpand(items, true);
    }

    protected void expand(T item, boolean syncClient) {
        this.doExpand(Arrays.asList(item), syncClient);
    }

    private Collection<T> doExpand(Collection<T> items, boolean syncClient) {
        ArrayList expandedItems = new ArrayList();
        items.forEach(item -> {
            if (this.mapper.expand(item)) {
                expandedItems.add(item);
            }
        });
        if (syncClient && !expandedItems.isEmpty()) {
            TreeUpdate update = (TreeUpdate)this.arrayUpdater.startUpdate(this.getHierarchyMapper().getRootSize());
            update.enqueue("$connector.expandItems", (Serializable)expandedItems.stream().map(this::generateJsonForExpandedOrCollapsedItem).collect(JsonUtils.asArray()));
            this.requestFlush(update);
        }
        return expandedItems;
    }

    public boolean hasChildren(T item) {
        return this.mapper.hasChildren(item);
    }

    public boolean isExpanded(T item) {
        return this.mapper.isExpanded(item);
    }

    public Integer getParentIndex(T item) {
        return this.mapper.getParentIndex(item);
    }

    public Integer getIndex(T item) {
        return Optional.ofNullable(this.mapper.getIndex(item)).filter(index -> index >= 0).orElse(null);
    }

    public T getParentItem(T item) {
        return this.mapper.getParentOfItem(item);
    }

    public int getDepth(T item) {
        return this.mapper.getDepth(item);
    }

    public int getDataProviderSize() {
        return this.mapper.getRootSize();
    }

    public void setBackEndSorting(List<QuerySortOrder> sortOrder) {
        if (this.mapper != null) {
            this.mapper.setBackEndSorting(sortOrder);
        }
        super.setBackEndSorting(sortOrder);
    }

    public void setInMemorySorting(SerializableComparator<T> comparator) {
        if (this.mapper != null) {
            this.mapper.setInMemorySorting((Comparator<T>)comparator);
        }
        super.setInMemorySorting(comparator);
    }

    protected <F> void setFilter(F filter) {
        if (this.mapper != null) {
            this.mapper.setFilter(filter);
        }
    }

    public boolean hasExpandedItems() {
        return this.mapper.hasExpandedItems();
    }

    protected HierarchyMapper<T, ?> getHierarchyMapper() {
        return this.mapper;
    }

    private JsonValue generateJsonForExpandedOrCollapsedItem(T item) {
        JsonObject json = Json.createObject();
        json.put("key", this.getKeyMapper().key(item));
        return json;
    }
}

