/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.component.grid.FooterRow;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class ColumnLayer
implements Serializable {
    private Grid<?> grid;
    private List<AbstractColumn<?>> columns;
    private HeaderRow headerRow;
    private FooterRow footerRow;

    ColumnLayer(Grid<?> grid) {
        this.grid = grid;
        this.columns = new ArrayList();
    }

    ColumnLayer(Grid<?> grid, List<AbstractColumn<?>> columns) {
        this.grid = grid;
        this.columns = columns;
    }

    protected void addColumn(AbstractColumn<?> column) {
        this.addColumn(this.columns.size(), column);
    }

    protected void addColumn(int index, AbstractColumn<?> column) {
        this.columns.add(index, column);
        if (this.isHeaderRow()) {
            this.headerRow.addCell(index, column);
        }
        if (this.isFooterRow()) {
            this.footerRow.addCell(index, column);
        }
    }

    protected void removeColumn(AbstractColumn<?> column) {
        this.columns.remove(column);
        if (this.isHeaderRow()) {
            this.asHeaderRow().removeCell(column);
        }
        if (this.isFooterRow()) {
            this.asFooterRow().removeCell(column);
        }
    }

    protected HeaderRow asHeaderRow() {
        if (this.headerRow == null) {
            this.headerRow = new HeaderRow(this);
            this.columns.forEach(col -> col.setHeaderText(""));
        }
        return this.headerRow;
    }

    protected FooterRow asFooterRow() {
        if (this.footerRow == null) {
            this.footerRow = new FooterRow(this);
            this.columns.forEach(col -> col.setFooterText(""));
        }
        return this.footerRow;
    }

    protected void setHeaderRow(HeaderRow headerRow) {
        this.headerRow = headerRow;
        if (headerRow != null) {
            headerRow.setLayer(this);
        }
    }

    protected void setFooterRow(FooterRow footerRow) {
        this.footerRow = footerRow;
        if (footerRow != null) {
            footerRow.setLayer(this);
        }
    }

    protected boolean isHeaderRow() {
        return this.headerRow != null;
    }

    protected boolean isFooterRow() {
        return this.footerRow != null;
    }

    protected Grid<?> getGrid() {
        return this.grid;
    }

    protected void setColumns(List<AbstractColumn<?>> columns) {
        this.columns = columns;
        if (this.headerRow != null) {
            this.headerRow.setColumns(columns);
        }
        if (this.footerRow != null) {
            this.footerRow.setColumns(columns);
        }
    }

    protected List<AbstractColumn<?>> getColumns() {
        return this.columns;
    }

    protected void updateSortingIndicators(boolean sortingIndicators) {
        this.columns.forEach(col -> col.updateSortingIndicators(sortingIndicators));
    }
}

