/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;

public final class DataProviderListenersTest {
    private DataProviderListenersTest() {
    }

    public static <C extends HasListDataView<Object, ?>> void checkOldListenersRemovedOnComponentAttachAndDetach(C component, int expectedListenersCountAfterDataProviderSetup, int expectedListenersCountAfterComponentAttach, int[] expectedRemovedListenerIndexes, UI mockUI) {
        DataProviderProxy dataProviderProxy = new DataProviderProxy();
        component.setItems((ListDataProvider)dataProviderProxy);
        Assert.assertEquals((String)"Unexpected count of added data provider listeners after setting a data provider to the component", (long)expectedListenersCountAfterDataProviderSetup, (long)dataProviderProxy.getListenersCounter());
        dataProviderProxy.resetListenersCounter();
        mockUI.add(new Component[]{(Component)component});
        DataProviderListenersTest.fakeClientCommunication(mockUI);
        Assert.assertEquals((String)"Unexpected count of added data provider listeners after attaching the component", (long)expectedListenersCountAfterComponentAttach, (long)dataProviderProxy.getListenersCounter());
        mockUI.remove(new Component[]{(Component)component});
        DataProviderListenersTest.fakeClientCommunication(mockUI);
        Arrays.stream(expectedRemovedListenerIndexes).forEach(listenerIndex -> Assert.assertTrue((String)String.format("Expected old data provider listener with index '%d' to be removed", listenerIndex), (boolean)dataProviderProxy.getListenerRemoved().get(listenerIndex)));
    }

    private static void fakeClientCommunication(UI ui) {
        ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        ui.getInternals().getStateTree().collectChanges(ignore -> {});
    }

    private static class DataProviderProxy
    extends ListDataProvider<Object> {
        private final List<Boolean> listenerRemoved;
        private int listenersCounter = 0;
        private int registrationsCounter = 0;

        public DataProviderProxy() {
            super(Collections.emptyList());
            int maxListenerNumberExpected = 4;
            this.listenerRemoved = Stream.of(new Boolean[4]).map(item -> Boolean.FALSE).collect(Collectors.toList());
        }

        public Registration addDataProviderListener(DataProviderListener<Object> listener) {
            ++this.listenersCounter;
            int registrationIndex = this.registrationsCounter++;
            Registration registration = super.addDataProviderListener(listener);
            return Registration.combine((Registration[])new Registration[]{registration, (Registration & Serializable)() -> this.listenerRemoved.set(registrationIndex, Boolean.TRUE)});
        }

        public int getListenersCounter() {
            return this.listenersCounter;
        }

        public List<Boolean> getListenerRemoved() {
            return this.listenerRemoved;
        }

        public void resetListenersCounter() {
            this.listenersCounter = 0;
        }
    }
}

