/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.ScreenshotOnFailureRule;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.W3CHttpCommandCodec;
import org.openqa.selenium.remote.http.W3CHttpResponseCodec;

public class SharedBrowser {
    private static final boolean browserReuseAllowed = Boolean.getBoolean(SharedBrowser.class.getName() + ".reuseBrowser");
    private static final boolean browserHeadless = !Boolean.getBoolean("disableHeadless");
    private static Logger logger = Logger.getLogger(SharedBrowser.class.getName());
    URL url;
    SessionId sessionId;
    private volatile TestBenchDriverProxy driver;

    SharedBrowser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TestBenchDriverProxy getDriver(DriverSupplier driverSupplier) throws Exception {
        if (this.driver == null) {
            SharedBrowser sharedBrowser = this;
            synchronized (sharedBrowser) {
                if (this.driver == null) {
                    this.useDriver(driverSupplier.getDriver());
                    return this.driver;
                }
            }
        }
        return this.createDriverFromSession(this.sessionId, this.url);
    }

    void clear() {
        if (this.driver == null) {
            return;
        }
        logger.log(Level.FINE, String.format("Clearing driver for session %s\turl %s", this.sessionId, this.url));
        this.driver.quit();
        this.driver = null;
        this.sessionId = null;
        this.url = null;
    }

    void setup(ISetup realSetup, DriverConsumer setDriver, DriverSupplier getDriver, ScreenshotOnFailureRule screenshotOnFailure) throws Exception {
        if (!browserReuseAllowed || Parameters.getTestsInParallel() != 1) {
            realSetup.setup();
        } else {
            screenshotOnFailure.setQuitDriverOnFinish(false);
            TestBenchDriverProxy driver = this.getDriver(() -> {
                if (Parameters.isLocalWebDriverUsed()) {
                    ChromeOptions chromeOptions = new ChromeOptions();
                    if (browserHeadless) {
                        chromeOptions.addArguments(new String[]{"--headless", "--disable-gpu"});
                    }
                    return TestBench.createDriver((WebDriver)new ChromeDriver(chromeOptions));
                }
                realSetup.setup();
                return getDriver.getDriver();
            });
            setDriver.setDriver((WebDriver)driver);
        }
    }

    private TestBenchDriverProxy createDriverFromSession(final SessionId sessionId, URL command_executor) {
        HttpCommandExecutor executor = new HttpCommandExecutor(command_executor){

            public Response execute(Command command) throws IOException {
                Response response = null;
                if (command.getName() == "newSession") {
                    SharedBrowser.this.driver.manage().deleteAllCookies();
                    if (SharedBrowser.this.driver instanceof WebStorage) {
                        ((WebStorage)SharedBrowser.this.driver).getSessionStorage().clear();
                        ((WebStorage)SharedBrowser.this.driver).getLocalStorage().clear();
                    }
                    SharedBrowser.this.driver.manage().logs().get("browser").getAll();
                    SharedBrowser.this.driver.get("about:blank");
                    response = new Response();
                    response.setSessionId(sessionId.toString());
                    response.setStatus(Integer.valueOf(0));
                    response.setValue(Collections.emptyMap());
                    try {
                        Field commandCodec = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("commandCodec");
                        commandCodec.setAccessible(true);
                        commandCodec.set((Object)this, new W3CHttpCommandCodec());
                        Field responseCodec = null;
                        responseCodec = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("responseCodec");
                        responseCodec.setAccessible(true);
                        responseCodec.set((Object)this, new W3CHttpResponseCodec());
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                } else {
                    response = super.execute(command);
                }
                return response;
            }
        };
        logger.log(Level.FINE, String.format("Reusing driver for session %s\turl %s", sessionId, this.url));
        RemoteWebDriver driver = new RemoteWebDriver((CommandExecutor)executor, (Capabilities)new DesiredCapabilities());
        return TestBench.createDriver((WebDriver)driver);
    }

    private void useDriver(WebDriver currentDriver) {
        this.driver = (TestBenchDriverProxy)currentDriver;
        RemoteWebDriver webDriver = (RemoteWebDriver)this.driver.getWrappedDriver();
        HttpCommandExecutor executor = (HttpCommandExecutor)webDriver.getCommandExecutor();
        this.url = executor.getAddressOfRemoteServer();
        this.sessionId = webDriver.getSessionId();
        logger.log(Level.FINE, String.format("Creating driver for session %s\turl %s", this.sessionId, this.url));
    }

    public Optional<List<DesiredCapabilities>> getGridBrowsers() {
        List result = Parameters.getGridBrowsers();
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    @FunctionalInterface
    static interface DriverConsumer {
        public void setDriver(WebDriver var1) throws Exception;
    }

    @FunctionalInterface
    static interface DriverSupplier {
        public WebDriver getDriver() throws Exception;
    }

    @FunctionalInterface
    static interface ISetup {
        public void setup() throws Exception;
    }
}

