/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import java.io.Serializable;

public class ValidationController<C extends Component & HasValidation, V>
implements Serializable {
    private C component;
    private boolean manualValidationEnabled;
    private String lastValidationResultErrorMessage;

    public ValidationController(C component) {
        this.component = component;
    }

    public void setManualValidation(boolean enabled) {
        this.manualValidationEnabled = enabled;
    }

    public void validate(V value) {
        if (this.manualValidationEnabled) {
            return;
        }
        Validator validator = ((HasValidator)this.component).getDefaultValidator();
        ValidationResult result = validator.apply(value, null);
        if (result.isError()) {
            this.setComponentInvalid(true);
            this.setComponentErrorMessage(result.getErrorMessage());
        } else {
            this.setComponentInvalid(false);
            this.setComponentErrorMessage("");
        }
    }

    private void setComponentInvalid(boolean invalid) {
        ((HasValidation)this.component).setInvalid(invalid);
    }

    private void setComponentErrorMessage(String errorMessage) {
        boolean hasCustomErrorMessage;
        boolean bl = hasCustomErrorMessage = ((HasValidation)this.component).getErrorMessage() != null && !((HasValidation)this.component).getErrorMessage().isEmpty() && !((HasValidation)this.component).getErrorMessage().equals(this.lastValidationResultErrorMessage);
        if (!hasCustomErrorMessage) {
            ((HasValidation)this.component).setErrorMessage(errorMessage);
        }
        this.lastValidationResultErrorMessage = errorMessage;
    }
}

