/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.vaadin.base.devserver.stats.JsonHelpers;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class StatisticsContainer {
    private ObjectNode json;

    public StatisticsContainer(ObjectNode json) {
        this.json = json;
    }

    public void setValue(String name, String value) {
        this.json.put(name, value);
    }

    public void setValue(String name, long value) {
        this.json.put(name, value);
    }

    public void setValue(String name, JsonNode value) {
        this.json.set(name, value);
    }

    public void increment(String name) {
        JsonHelpers.incrementJsonValue(this.json, name);
    }

    public void aggregate(String name, double newValue) {
        JsonHelpers.incrementJsonValue(this.json, name + "_count");
        double count = this.json.get(name + "_count").asInt();
        double min = newValue;
        if (this.json.has(name + "_min") && this.json.get(name + "_min").isDouble()) {
            min = this.json.get(name + "_min").asDouble(newValue);
        }
        this.json.put(name + "_min", Math.min(newValue, min));
        double max = newValue;
        if (this.json.has(name + "_max") && this.json.get(name + "_max").isDouble()) {
            max = this.json.get(name + "_max").asDouble(newValue);
        }
        this.json.put(name + "_max", Math.max(newValue, max));
        double avg = newValue;
        if (this.json.has(name + "_avg") && this.json.get(name + "_avg").isDouble()) {
            avg = this.json.get(name + "_avg").asDouble(newValue);
            avg += (newValue - avg) / count;
        }
        this.json.put(name + "_avg", avg);
        this.json.put(name, newValue);
    }

    public String getValue(String name) {
        return this.json.get(name).asString();
    }

    int getValueAsInt(String name) {
        if (this.json.has(name) && this.json.get(name).isInt()) {
            return this.json.get(name).asInt(0);
        }
        return 0;
    }

    public double getValueAsDouble(String name) {
        if (this.json.has(name) && this.json.get(name).isDouble()) {
            return this.json.get(name).asDouble(0.0);
        }
        return 0.0;
    }
}

