/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.NamedDaemonThreadFactory;
import com.vaadin.flow.function.SerializableConsumer;
import io.methvin.watcher.DirectoryWatcher;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher {
    private DirectoryWatcher watcher;
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new NamedDaemonThreadFactory("vaadin-file-watcher"));

    public FileWatcher(SerializableConsumer<File> onChangeConsumer, File watchDirectory) throws IOException {
        Objects.requireNonNull(watchDirectory, "Watch directory cannot be null");
        Objects.requireNonNull(onChangeConsumer, "Change listener cannot be null");
        this.watcher = DirectoryWatcher.builder().path(watchDirectory.toPath()).listener(e -> onChangeConsumer.accept((Object)e.path().toFile())).build();
    }

    public void start() {
        this.watcher.watchAsync((Executor)executorService).exceptionally(e -> {
            FileWatcher.getLogger().error("Error starting file watcher", e);
            return null;
        });
    }

    public void stop() throws IOException {
        this.watcher.close();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FileWatcher.class);
    }
}

