/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.base.devserver.ServerInfo;
import com.vaadin.base.devserver.stats.JsonHelpers;
import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.base.devserver.stats.StatisticsSender;
import com.vaadin.base.devserver.stats.StatisticsStorage;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.Version;
import com.vaadin.pro.licensechecker.MachineId;
import elemental.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevModeUsageStatistics {
    private static DevModeUsageStatistics instance = null;
    private final StatisticsStorage storage;
    private final File projectFolder;

    private DevModeUsageStatistics(File projectFolder, StatisticsStorage storage) {
        this.projectFolder = projectFolder;
        this.storage = storage;
    }

    static DevModeUsageStatistics get() {
        return instance;
    }

    public static DevModeUsageStatistics init(File projectFolder, StatisticsStorage storage, StatisticsSender sender) {
        DevModeUsageStatistics.getLogger().debug("Telemetry enabled");
        storage.access((Command & Serializable)() -> {
            instance = new DevModeUsageStatistics(projectFolder, storage);
            String projectId = ProjectHelpers.generateProjectId(projectFolder);
            storage.setProjectId(projectId);
            instance.trackGlobalData();
            sender.triggerSendIfNeeded(storage.read());
        });
        return instance;
    }

    private void trackGlobalData() {
        this.storage.update((globalData, projectData) -> {
            globalData.setValue("os", ServerInfo.fetchOperatingSystem());
            globalData.setValue("jvm", ServerInfo.fetchJavaVersion());
            globalData.setValue("proKey", ProjectHelpers.getProKey());
            globalData.setValue("userKey", ProjectHelpers.getUserKey());
            try {
                globalData.setValue("machineId", MachineId.get());
            }
            catch (Throwable ex) {
                globalData.setValue("machineId", "ERROR");
                DevModeUsageStatistics.getLogger().debug("Cannot get Machine ID", ex);
            }
            projectData.setValue("flowVersion", Version.getFullVersion());
            projectData.setValue("vaadinVersion", ServerInfo.fetchVaadinVersion());
            projectData.setValue("hillaVersion", ServerInfo.fetchHillaVersion());
            projectData.setValue("sourceId", ProjectHelpers.getProjectSource(this.projectFolder));
            projectData.increment("devModeStarts");
        });
    }

    public static void handleBrowserData(JsonObject data) {
        DevModeUsageStatistics.getLogger().debug("Received client usage statistics from the browser");
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        DevModeUsageStatistics.get().storage.update((global, project) -> {
            try {
                String json = data.get("browserData").toJson();
                JsonNode clientData = JsonHelpers.getJsonMapper().readTree(json);
                if (clientData != null && clientData.isObject()) {
                    clientData.fields().forEachRemaining(e -> project.setValue((String)e.getKey(), (JsonNode)e.getValue()));
                }
            }
            catch (Exception e2) {
                DevModeUsageStatistics.getLogger().debug("Failed to update client telemetry data", (Throwable)e2);
            }
        });
    }

    static boolean isStatisticsEnabled() {
        return instance != null;
    }

    public static void collectEvent(String name) {
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        try {
            DevModeUsageStatistics.get().storage.update((global, project) -> project.increment(name));
        }
        catch (Exception e) {
            DevModeUsageStatistics.getLogger().debug("Failed to log '" + name + "'", (Throwable)e);
        }
    }

    public static void collectEvent(String name, double value) {
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        try {
            DevModeUsageStatistics.get().storage.update((global, project) -> project.aggregate(name, value));
        }
        catch (Exception e) {
            DevModeUsageStatistics.getLogger().debug("Failed to collect event '" + name + "'", (Throwable)e);
        }
    }

    public void set(String name, String value) {
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        try {
            this.storage.update((global, project) -> project.setValue(name, value));
        }
        catch (Exception e) {
            DevModeUsageStatistics.getLogger().debug("Failed to set  '" + name + "'", (Throwable)e);
        }
    }

    public void setGlobal(String name, String value) {
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        try {
            this.storage.update((global, project) -> global.setValue(name, value));
        }
        catch (Exception e) {
            DevModeUsageStatistics.getLogger().debug("Failed to set global '" + name + "'", (Throwable)e);
        }
    }

    static Logger getLogger() {
        return LoggerFactory.getLogger(DevModeUsageStatistics.class);
    }
}

