/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.DevServerOutputTracker;
import com.vaadin.base.devserver.DevServerWatchDog;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.NetworkUtil;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.StaticFileServer;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDevServerRunner
implements DevModeHandler {
    private static final String START_FAILURE = "Couldn't start dev server because";
    public static final String DEV_SERVER_HOST = "http://127.0.0.1";
    private static final String FAILED_MSG = "\n------------------ Frontend compilation failed. ------------------\n\n";
    private static final String SUCCEED_MSG = "\n----------------- Frontend compiled successfully. -----------------\n\n";
    private static final String START = "\n------------------ Starting Frontend compilation. ------------------\n";
    private static final String LOG_START = "Running {} to compile frontend resources. This may take a moment, please stand by...";
    private static final String DEFAULT_TIMEOUT_FOR_PATTERN = "60000";
    private static final String DEV_SERVER_PORTFILE_UUID_PROPERTY = "vaadin.frontend.devserver.portfile.uuid";
    private static final Pattern WEBPACK_ILLEGAL_CHAR_PATTERN = Pattern.compile("\"|%22");
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final int DEFAULT_TIMEOUT = 120000;
    private final File npmFolder;
    private volatile int port;
    private final AtomicReference<Process> devServerProcess = new AtomicReference();
    private final boolean reuseDevServer;
    private final File devServerPortFile;
    private AtomicBoolean isDevServerFailedToStart = new AtomicBoolean();
    private final CompletableFuture<Void> devServerStartFuture;
    private final AtomicReference<DevServerWatchDog> watchDog = new AtomicReference();
    private boolean usingAlreadyStartedProcess = false;
    private ApplicationConfiguration applicationConfiguration;
    private String failedOutput = null;
    private transient Runnable waitForRestart;

    protected AbstractDevServerRunner(Lookup lookup, int runningPort, File npmFolder, CompletableFuture<Void> waitFor) {
        this.npmFolder = npmFolder;
        this.port = runningPort;
        this.applicationConfiguration = (ApplicationConfiguration)lookup.lookup(ApplicationConfiguration.class);
        this.reuseDevServer = this.applicationConfiguration.reuseDevServer();
        this.devServerPortFile = AbstractDevServerRunner.getDevServerPortFile(npmFolder);
        BiConsumer<Void, Throwable> action = (value, exception) -> {
            waitFor.getNow(null);
            this.runOnFutureComplete();
        };
        this.devServerStartFuture = waitFor.whenCompleteAsync((BiConsumer)action);
    }

    private void runOnFutureComplete() {
        try {
            this.doStartDevModeServer();
        }
        catch (ExecutionFailedException exception) {
            AbstractDevServerRunner.getLogger().error(null, (Throwable)exception);
            throw new CompletionException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartDevModeServer() throws ExecutionFailedException {
        this.waitForRestart = DevServerOutputTracker.activeServerRestartGuard();
        if (this.waitForRestart != null) {
            AbstractDevServerRunner.getLogger().debug("RestartMonitor is active");
        }
        if (this.port > 0) {
            if (!this.checkConnection()) {
                throw new IllegalStateException(String.format("%s %s port '%d' is defined but it's not working properly", this.getServerName(), START_FAILURE, this.port));
            }
            this.reuseExistingPort(this.port);
            return;
        }
        this.port = AbstractDevServerRunner.getRunningDevServerPort(this.npmFolder);
        if (this.port > 0) {
            if (this.checkConnection()) {
                this.reuseExistingPort(this.port);
                return;
            }
            AbstractDevServerRunner.getLogger().warn(String.format("%s port '%d' is defined but it's not working properly. Using a new free port...", this.getServerName(), this.port));
            this.port = 0;
        }
        this.validateFiles();
        long start = System.nanoTime();
        AbstractDevServerRunner.getLogger().info("Starting " + this.getServerName());
        this.watchDog.set(new DevServerWatchDog());
        this.port = NetworkUtil.getFreePort();
        this.saveRunningDevServerPort();
        try {
            Process process = this.doStartDevServer();
            this.devServerProcess.set(process);
            if (!this.isRunning()) {
                throw new IllegalStateException("Startup of " + this.getServerName() + " failed. Output was:\n" + this.getFailedOutput());
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            AbstractDevServerRunner.getLogger().info("Started {}. Time: {}ms", (Object)this.getServerName(), (Object)ms);
        }
        finally {
            if (this.devServerProcess.get() == null) {
                this.removeRunningDevServerPort();
            }
        }
    }

    protected void validateFiles() throws ExecutionFailedException {
        assert (this.getPort() == 0);
        File binary = this.getServerBinary();
        File config = this.getServerConfig();
        if (!this.getProjectRoot().exists()) {
            AbstractDevServerRunner.getLogger().warn("No project folder '{}' exists", (Object)this.getProjectRoot());
            throw new ExecutionFailedException("Couldn't start dev server because the target execution folder doesn't exist.");
        }
        if (!binary.exists()) {
            AbstractDevServerRunner.getLogger().warn("'{}' doesn't exist. Did you run `npm install`?", (Object)binary);
            throw new ExecutionFailedException(String.format("%s '%s' doesn't exist. `npm install` has not run or failed.", START_FAILURE, binary));
        }
        if (!binary.canExecute()) {
            AbstractDevServerRunner.getLogger().warn(" '{}' is not an executable. Did you run `npm install`?", (Object)binary);
            throw new ExecutionFailedException(String.format("%s '%s' is not an executable. `npm install` has not run or failed.", START_FAILURE, binary));
        }
        if (!config.canRead()) {
            AbstractDevServerRunner.getLogger().warn("{} configuration '{}' is not found or is not readable.", (Object)this.getServerName(), (Object)config);
            throw new ExecutionFailedException(String.format("%s '%s' doesn't exist or is not readable.", START_FAILURE, config));
        }
    }

    protected abstract File getServerBinary();

    protected abstract File getServerConfig();

    protected abstract String getServerName();

    protected abstract List<String> getServerStartupCommand(FrontendTools var1);

    protected void updateServerStartupEnvironment(FrontendTools frontendTools, Map<String, String> environment) {
        environment.put("watchDogHost", this.getLoopbackAddress().getHostAddress());
        environment.put("watchDogPort", Integer.toString(this.getWatchDog().getWatchDogPort()));
    }

    InetAddress getLoopbackAddress() {
        return InetAddress.getLoopbackAddress();
    }

    protected abstract Pattern getServerSuccessPattern();

    protected abstract Pattern getServerFailurePattern();

    protected Pattern getServerRestartingPattern() {
        return null;
    }

    protected Pattern getServerRestartedPattern() {
        return null;
    }

    protected Process doStartDevServer() {
        ApplicationConfiguration config = this.getApplicationConfiguration();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(this.getProjectRoot());
        FrontendTools tools = new FrontendTools(config, this.getProjectRoot());
        tools.validateNodeAndNpmVersion();
        List<String> command = this.getServerStartupCommand(tools);
        FrontendUtils.console((String)"\u001b[38;5;35m%s\u001b[0m", (Object)START);
        if (AbstractDevServerRunner.getLogger().isDebugEnabled()) {
            AbstractDevServerRunner.getLogger().debug(FrontendUtils.commandToString((String)this.getProjectRoot().getAbsolutePath(), command));
        }
        processBuilder.command(command);
        Map<String, String> environment = processBuilder.environment();
        this.updateServerStartupEnvironment(tools, environment);
        try {
            Process process = processBuilder.redirectErrorStream(true).start();
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
            DevServerOutputTracker outputTracker = new DevServerOutputTracker(process.getInputStream(), this.getServerSuccessPattern(), this.getServerFailurePattern(), this::onDevServerCompilation);
            Pattern restartingPattern = this.getServerRestartingPattern();
            Pattern restartedPattern = this.getServerRestartedPattern();
            if (restartingPattern != null && restartedPattern != null) {
                this.waitForRestart = outputTracker.serverRestartGuard(restartingPattern, restartedPattern);
                AbstractDevServerRunner.getLogger().debug("RestartMonitor is active");
            } else {
                AbstractDevServerRunner.getLogger().trace("RestartMonitor not active. Both restarting and restarted pattern are required");
            }
            outputTracker.find();
            AbstractDevServerRunner.getLogger().info(LOG_START, (Object)this.getServerName());
            int timeout = Integer.parseInt(config.getStringProperty("devmode.output.pattern.timeout", DEFAULT_TIMEOUT_FOR_PATTERN));
            outputTracker.awaitFirstMatch(timeout);
            return process;
        }
        catch (IOException e) {
            AbstractDevServerRunner.getLogger().error("Failed to start the " + this.getServerName() + " process", (Throwable)e);
        }
        catch (InterruptedException e) {
            AbstractDevServerRunner.getLogger().debug(this.getServerName() + " process start has been interrupted", (Throwable)e);
        }
        return null;
    }

    protected void onDevServerCompilation(DevServerOutputTracker.Result result) {
        if (result.isSuccess()) {
            FrontendUtils.console((String)"\u001b[38;5;35m%s\u001b[0m", (Object)SUCCEED_MSG);
            this.failedOutput = null;
        } else {
            FrontendUtils.console((String)"\u001b[38;5;196m%s\u001b[0m", (Object)FAILED_MSG);
            this.failedOutput = result.getOutput();
        }
    }

    public String getFailedOutput() {
        return this.failedOutput;
    }

    protected DevServerWatchDog getWatchDog() {
        return this.watchDog.get();
    }

    public File getProjectRoot() {
        return this.npmFolder;
    }

    protected ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    protected boolean checkConnection() {
        try {
            HttpURLConnection connection = this.prepareConnection("/index.html", "GET");
            return connection.getResponseCode() == 200;
        }
        catch (IOException e) {
            AbstractDevServerRunner.getLogger().debug("Error checking dev server connection", (Throwable)e);
            return false;
        }
    }

    private static int getRunningDevServerPort(File npmFolder) {
        int port = 0;
        File portFile = AbstractDevServerRunner.getDevServerPortFile(npmFolder);
        if (portFile.canRead()) {
            try {
                String portString = FileUtils.readFileToString((File)portFile, (Charset)StandardCharsets.UTF_8).trim();
                if (!portString.isEmpty()) {
                    port = Integer.parseInt(portString);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return port;
    }

    private void removeRunningDevServerPort() {
        FileUtils.deleteQuietly((File)this.devServerPortFile);
    }

    public int getPort() {
        return this.port;
    }

    private void reuseExistingPort(int port) {
        AbstractDevServerRunner.getLogger().info("Reusing {} running at {}:{}", new Object[]{this.getServerName(), DEV_SERVER_HOST, port});
        this.usingAlreadyStartedProcess = true;
        this.saveRunningDevServerPort();
        this.watchDog.set(null);
    }

    private void saveRunningDevServerPort() {
        try {
            FileUtils.writeStringToFile((File)this.devServerPortFile, (String)String.valueOf(this.port), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static File getDevServerPortFile(File npmFolder) {
        String jvmUuid = System.getProperty(DEV_SERVER_PORTFILE_UUID_PROPERTY);
        if (jvmUuid == null) {
            jvmUuid = UUID.randomUUID().toString();
            System.setProperty(DEV_SERVER_PORTFILE_UUID_PROPERTY, jvmUuid);
        }
        String frontendBuildPath = npmFolder.getAbsolutePath();
        String uniqueUid = UUID.nameUUIDFromBytes((jvmUuid + frontendBuildPath).getBytes(StandardCharsets.UTF_8)).toString();
        return new File(System.getProperty("java.io.tmpdir"), uniqueUid);
    }

    public void waitForDevServer() {
        this.devServerStartFuture.join();
    }

    boolean isRunning() {
        Process process = this.devServerProcess.get();
        return process != null && process.isAlive() || this.usingAlreadyStartedProcess;
    }

    public void stop() {
        Process process;
        if (this.reuseDevServer) {
            return;
        }
        try {
            this.prepareConnection("/stop", "GET").getResponseCode();
        }
        catch (IOException e) {
            AbstractDevServerRunner.getLogger().debug(this.getServerName() + " does not support the `/stop` command.", (Throwable)e);
        }
        DevServerWatchDog watchDogInstance = this.watchDog.get();
        if (watchDogInstance != null) {
            watchDogInstance.stop();
        }
        if ((process = this.devServerProcess.get()) != null && process.isAlive()) {
            process.destroy();
        }
        this.devServerProcess.set(null);
        this.usingAlreadyStartedProcess = false;
        this.removeRunningDevServerPort();
    }

    public HttpURLConnection prepareConnection(String path, String method) throws IOException {
        if (this.waitForRestart != null) {
            this.waitForRestart.run();
        }
        URL uri = new URL("http://127.0.0.1:" + this.getPort() + path);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        connection.setRequestMethod(method);
        connection.setReadTimeout(120000);
        connection.setConnectTimeout(120000);
        return connection;
    }

    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        return AbstractDevServerRunner.handleRequestInternal(request, response, this.devServerStartFuture, this.isDevServerFailedToStart);
    }

    static boolean handleRequestInternal(VaadinRequest request, VaadinResponse response, CompletableFuture<?> devServerStartFuture, AtomicBoolean isDevServerFailedToStart) throws IOException {
        if (devServerStartFuture.isDone()) {
            try {
                devServerStartFuture.getNow(null);
            }
            catch (CompletionException exception) {
                isDevServerFailedToStart.set(true);
                throw AbstractDevServerRunner.getCause(exception);
            }
            if (request.getHeader("X-DevModePoll") != null) {
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write("Ready");
                response.setHeader("Cache-Control", "no-cache");
                return true;
            }
            return false;
        }
        if (request.getHeader("X-DevModePoll") == null) {
            InputStream inputStream = AbstractDevServerRunner.class.getResourceAsStream("dev-mode-not-ready.html");
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        } else {
            response.getWriter().write("Pending");
        }
        response.setContentType("text/html;charset=utf-8");
        response.setHeader("X-DevModePending", "true");
        response.setHeader("Cache-Control", "no-cache");
        return true;
    }

    public boolean serveDevModeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isDevServerFailedToStart.get() || !this.devServerStartFuture.isDone() || this.devServerStartFuture.isCompletedExceptionally()) {
            return false;
        }
        Object requestFilename = request.getPathInfo();
        if (HandlerHelper.isPathUnsafe((String)requestFilename) || WEBPACK_ILLEGAL_CHAR_PATTERN.matcher((CharSequence)requestFilename).find()) {
            AbstractDevServerRunner.getLogger().info("Blocked attempt to access file: {}", requestFilename);
            response.setStatus(HttpStatusCode.FORBIDDEN.getCode());
            return true;
        }
        if (StaticFileServer.APP_THEME_ASSETS_PATTERN.matcher((CharSequence)requestFilename).find()) {
            requestFilename = "/VAADIN/static" + (String)requestFilename;
        }
        if (((String)requestFilename).equals("") || ((String)requestFilename).equals("/")) {
            return false;
        }
        Object devServerRequestPath = UrlUtil.encodeURI((String)requestFilename);
        if (request.getQueryString() != null) {
            devServerRequestPath = (String)devServerRequestPath + "?" + request.getQueryString();
        }
        HttpURLConnection connection = this.prepareConnection((String)devServerRequestPath, request.getMethod());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header2;
            connection.setRequestProperty(header2, "Connect".equals(header2 = (String)headerNames.nextElement()) ? "close" : request.getHeader(header2));
        }
        AbstractDevServerRunner.getLogger().debug("Requesting resource from {} {}", (Object)this.getServerName(), (Object)connection.getURL());
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            AbstractDevServerRunner.getLogger().debug("Resource not served by {} {}", (Object)this.getServerName(), devServerRequestPath);
            return false;
        }
        AbstractDevServerRunner.getLogger().debug("Served resource by {}: {} {}", new Object[]{this.getServerName(), responseCode, devServerRequestPath});
        connection.getHeaderFields().forEach((header, values) -> {
            if (header != null) {
                if ("Transfer-Encoding".equals(header)) {
                    return;
                }
                response.addHeader(header, (String)values.get(0));
            }
        });
        if (((String)requestFilename).startsWith("/VAADIN/generated/jar-resources/copilot/")) {
            response.setHeader("Cache-Control", "max-age=31536001,immutable");
        }
        if (responseCode == 200) {
            this.writeStream(response.getOutputStream(), connection.getInputStream());
        } else if (responseCode < 400) {
            response.setStatus(responseCode);
        } else {
            response.sendError(responseCode);
        }
        response.getOutputStream().close();
        return true;
    }

    private static RuntimeException getCause(Throwable exception) {
        if (exception instanceof CompletionException) {
            return AbstractDevServerRunner.getCause(exception.getCause());
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new IllegalStateException(exception);
    }

    protected void writeStream(ServletOutputStream outputStream, InputStream inputStream) throws IOException {
        int bytes;
        byte[] buffer = new byte[32768];
        while ((bytes = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, bytes);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AbstractDevServerRunner.class);
    }
}

