/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.themeeditor.handlers;

import com.vaadin.base.devserver.themeeditor.messages.LoadRulesRequest;
import com.vaadin.base.devserver.themeeditor.messages.LoadRulesResponse;
import com.vaadin.base.devserver.themeeditor.utils.CssRule;
import com.vaadin.base.devserver.themeeditor.utils.HasThemeModifier;
import com.vaadin.base.devserver.themeeditor.utils.MessageHandler;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import java.util.List;
import java.util.Optional;

public class LoadRulesHandler
implements MessageHandler {
    private final HasThemeModifier hasThemeModifier;

    public LoadRulesHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public MessageHandler.ExecuteAndUndo handle(JsonObject data) {
        LoadRulesRequest request = (LoadRulesRequest)JsonUtils.readToObject((JsonObject)data, LoadRulesRequest.class);
        List<CssRule> rules = this.hasThemeModifier.getThemeModifier().getCssRules(request.getSelectors());
        return new MessageHandler.ExecuteAndUndo(() -> new LoadRulesResponse(rules), Optional.empty());
    }

    @Override
    public String getCommandName() {
        return "themeEditorLoadRules";
    }
}

