/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.Version;
import java.io.Serializable;

public class ServerInfo
implements Serializable {
    private final String flowVersion = Version.getFullVersion();
    private final String vaadinVersion = this.fetchVaadinVersion();
    private final String javaVersion = this.fetchJavaVersion();
    private final String osVersion = this.fetchOperatingSystem();
    private final String productName = this.fetchProductName();

    private String fetchJavaVersion() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        return vendor + " " + version;
    }

    private String fetchOperatingSystem() {
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        return arch + " " + name + " " + version;
    }

    private String fetchVaadinVersion() {
        return Platform.getVaadinVersion().orElse("?");
    }

    private String fetchProductName() {
        try {
            Class.forName("dev.hilla.EndpointController", false, this.getClass().getClassLoader());
            return "Hilla";
        }
        catch (ClassNotFoundException e) {
            return "Vaadin";
        }
    }

    public String getFlowVersion() {
        return this.flowVersion;
    }

    public String getVaadinVersion() {
        return this.vaadinVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getProductName() {
        return this.productName;
    }
}

