/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.startup.DevModeInitializer;
import com.vaadin.base.devserver.startup.DevModeStartupListener;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import java.io.Serializable;
import java.util.Set;
import javax.servlet.annotation.HandlesTypes;

public class DevModeHandlerManagerImpl
implements DevModeHandlerManager {
    private DevModeHandler devModeHandler;

    public Class<?>[] getHandlesTypes() {
        return DevModeStartupListener.class.getAnnotation(HandlesTypes.class).value();
    }

    public void setDevModeHandler(DevModeHandler devModeHandler) {
        if (this.devModeHandler != null) {
            throw new IllegalStateException("Unable to initialize dev mode handler. A handler is already present: " + this.devModeHandler);
        }
        this.devModeHandler = devModeHandler;
    }

    public DevModeHandler getDevModeHandler() {
        return this.devModeHandler;
    }

    public void initDevModeHandler(Set<Class<?>> classes, VaadinContext context) throws VaadinInitializerException {
        this.setDevModeHandler(DevModeInitializer.initDevModeHandler(classes, context));
        this.setDevModeStarted(context);
    }

    private void setDevModeStarted(VaadinContext context) {
        context.setAttribute(DevModeHandlerAlreadyStartedAttribute.class, (Object)new DevModeHandlerAlreadyStartedAttribute());
    }

    public static boolean isDevModeAlreadyStarted(VaadinContext context) {
        assert (context != null);
        return context.getAttribute(DevModeHandlerAlreadyStartedAttribute.class) != null;
    }

    private static final class DevModeHandlerAlreadyStartedAttribute
    implements Serializable {
        private DevModeHandlerAlreadyStartedAttribute() {
        }
    }
}

