/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datetimepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerDatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerTimePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasAutoOpen;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasOverlayClassName;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.timepicker.StepsUtil;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

@Tag(value="vaadin-date-time-picker")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.3.19"), @NpmPackage(value="@vaadin/date-time-picker", version="24.3.19")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/date-time-picker/src/vaadin-date-time-picker.js")})
public class DateTimePicker
extends AbstractSinglePropertyField<DateTimePicker, LocalDateTime>
implements Focusable<DateTimePicker>,
HasAutoOpen,
HasClientValidation,
HasHelper,
InputField<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>, LocalDateTime>,
HasOverlayClassName,
HasThemeVariant<DateTimePickerVariant>,
HasValidationProperties,
HasValidator<LocalDateTime> {
    private final DateTimePickerDatePicker datePicker = new DateTimePickerDatePicker();
    private final DateTimePickerTimePicker timePicker = new DateTimePickerTimePicker();
    private DatePicker.DatePickerI18n i18n;
    private DateTimePickerI18n dateTimePickerI18n;
    private Locale locale;
    private static final SerializableFunction<String, LocalDateTime> PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : LocalDateTime.parse(s);
    private static final SerializableFunction<LocalDateTime, String> FORMATTER = (SerializableFunction & Serializable)d -> d == null ? "" : d.truncatedTo(ChronoUnit.MILLIS).toString();
    private LocalDateTime max;
    private LocalDateTime min;
    private boolean required;
    private boolean manualValidationEnabled = false;

    public DateTimePicker() {
        this((LocalDateTime)null);
    }

    public DateTimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public DateTimePicker(String label, LocalDateTime initialDateTime) {
        this(initialDateTime);
        this.setLabel(label);
    }

    public DateTimePicker(LocalDateTime initialDateTime) {
        super("value", null, String.class, PARSER, FORMATTER);
        if (initialDateTime != null) {
            initialDateTime = this.sanitizeValue(initialDateTime);
            this.setPresentationValue(initialDateTime);
            this.synchronizeChildComponentValues(initialDateTime);
        } else if (this.getElement().getProperty("value") == null) {
            this.setPresentationValue(null);
        }
        SlotUtils.addToSlot((HasElement)this, (String)"date-picker", (Component[])new Component[]{this.datePicker});
        SlotUtils.addToSlot((HasElement)this, (String)"time-picker", (Component[])new Component[]{this.timePicker});
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
    }

    public DateTimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(initialDateTime);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(String label, LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(initialDateTime);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(LocalDateTime initialDateTime, Locale locale) {
        this(initialDateTime);
        this.setLocale(locale);
    }

    public void setValue(LocalDateTime value) {
        boolean isValueRemainedEmpty;
        LocalDateTime oldValue = (LocalDateTime)this.getValue();
        value = this.sanitizeValue(value);
        super.setValue((Object)value);
        boolean isInputValuePresent = this.timePicker.isInputValuePresent() || this.datePicker.isInputValuePresent();
        boolean bl = isValueRemainedEmpty = this.valueEquals(oldValue, (LocalDateTime)this.getEmptyValue()) && this.valueEquals(value, (LocalDateTime)this.getEmptyValue());
        if (isValueRemainedEmpty && isInputValuePresent) {
            this.synchronizeChildComponentValues(value);
            this.fireEvent((ComponentEvent)new HasClientValidation.ClientValidatedEvent((Component)this, false));
        } else {
            this.synchronizeChildComponentValues(value);
        }
    }

    private LocalDateTime sanitizeValue(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return value.truncatedTo(ChronoUnit.MILLIS);
    }

    private void synchronizeChildComponentValues(LocalDateTime value) {
        if (value != null) {
            this.datePicker.passThroughPresentationValue(value.toLocalDate());
            this.timePicker.passThroughPresentationValue(value.toLocalTime());
        } else {
            this.datePicker.passThroughPresentationValue(null);
            this.timePicker.passThroughPresentationValue(null);
        }
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.datePicker.setReadOnly(readOnly);
        this.timePicker.setReadOnly(readOnly);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setDateAriaLabel(String dateLabel) {
        if (this.dateTimePickerI18n == null) {
            this.dateTimePickerI18n = new DateTimePickerI18n();
        }
        this.dateTimePickerI18n.setDateLabel(dateLabel);
        this.getElement().setPropertyJson("i18n", JsonSerializer.toJson((Object)this.dateTimePickerI18n));
    }

    public Optional<String> getDateAriaLabel() {
        if (this.dateTimePickerI18n == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.dateTimePickerI18n.getDateLabel());
    }

    public void setTimeAriaLabel(String timeLabel) {
        if (this.dateTimePickerI18n == null) {
            this.dateTimePickerI18n = new DateTimePickerI18n();
        }
        this.dateTimePickerI18n.setTimeLabel(timeLabel);
        this.getElement().setPropertyJson("i18n", JsonSerializer.toJson((Object)this.dateTimePickerI18n));
    }

    public Optional<String> getTimeAriaLabel() {
        if (this.dateTimePickerI18n == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.dateTimePickerI18n.getTimeLabel());
    }

    public void setDatePlaceholder(String placeholder) {
        this.datePicker.setPlaceholder(placeholder);
    }

    public String getDatePlaceholder() {
        return this.datePicker.getPlaceholder();
    }

    public void setTimePlaceholder(String placeholder) {
        this.timePicker.setPlaceholder(placeholder);
    }

    public String getTimePlaceholder() {
        return this.timePicker.getPlaceholder();
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        this.getElement().setProperty("step", StepsUtil.convertDurationToStepsValue((Duration)step));
        this.timePicker.setStep(step);
    }

    public Duration getStep() {
        if (!this.getElement().hasProperty("step")) {
            return StepsUtil.DEFAULT_WEB_COMPONENT_STEP;
        }
        double stepsValue = this.getElement().getProperty("step", 0.0);
        return StepsUtil.convertStepsValueToDuration((double)stepsValue);
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.datePicker.setWeekNumbersVisible(weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.datePicker.isWeekNumbersVisible();
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.datePicker.setLocale(locale);
        this.timePicker.setLocale(locale);
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    private void synchronizeTheme() {
        String theme = this.getThemeName();
        theme = theme != null ? theme : "";
        this.datePicker.getElement().setAttribute("theme", theme);
        this.timePicker.getElement().setAttribute("theme", theme);
    }

    public void addThemeName(String themeName) {
        super.addThemeName(themeName);
        this.synchronizeTheme();
    }

    public boolean removeThemeName(String themeName) {
        boolean result = super.removeThemeName(themeName);
        this.synchronizeTheme();
        return result;
    }

    public void setThemeName(String themeName) {
        super.setThemeName(themeName);
        this.synchronizeTheme();
    }

    public void setThemeName(String themeName, boolean set) {
        super.setThemeName(themeName, set);
        this.synchronizeTheme();
    }

    public void addThemeNames(String ... themeNames) {
        super.addThemeNames(themeNames);
        this.synchronizeTheme();
    }

    public void removeThemeNames(String ... themeNames) {
        super.removeThemeNames(themeNames);
        this.synchronizeTheme();
    }

    public Validator<LocalDateTime> getDefaultValidator() {
        return (Validator & Serializable)(value, context) -> this.checkValidity((LocalDateTime)value);
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalDateTime> listener) {
        return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, event.isValid().booleanValue())));
    }

    private ValidationResult checkValidity(LocalDateTime value) {
        boolean hasNonParsableTimePickerValue;
        boolean hasNonParsableDatePickerValue = this.datePicker.getValue() == this.datePicker.getEmptyValue() && this.datePicker.isInputValuePresent();
        boolean bl = hasNonParsableTimePickerValue = this.timePicker.getValue() == this.timePicker.getEmptyValue() && this.timePicker.isInputValuePresent();
        if (hasNonParsableDatePickerValue || hasNonParsableTimePickerValue) {
            return ValidationResult.error((String)"");
        }
        ValidationResult greaterThanMax = ValidationUtil.checkGreaterThanMax((Comparable)value, (Comparable)this.max);
        if (greaterThanMax.isError()) {
            return greaterThanMax;
        }
        ValidationResult smallerThanMin = ValidationUtil.checkSmallerThanMin((Comparable)value, (Comparable)this.min);
        if (smallerThanMin.isError()) {
            return smallerThanMin;
        }
        return ValidationResult.ok();
    }

    private boolean isInvalid(LocalDateTime value) {
        ValidationResult requiredValidation = ValidationUtil.checkRequired((boolean)this.required, (Object)value, (Object)((LocalDateTime)this.getEmptyValue()));
        return requiredValidation.isError() || this.checkValidity(value).isError();
    }

    public void setManualValidation(boolean enabled) {
        this.manualValidationEnabled = enabled;
    }

    protected void validate() {
        if (!this.manualValidationEnabled) {
            this.setInvalid(this.isInvalid((LocalDateTime)this.getValue()));
        }
    }

    public void setMin(LocalDateTime min) {
        this.getElement().setProperty("min", (String)FORMATTER.apply((Object)min));
        this.min = min;
    }

    public LocalDateTime getMin() {
        return (LocalDateTime)PARSER.apply((Object)this.getElement().getProperty("min"));
    }

    public void setMax(LocalDateTime max) {
        this.getElement().setProperty("max", (String)FORMATTER.apply((Object)max));
        this.max = max;
    }

    public LocalDateTime getMax() {
        return (LocalDateTime)PARSER.apply((Object)this.getElement().getProperty("max"));
    }

    public DatePicker.DatePickerI18n getDatePickerI18n() {
        return this.i18n;
    }

    public void setDatePickerI18n(DatePicker.DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.i18n = i18n;
        this.datePicker.setI18n(i18n);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty("autoOpenDisabled", !autoOpen);
        this.datePicker.setAutoOpen(autoOpen);
        this.timePicker.setAutoOpen(autoOpen);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }

    public static class DateTimePickerI18n
    implements Serializable {
        private String dateLabel;
        private String timeLabel;

        public String getDateLabel() {
            return this.dateLabel;
        }

        public void setDateLabel(String dateLabel) {
            this.dateLabel = dateLabel;
        }

        public String getTimeLabel() {
            return this.timeLabel;
        }

        public void setTimeLabel(String timeLabel) {
            this.timeLabel = timeLabel;
        }
    }
}

