/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.customfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.dom.DomEventListener;
import java.io.Serializable;

@Tag(value="vaadin-custom-field")
@HtmlImport(value="frontend://bower_components/vaadin-custom-field/src/vaadin-custom-field.html")
public abstract class CustomField<T>
extends AbstractField<CustomField<T>, T>
implements HasComponents,
HasSize,
HasValidation,
Focusable<CustomField> {
    public CustomField() {
        this(null);
    }

    public CustomField(T defaultValue) {
        super(defaultValue);
        this.getElement().addEventListener("change", (DomEventListener & Serializable)e -> this.updateValue());
    }

    protected abstract T generateModelValue();

    protected abstract void setPresentationValue(T var1);

    protected void updateValue() {
        this.setModelValue(this.generateModelValue(), false);
    }

    @Synchronize(property="invalid", value={"invalid-changed"})
    public boolean isInvalid() {
        return this.getElement().getProperty("invalid", false);
    }

    public void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    public void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage);
    }

    public String getErrorMessage() {
        return this.getElement().getProperty("errorMessage");
    }

    public String getLabel() {
        return this.getElement().getProperty("label", null);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label);
    }
}

