/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.crud;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.crud.CrudEditor;
import com.vaadin.flow.component.crud.CrudEditorPosition;
import com.vaadin.flow.component.crud.CrudGrid;
import com.vaadin.flow.component.crud.CrudI18n;
import com.vaadin.flow.component.crud.CrudI18nUpdatedEvent;
import com.vaadin.flow.component.crud.CrudVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Tag(value="vaadin-crud")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.7.12"), @NpmPackage(value="@vaadin/crud", version="24.7.12")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/crud/src/vaadin-crud.js"), @JsModule(value="@vaadin/crud/src/vaadin-crud-edit-column.js")})
public class Crud<E>
extends Component
implements HasSize,
HasTheme,
HasStyle {
    private static final String EDIT_COLUMN_KEY = "vaadin-crud-edit-column";
    private static final String EVENT_PREVENT_DEFAULT_JS = "event.preventDefault()";
    private final Set<ComponentEventListener<NewEvent<E>>> newListeners = new LinkedHashSet<ComponentEventListener<NewEvent<E>>>();
    private final Set<ComponentEventListener<EditEvent<E>>> editListeners = new LinkedHashSet<ComponentEventListener<EditEvent<E>>>();
    private final Set<ComponentEventListener<SaveEvent<E>>> saveListeners = new LinkedHashSet<ComponentEventListener<SaveEvent<E>>>();
    private final Set<ComponentEventListener<CancelEvent<E>>> cancelListeners = new LinkedHashSet<ComponentEventListener<CancelEvent<E>>>();
    private final Set<ComponentEventListener<DeleteEvent<E>>> deleteListeners = new LinkedHashSet<ComponentEventListener<DeleteEvent<E>>>();
    private Class<E> beanType;
    private Grid<E> grid;
    private CrudEditor<E> editor;
    private E gridActiveItem;
    private boolean toolbarVisible = true;
    private boolean saveBtnDisabledOverridden;
    private final Button saveButton;
    private final Button cancelButton;
    private final Button deleteButton;
    private Component newButton;
    private Registration gridItemClickRegistration;

    public Crud(Class<E> beanType, Grid<E> grid, CrudEditor<E> editor) {
        this();
        this.setGrid(grid);
        this.setEditor(editor);
        this.setBeanType(beanType);
    }

    public Crud(Class<E> beanType, CrudEditor<E> editor) {
        this();
        this.setEditor(editor);
        this.setBeanType(beanType);
    }

    public Crud() {
        this.setI18n(CrudI18n.createDefault(), false);
        this.registerHandlers();
        this.getElement().setProperty("_noDefaultButtons", true);
        this.newButton = new Button();
        this.newButton.getElement().setAttribute("theme", "primary");
        this.newButton.getElement().setProperty("_isDefault", true);
        SlotUtils.addToSlot((HasElement)this, (String)"new-button", (Component[])new Component[]{this.newButton});
        this.saveButton = new SaveButton();
        this.saveButton.addThemeName("primary");
        this.saveButton.getElement().setProperty("_isDefault", true);
        SlotUtils.addToSlot((HasElement)this, (String)"save-button", (Component[])new Component[]{this.saveButton});
        this.cancelButton = new Button();
        this.cancelButton.addThemeName("tertiary");
        this.cancelButton.getElement().setProperty("_isDefault", true);
        SlotUtils.addToSlot((HasElement)this, (String)"cancel-button", (Component[])new Component[]{this.cancelButton});
        this.deleteButton = new Button();
        this.deleteButton.addThemeNames(new String[]{"tertiary", "error"});
        this.deleteButton.getElement().setProperty("_isDefault", true);
        SlotUtils.addToSlot((HasElement)this, (String)"delete-button", (Component[])new Component[]{this.deleteButton});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.saveBtnDisabledOverridden) {
            this.overrideSaveDisabled(this.getSaveButton().isEnabled());
        }
        this.getElement().executeJs("this.__validate = function () {return true;}", new Serializable[0]);
    }

    private void overrideSaveDisabled(boolean enabled) {
        this.getElement().executeJs("this.__isSaveBtnDisabled = () => {return $0;}", new Serializable[]{Boolean.valueOf(!enabled)});
    }

    private void registerHandlers() {
        ComponentUtil.addListener((Component)this, NewEvent.class, (ComponentEventListener & Serializable)e -> {
            try {
                this.getEditor().setItem(e.getItem() != null ? e.getItem() : this.getBeanType().newInstance());
                this.clearActiveItem();
                this.setClientIsNew(true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to instantiate new bean", ex);
            }
            NewEvent eventWithNewItem = new NewEvent((Crud)e.getSource(), e.isFromClient(), this.getEditor().getItem(), null);
            this.newListeners.forEach(listener -> listener.onComponentEvent((ComponentEvent)eventWithNewItem));
        });
        ComponentUtil.addListener((Component)this, EditEvent.class, (ComponentEventListener & Serializable)e -> {
            if (this.getEditor().getItem() != e.getItem()) {
                this.getEditor().setItem(e.getItem(), true);
                this.setOpened(true);
                this.setClientIsNew(false);
                if (this.isEditOnClick() && this.getGrid() instanceof CrudGrid) {
                    this.getGrid().select(e.getItem());
                }
            }
            this.editListeners.forEach(listener -> listener.onComponentEvent(e));
        });
        ComponentUtil.addListener((Component)this, CancelEvent.class, (ComponentEventListener & Serializable)e -> {
            this.cancelListeners.forEach(listener -> listener.onComponentEvent(e));
            if (this.gridActiveItem != null && this.getEditor().getItem() == this.gridActiveItem || this.gridActiveItem == null) {
                this.setOpened(false);
                this.getEditor().clear();
                this.clearActiveItem();
            }
        });
        ComponentUtil.addListener((Component)this, SaveEvent.class, (ComponentEventListener & Serializable)e -> {
            if (!this.getEditor().validate()) {
                return;
            }
            this.getEditor().writeItemChanges();
            try {
                this.saveListeners.forEach(listener -> listener.onComponentEvent(e));
                this.setOpened(false);
                this.getEditor().clear();
            }
            finally {
                if (this.getGrid().getDataProvider() != null) {
                    this.getGrid().getDataProvider().refreshAll();
                }
            }
        });
        ComponentUtil.addListener((Component)this, DeleteEvent.class, (ComponentEventListener & Serializable)e -> {
            try {
                this.deleteListeners.forEach(listener -> listener.onComponentEvent(e));
                this.setOpened(false);
                this.getEditor().clear();
            }
            finally {
                this.getGrid().getDataProvider().refreshAll();
            }
        });
    }

    public void edit(E item, EditMode editMode) {
        CrudEvent event;
        if (editMode == EditMode.NEW_ITEM) {
            event = new NewEvent<E>(this, false, item, null);
        } else {
            this.setDirty(false);
            event = new EditEvent<E>(this, false, item);
        }
        this.setOpened(true);
        ComponentUtil.fireEvent((Component)this, event);
    }

    private void setClientIsNew(boolean isNew) {
        this.getElement().setProperty("__isNew", isNew);
    }

    public void setOpened(boolean opened) {
        this.getElement().callJsFunction("set", new Serializable[]{"editorOpened", Boolean.valueOf(opened)});
    }

    public void setDirty(boolean dirty) {
        this.getElement().executeJs("this.set('__isDirty', $0)", new Serializable[]{Boolean.valueOf(dirty)});
    }

    public Class<E> getBeanType() {
        if (this.beanType == null) {
            throw new IllegalStateException("The bean type must be initialized before event processing");
        }
        return this.beanType;
    }

    public void setBeanType(Class<E> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        this.beanType = beanType;
        if (this.grid == null) {
            this.setGrid(new CrudGrid<E>(beanType, true, true));
        }
    }

    public Grid<E> getGrid() {
        if (this.grid == null) {
            throw new IllegalStateException("The grid must be initialized before event processing");
        }
        return this.grid;
    }

    public void setGrid(Grid<E> grid) {
        Objects.requireNonNull(grid, "Grid cannot be null");
        if (this.grid != null && this.getElement().equals((Object)this.grid.getElement().getParent())) {
            this.grid.getElement().removeFromParent();
        }
        this.grid = grid;
        grid.getElement().setAttribute("slot", "grid");
        if (grid.getElement().getParent() == null) {
            this.getElement().appendChild(new Element[]{grid.getElement()});
        }
    }

    public CrudEditor<E> getEditor() {
        if (this.editor == null) {
            throw new IllegalStateException("The editor must be initialized before event processing");
        }
        return this.editor;
    }

    public void setEditor(CrudEditor<E> editor) {
        Objects.requireNonNull(editor, "Editor cannot be null");
        if (this.editor != null && this.editor.getView() != null && this.editor.getView().getElement().getParent() == this.getElement()) {
            this.editor.getView().getElement().removeFromParent();
        }
        this.editor = editor;
        if (editor.getView() != null && editor.getView().getElement().getParent() == null) {
            SlotUtils.addToSlot((HasElement)this, (String)"form", (Component[])new Component[]{editor.getView()});
        }
    }

    public void setEditorPosition(CrudEditorPosition editorPosition) {
        if (editorPosition == null) {
            throw new IllegalArgumentException("The 'editorPosition' argument can not be null");
        }
        this.getElement().setProperty("editorPosition", editorPosition.getEditorPosition());
    }

    public CrudEditorPosition getEditorPosition() {
        return CrudEditorPosition.toPosition(this.getElement().getProperty("editorPosition", ""), CrudEditorPosition.OVERLAY);
    }

    public void setEditOnClick(boolean editOnClick) {
        this.getElement().setProperty("editOnClick", editOnClick);
        Grid<E> grid = this.getGrid();
        if (editOnClick) {
            if (this.getGrid() instanceof CrudGrid) {
                grid.setSelectionMode(Grid.SelectionMode.SINGLE);
                if (Crud.hasEditColumn(grid)) {
                    Crud.removeEditColumn(grid);
                }
            }
            this.gridItemClickRegistration = grid.addItemClickListener((ComponentEventListener & Serializable)e -> {
                this.gridActiveItem = e.getItem();
            });
        } else if (this.gridItemClickRegistration != null) {
            this.clearActiveItem();
            this.gridItemClickRegistration.remove();
            if (grid instanceof CrudGrid) {
                Crud.addEditColumn(grid);
                grid.setSelectionMode(Grid.SelectionMode.NONE);
            }
        }
    }

    public boolean isEditOnClick() {
        return this.getElement().getProperty("editOnClick", false);
    }

    private void clearActiveItem() {
        this.gridActiveItem = null;
        this.grid.deselectAll();
    }

    public void setToolbar(Component ... components) {
        SlotUtils.setSlot((HasElement)this, (String)"toolbar", (Component[])components);
    }

    public void setI18n(CrudI18n i18n) {
        this.setI18n(i18n, true);
    }

    private void setI18n(CrudI18n i18n, boolean fireEvent) {
        this.getElement().setPropertyJson("i18n", JsonSerializer.toJson((Object)i18n));
        if (fireEvent) {
            ComponentUtil.fireEvent(this.grid, (ComponentEvent)new CrudI18nUpdatedEvent(this, false, i18n));
        }
    }

    public void setToolbarVisible(boolean value) {
        this.toolbarVisible = value;
        if (value) {
            this.getElement().setProperty("noToolbar", false);
        } else {
            this.getElement().setProperty("noToolbar", true);
        }
    }

    public boolean getToolbarVisible() {
        return this.toolbarVisible;
    }

    public Component getNewButton() {
        return this.newButton;
    }

    public void setNewButton(Component button) {
        this.newButton = button;
        SlotUtils.setSlot((HasElement)this, (String)"new-button", (Component[])new Component[]{button});
    }

    public Button getDeleteButton() {
        return this.deleteButton;
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public void addThemeVariants(CrudVariant ... variants) {
        List<String> variantNames = Crud.variantNames(variants);
        this.getThemeNames().addAll(variantNames);
        if (this.grid instanceof CrudGrid) {
            ((CrudGrid)this.grid).addCrudThemeVariants(variantNames);
        }
    }

    public void removeThemeVariants(CrudVariant ... variants) {
        List<String> variantNames = Crud.variantNames(variants);
        this.getThemeNames().removeAll(variantNames);
        if (this.grid instanceof CrudGrid) {
            ((CrudGrid)this.grid).removeCrudThemeVariants(variantNames);
        }
    }

    private static List<String> variantNames(CrudVariant ... variants) {
        return Arrays.stream(variants).map(CrudVariant::getVariantName).collect(Collectors.toList());
    }

    public Registration addNewListener(ComponentEventListener<NewEvent<E>> listener) {
        this.newListeners.add(listener);
        return (Registration & Serializable)() -> this.newListeners.remove(listener);
    }

    public Registration addEditListener(ComponentEventListener<EditEvent<E>> listener) {
        this.editListeners.add(listener);
        return (Registration & Serializable)() -> this.editListeners.remove(listener);
    }

    public Registration addSaveListener(ComponentEventListener<SaveEvent<E>> listener) {
        this.saveListeners.add(listener);
        return (Registration & Serializable)() -> this.saveListeners.remove(listener);
    }

    public Registration addCancelListener(ComponentEventListener<CancelEvent<E>> listener) {
        this.cancelListeners.add(listener);
        return (Registration & Serializable)() -> this.cancelListeners.remove(listener);
    }

    public Registration addDeleteListener(ComponentEventListener<DeleteEvent<E>> listener) {
        this.deleteListeners.add(listener);
        return (Registration & Serializable)() -> this.deleteListeners.remove(listener);
    }

    public DataProvider<E, ?> getDataProvider() {
        return this.grid.getDataProvider();
    }

    public void setDataProvider(DataProvider<E, ?> provider) {
        this.grid.setDataProvider(provider);
    }

    public static void addEditColumn(Grid<?> grid) {
        Crud.addEditColumn(grid, CrudI18n.createDefault());
    }

    public static void addEditColumn(Grid<?> grid, CrudI18n crudI18n) {
        grid.addColumn((Renderer)LitRenderer.of((String)Crud.createEditColumnTemplate(crudI18n))).setKey(EDIT_COLUMN_KEY).setWidth("4em").setFlexGrow(0);
    }

    private static String createEditColumnTemplate(CrudI18n crudI18n) {
        return "<vaadin-crud-edit aria-label=\"" + crudI18n.getEditLabel() + "\"></vaadin-crud-edit>";
    }

    public static void removeEditColumn(Grid<?> grid) {
        grid.removeColumnByKey(EDIT_COLUMN_KEY);
    }

    public static boolean hasEditColumn(Grid<?> grid) {
        return grid.getColumnByKey(EDIT_COLUMN_KEY) != null;
    }

    private class SaveButton
    extends Button {
        private SaveButton() {
        }

        public void onEnabledStateChanged(boolean enabled) {
            super.onEnabledStateChanged(enabled);
            Crud.this.saveBtnDisabledOverridden = true;
            Crud.this.overrideSaveDisabled(enabled);
        }
    }

    @DomEvent(value="new")
    public static class NewEvent<E>
    extends CrudEvent<E> {
        private E item;

        public NewEvent(Crud<E> source, boolean fromClient, @EventData(value="event.preventDefault()") Object ignored) {
            super(source, fromClient);
        }

        private NewEvent(Crud<E> source, boolean fromClient, E item, Object ignored) {
            super(source, fromClient);
            this.item = item;
        }

        @Override
        public E getItem() {
            return this.item;
        }
    }

    @DomEvent(value="edit")
    public static class EditEvent<E>
    extends CrudEvent<E> {
        private E item;

        public EditEvent(Crud<E> source, boolean fromClient, @EventData(value="event.detail.item") JsonObject item, @EventData(value="event.preventDefault()") Object ignored) {
            super(source, fromClient);
            this.item = source.getGrid().getDataCommunicator().getKeyMapper().get(item.getString("key"));
        }

        private EditEvent(Crud<E> source, boolean fromClient, E item) {
            super(source, fromClient);
            this.item = item;
        }

        @Override
        public E getItem() {
            return this.item;
        }
    }

    @DomEvent(value="cancel")
    public static class CancelEvent<E>
    extends CrudEvent<E> {
        public CancelEvent(Crud<E> source, boolean fromClient, @EventData(value="event.preventDefault()") Object ignored) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="save")
    public static class SaveEvent<E>
    extends CrudEvent<E> {
        public SaveEvent(Crud<E> source, boolean fromClient, @EventData(value="event.preventDefault()") Object ignored) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="delete")
    public static class DeleteEvent<E>
    extends CrudEvent<E> {
        public DeleteEvent(Crud<E> source, boolean fromClient, @EventData(value="event.preventDefault()") Object ignored) {
            super(source, fromClient);
        }
    }

    public static enum EditMode {
        NEW_ITEM,
        EXISTING_ITEM;

    }

    static abstract class CrudEvent<E>
    extends ComponentEvent<Crud<E>> {
        private CrudEvent(Crud<E> source, boolean fromClient) {
            super(source, fromClient);
        }

        public E getItem() {
            return ((Crud)this.getSource()).getEditor().getItem();
        }
    }
}

