/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu.testbench;

import com.vaadin.flow.component.contextmenu.testbench.ContextMenuItemElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-context-menu")
public class ContextMenuElement
extends TestBenchElement {
    public static ContextMenuElement openByRightClick(TestBenchElement target) {
        target.contextClick();
        TestBenchElement body = ContextMenuElement.wrapElement((WebElement)target.getDriver().findElement(By.tagName((String)"body")), (TestBenchCommandExecutor)target.getCommandExecutor());
        return (ContextMenuElement)body.$(ContextMenuElement.class).withAttribute("opened").waitForFirst();
    }

    public List<ContextMenuItemElement> getMenuItems() {
        TestBenchElement overlayContent = this.findElement(By.cssSelector((String)":scope > [slot='overlay']"));
        return overlayContent.$(ContextMenuItemElement.class).all();
    }

    public Optional<ContextMenuItemElement> getMenuItem(String text) {
        return this.getMenuItems().stream().filter(item -> item.getText().equals(text)).findFirst();
    }

    public boolean isOpen() {
        try {
            return this.hasAttribute("opened");
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
    }

    public void waitUntilClosed() {
        this.waitUntil(driver -> {
            try {
                return !this.hasAttribute("opened") && !this.hasAttribute("closing");
            }
            catch (StaleElementReferenceException e) {
                return true;
            }
        });
    }
}

