/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui.renderers;

import com.vaadin.v7.ui.Grid;
import elemental.json.JsonValue;
import java.text.NumberFormat;
import java.util.Locale;

@Deprecated
public class NumberRenderer
extends Grid.AbstractRenderer<Number> {
    private final Locale locale;
    private final NumberFormat numberFormat;
    private final String formatString;

    public NumberRenderer() {
        this(Locale.getDefault());
    }

    public NumberRenderer(NumberFormat numberFormat) {
        this(numberFormat, "");
    }

    public NumberRenderer(NumberFormat numberFormat, String nullRepresentation) throws IllegalArgumentException {
        super(Number.class, nullRepresentation);
        if (numberFormat == null) {
            throw new IllegalArgumentException("Number format may not be null");
        }
        this.locale = null;
        this.numberFormat = numberFormat;
        this.formatString = null;
    }

    public NumberRenderer(Locale locale) throws IllegalArgumentException {
        this("%s", locale);
    }

    public NumberRenderer(String formatString, Locale locale) throws IllegalArgumentException {
        this(formatString, locale, "");
    }

    public NumberRenderer(String formatString) throws IllegalArgumentException {
        this(formatString, Locale.getDefault(), "");
    }

    public NumberRenderer(String formatString, Locale locale, String nullRepresentation) {
        super(Number.class, nullRepresentation);
        if (formatString == null) {
            throw new IllegalArgumentException("Format string may not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale may not be null");
        }
        this.locale = locale;
        this.numberFormat = null;
        this.formatString = formatString;
    }

    @Override
    public JsonValue encode(Number value) {
        String stringValue;
        if (value == null) {
            stringValue = this.getNullRepresentation();
        } else if (this.formatString != null && this.locale != null) {
            stringValue = String.format(this.locale, this.formatString, value);
        } else if (this.numberFormat != null) {
            stringValue = this.numberFormat.format(value);
        } else {
            throw new IllegalStateException(String.format("Internal bug: %s is in an illegal state: [locale: %s, numberFormat: %s, formatString: %s]", this.getClass().getSimpleName(), this.locale, this.numberFormat, this.formatString));
        }
        return this.encode(stringValue, String.class);
    }

    public String toString() {
        String fieldInfo = this.numberFormat != null ? "numberFormat: " + this.numberFormat : "locale: " + this.locale + ", formatString: " + this.formatString;
        return String.format("%s [%s]", this.getClass().getSimpleName(), fieldInfo);
    }

    @Override
    public String getNullRepresentation() {
        return super.getNullRepresentation();
    }
}

