/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.Action;
import com.vaadin.event.ContextClickEvent;
import com.vaadin.event.MouseEvents;
import com.vaadin.event.SerializableEventListener;
import com.vaadin.event.dd.DragAndDropEvent;
import com.vaadin.event.dd.DragSource;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.DropTarget;
import com.vaadin.event.dd.acceptcriteria.ServerSideCriterion;
import com.vaadin.server.KeyMapper;
import com.vaadin.server.LegacyCommunicationManager;
import com.vaadin.server.LegacyPaint;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.server.Resource;
import com.vaadin.server.VariableOwner;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.shared.ui.MultiSelectMode;
import com.vaadin.shared.util.SharedUtil;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasChildMeasurementHint;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.UniqueSerializable;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import com.vaadin.ui.declarative.DesignFormatter;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.ContainerOrderedWrapper;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.converter.ConverterUtil;
import com.vaadin.v7.event.DataBoundTransferable;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.shared.ui.table.CollapseMenuContent;
import com.vaadin.v7.shared.ui.table.TableConstants;
import com.vaadin.v7.shared.ui.table.TableServerRpc;
import com.vaadin.v7.shared.ui.table.TableState;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.DefaultFieldFactory;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.TableFieldFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Deprecated
public class Table
extends AbstractSelect
implements Action.Container,
Container.Sortable,
ItemClickEvent.ItemClickNotifier,
DragSource,
DropTarget,
HasChildMeasurementHint {
    private transient Logger logger = null;
    protected static final int CELL_KEY = 0;
    protected static final int CELL_HEADER = 1;
    protected static final int CELL_ICON = 2;
    protected static final int CELL_ITEMID = 3;
    protected static final int CELL_GENERATED_ROW = 4;
    protected static final int CELL_FIRSTCOL = 5;
    @Deprecated
    public static final Align ALIGN_LEFT = Align.LEFT;
    @Deprecated
    public static final Align ALIGN_CENTER = Align.CENTER;
    @Deprecated
    public static final Align ALIGN_RIGHT = Align.RIGHT;
    @Deprecated
    public static final ColumnHeaderMode COLUMN_HEADER_MODE_HIDDEN = ColumnHeaderMode.HIDDEN;
    @Deprecated
    public static final ColumnHeaderMode COLUMN_HEADER_MODE_ID = ColumnHeaderMode.ID;
    @Deprecated
    public static final ColumnHeaderMode COLUMN_HEADER_MODE_EXPLICIT = ColumnHeaderMode.EXPLICIT;
    @Deprecated
    public static final ColumnHeaderMode COLUMN_HEADER_MODE_EXPLICIT_DEFAULTS_ID = ColumnHeaderMode.EXPLICIT_DEFAULTS_ID;
    @Deprecated
    public static final RowHeaderMode ROW_HEADER_MODE_HIDDEN = RowHeaderMode.HIDDEN;
    @Deprecated
    public static final RowHeaderMode ROW_HEADER_MODE_ID = RowHeaderMode.ID;
    @Deprecated
    public static final RowHeaderMode ROW_HEADER_MODE_ITEM = RowHeaderMode.ITEM;
    @Deprecated
    public static final RowHeaderMode ROW_HEADER_MODE_INDEX = RowHeaderMode.INDEX;
    @Deprecated
    public static final RowHeaderMode ROW_HEADER_MODE_EXPLICIT_DEFAULTS_ID = RowHeaderMode.EXPLICIT_DEFAULTS_ID;
    @Deprecated
    public static final RowHeaderMode ROW_HEADER_MODE_EXPLICIT = RowHeaderMode.EXPLICIT;
    @Deprecated
    public static final RowHeaderMode ROW_HEADER_MODE_ICON_ONLY = RowHeaderMode.ICON_ONLY;
    @Deprecated
    public static final RowHeaderMode ROW_HEADER_MODE_PROPERTY = RowHeaderMode.PROPERTY;
    private static final double CACHE_RATE_DEFAULT = 2.0;
    private static final String ROW_HEADER_COLUMN_KEY = "0";
    private static final Object ROW_HEADER_FAKE_PROPERTY_ID = new UniqueSerializable(){};
    private HasChildMeasurementHint.ChildMeasurementHint childMeasurementHint = HasChildMeasurementHint.ChildMeasurementHint.MEASURE_ALWAYS;
    private boolean columnCollapsingAllowed = false;
    private boolean columnReorderingAllowed = false;
    private final KeyMapper<Object> columnIdMap = new KeyMapper();
    private LinkedList<Object> visibleColumns = new LinkedList();
    private HashSet<Object> noncollapsibleColumns = new HashSet();
    private final HashSet<Object> collapsedColumns = new HashSet();
    private final Map<Object, String> columnHeaders = new HashMap<Object, String>();
    private final Map<Object, String> columnFooters = new HashMap<Object, String>();
    private final Map<Object, Resource> columnIcons = new HashMap<Object, Resource>();
    private Map<Object, Align> columnAlignments = new HashMap<Object, Align>();
    private final Map<Object, Integer> columnWidths = new HashMap<Object, Integer>();
    private final Map<Object, Float> columnExpandRatios = new HashMap<Object, Float>();
    private final Map<Object, ColumnGenerator> columnGenerators = new LinkedHashMap<Object, ColumnGenerator>();
    private int pageLength = 15;
    private Object currentPageFirstItemId = null;
    private int repairOnReAddAllRowsDataScrollPositionItemIndex = -1;
    private int currentPageFirstItemIndex = 0;
    private int currentPageFirstItemIndexOnLastPage = -1;
    private Boolean selectable;
    private ColumnHeaderMode columnHeaderMode = ColumnHeaderMode.EXPLICIT_DEFAULTS_ID;
    private RowHeaderMode rowHeaderMode = RowHeaderMode.EXPLICIT_DEFAULTS_ID;
    private boolean columnFootersVisible = false;
    private Object[][] pageBuffer = null;
    private HashSet<Property<?>> listenedProperties = null;
    private HashSet<Component> visibleComponents = null;
    private LinkedList<Action.Handler> actionHandlers = null;
    private KeyMapper<Action> actionMapper = null;
    private TableFieldFactory fieldFactory = DefaultFieldFactory.get();
    private boolean editable = false;
    private boolean sortAscending = true;
    private Object sortContainerPropertyId = null;
    private boolean sortEnabled = true;
    private int reqRowsToPaint = -1;
    private int reqFirstRowToPaint = -1;
    private int firstToBeRenderedInClient = -1;
    private int lastToBeRenderedInClient = -1;
    private boolean isContentRefreshesEnabled = true;
    private int pageBufferFirstIndex;
    private boolean containerChangeToBeRendered = false;
    private CellStyleGenerator cellStyleGenerator = null;
    private AbstractSelect.ItemDescriptionGenerator itemDescriptionGenerator;
    protected boolean alwaysRecalculateColumnWidths = false;
    private double cacheRate = 2.0;
    private TableDragMode dragMode = TableDragMode.NONE;
    private DropHandler dropHandler;
    private MultiSelectMode multiSelectMode = MultiSelectMode.DEFAULT;
    private boolean multiSelectTouchDetectionEnabled = true;
    private boolean rowCacheInvalidated;
    private RowGenerator rowGenerator = null;
    private final Map<Field<?>, Property<?>> associatedProperties = new HashMap();
    private boolean painted = false;
    private Map<Object, Converter<String, Object>> propertyValueConverters = new HashMap<Object, Converter<String, Object>>();
    private boolean keyMapperReset;
    private List<Throwable> exceptionsDuringCachePopulation = new ArrayList<Throwable>();
    private boolean isBeingPainted;

    public Table() {
        this.setRowHeaderMode(ROW_HEADER_MODE_HIDDEN);
        this.registerRpc((ServerRpc)new TableServerRpc(){

            public void contextClick(String rowKey, String colKey, TableConstants.Section section, MouseEventDetails details) {
                Object itemId = Table.this.itemIdMapper.get(rowKey);
                Object propertyId = Table.this.columnIdMap.get(colKey);
                Table.this.fireEvent((EventObject)((Object)new TableContextClickEvent(Table.this, details, itemId, propertyId, section)));
            }
        });
    }

    public Table(String caption) {
        this();
        this.setCaption(caption);
    }

    public Table(String caption, Container dataSource) {
        this();
        this.setCaption(caption);
        this.setContainerDataSource(dataSource);
    }

    public Object[] getVisibleColumns() {
        if (this.visibleColumns == null) {
            return null;
        }
        return this.visibleColumns.toArray();
    }

    public void setVisibleColumns(Object ... visibleColumns) {
        if (visibleColumns == null) {
            throw new NullPointerException("Can not set visible columns to null value");
        }
        LinkedList<Object> newVC = new LinkedList<Object>();
        Collection<?> properties = this.getContainerPropertyIds();
        for (Object id : visibleColumns) {
            if (id == null) {
                throw new NullPointerException("Ids must be non-nulls");
            }
            if (!properties.contains(id) && !this.columnGenerators.containsKey(id)) {
                throw new IllegalArgumentException("Ids must exist in the Container or as a generated column, missing id: " + id);
            }
            if (newVC.contains(id)) {
                throw new IllegalArgumentException("Ids must be unique, duplicate id: " + id);
            }
            newVC.add(id);
        }
        this.visibleColumns = newVC;
        this.refreshRowCache();
    }

    public String[] getColumnHeaders() {
        if (this.columnHeaders == null) {
            return null;
        }
        String[] headers = new String[this.visibleColumns.size()];
        int i = 0;
        for (Object e : this.visibleColumns) {
            headers[i++] = this.getColumnHeader(e);
        }
        return headers;
    }

    public void setColumnHeaders(String ... columnHeaders) {
        if (columnHeaders.length != this.visibleColumns.size()) {
            throw new IllegalArgumentException("The length of the headers array must match the number of visible columns");
        }
        this.columnHeaders.clear();
        int i = 0;
        for (Object e : this.visibleColumns) {
            if (i >= columnHeaders.length) break;
            this.columnHeaders.put(e, columnHeaders[i++]);
        }
        this.markAsDirty();
    }

    public Resource[] getColumnIcons() {
        if (this.columnIcons == null) {
            return null;
        }
        Resource[] icons = new Resource[this.visibleColumns.size()];
        int i = 0;
        for (Object e : this.visibleColumns) {
            icons[i++] = this.columnIcons.get(e);
        }
        return icons;
    }

    public void setColumnIcons(Resource ... columnIcons) {
        if (columnIcons.length != this.visibleColumns.size()) {
            throw new IllegalArgumentException("The length of the icons array must match the number of visible columns");
        }
        this.columnIcons.clear();
        int i = 0;
        for (Object e : this.visibleColumns) {
            if (i >= columnIcons.length) break;
            this.columnIcons.put(e, columnIcons[i++]);
        }
        this.markAsDirty();
    }

    public Align[] getColumnAlignments() {
        if (this.columnAlignments == null) {
            return null;
        }
        Align[] alignments = new Align[this.visibleColumns.size()];
        int i = 0;
        for (Object e : this.visibleColumns) {
            alignments[i++] = this.getColumnAlignment(e);
        }
        return alignments;
    }

    public void setColumnAlignments(Align ... columnAlignments) {
        if (columnAlignments.length != this.visibleColumns.size()) {
            throw new IllegalArgumentException("The length of the alignments array must match the number of visible columns");
        }
        HashMap<Object, Align> newCA = new HashMap<Object, Align>();
        int i = 0;
        for (Object e : this.visibleColumns) {
            if (i >= columnAlignments.length) break;
            newCA.put(e, columnAlignments[i++]);
        }
        this.columnAlignments = newCA;
        this.refreshRenderedCells();
    }

    public void setColumnWidth(Object propertyId, int width) {
        if (propertyId == null) {
            propertyId = ROW_HEADER_FAKE_PROPERTY_ID;
        }
        this.columnExpandRatios.remove(propertyId);
        if (width < 0) {
            this.columnWidths.remove(propertyId);
        } else {
            this.columnWidths.put(propertyId, width);
        }
        this.markAsDirty();
    }

    public void setColumnExpandRatio(Object propertyId, float expandRatio) {
        if (propertyId == null) {
            propertyId = ROW_HEADER_FAKE_PROPERTY_ID;
        }
        this.columnWidths.remove(propertyId);
        if (expandRatio < 0.0f) {
            this.columnExpandRatios.remove(propertyId);
        } else {
            this.columnExpandRatios.put(propertyId, Float.valueOf(expandRatio));
        }
        this.requestRepaint();
    }

    public float getColumnExpandRatio(Object propertyId) {
        Float width = this.columnExpandRatios.get(propertyId);
        if (width == null) {
            return -1.0f;
        }
        return width.floatValue();
    }

    public int getColumnWidth(Object propertyId) {
        Integer width;
        if (propertyId == null) {
            propertyId = ROW_HEADER_FAKE_PROPERTY_ID;
        }
        if ((width = this.columnWidths.get(propertyId)) == null) {
            return -1;
        }
        return width;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public void setPageLength(int pageLength) {
        if (pageLength >= 0 && this.pageLength != pageLength) {
            this.pageLength = pageLength;
            this.refreshRowCache();
        }
    }

    public void setCacheRate(double cacheRate) {
        if (cacheRate < 0.0) {
            throw new IllegalArgumentException("cacheRate cannot be less than zero");
        }
        if (this.cacheRate != cacheRate) {
            this.cacheRate = cacheRate;
            this.markAsDirty();
        }
    }

    public double getCacheRate() {
        return this.cacheRate;
    }

    public Object getCurrentPageFirstItemId() {
        if (this.items instanceof Container.Indexed) {
            int index = this.getCurrentPageFirstItemIndex();
            Object id = null;
            if (index >= 0 && index < this.size()) {
                id = this.getIdByIndex(index);
            }
            if (id != null && !id.equals(this.currentPageFirstItemId)) {
                this.currentPageFirstItemId = id;
            }
        }
        if (this.currentPageFirstItemId == null) {
            this.currentPageFirstItemId = this.firstItemId();
        }
        return this.currentPageFirstItemId;
    }

    protected Object getIdByIndex(int index) {
        return ((Container.Indexed)this.items).getIdByIndex(index);
    }

    public void setCurrentPageFirstItemId(Object currentPageFirstItemId) {
        int index = -1;
        if (this.items instanceof Container.Indexed) {
            index = this.indexOfId(currentPageFirstItemId);
        } else {
            Object id = this.firstItemId();
            while (id != null && !id.equals(currentPageFirstItemId)) {
                ++index;
                id = this.nextItemId(id);
            }
            if (id == null) {
                index = -1;
            }
        }
        if (index >= 0) {
            int maxIndex = this.size() - this.pageLength;
            if (maxIndex < 0) {
                maxIndex = 0;
            }
            if (index > maxIndex) {
                this.setCurrentPageFirstItemIndex(index);
                return;
            }
            this.currentPageFirstItemId = currentPageFirstItemId;
            this.currentPageFirstItemIndex = index;
        }
        this.refreshRowCache();
    }

    protected int indexOfId(Object itemId) {
        return ((Container.Indexed)this.items).indexOfId(itemId);
    }

    public Resource getColumnIcon(Object propertyId) {
        return this.columnIcons.get(propertyId);
    }

    public void setColumnIcon(Object propertyId, Resource icon) {
        if (icon == null) {
            this.columnIcons.remove(propertyId);
        } else {
            this.columnIcons.put(propertyId, icon);
        }
        this.markAsDirty();
    }

    public String getColumnHeader(Object propertyId) {
        if (this.getColumnHeaderMode() == ColumnHeaderMode.HIDDEN) {
            return null;
        }
        String header = this.columnHeaders.get(propertyId);
        if (header == null && this.getColumnHeaderMode() == ColumnHeaderMode.EXPLICIT_DEFAULTS_ID || this.getColumnHeaderMode() == ColumnHeaderMode.ID) {
            header = propertyId.toString();
        }
        return header;
    }

    public void setColumnHeader(Object propertyId, String header) {
        if (header == null) {
            this.columnHeaders.remove(propertyId);
        } else {
            this.columnHeaders.put(propertyId, header);
        }
        this.markAsDirty();
    }

    public Align getColumnAlignment(Object propertyId) {
        Align a = this.columnAlignments.get(propertyId);
        return a == null ? Align.LEFT : a;
    }

    public void setColumnAlignment(Object propertyId, Align alignment) {
        if (alignment == null || alignment == Align.LEFT) {
            this.columnAlignments.remove(propertyId);
        } else {
            this.columnAlignments.put(propertyId, alignment);
        }
        this.refreshRenderedCells();
    }

    public boolean isColumnCollapsed(Object propertyId) {
        return this.collapsedColumns != null && this.collapsedColumns.contains(propertyId);
    }

    public void setColumnCollapsed(Object propertyId, boolean collapsed) throws IllegalStateException {
        if (!this.isColumnCollapsingAllowed()) {
            throw new IllegalStateException("Column collapsing not allowed!");
        }
        if (collapsed && this.noncollapsibleColumns.contains(propertyId)) {
            throw new IllegalStateException("The column is noncollapsible!");
        }
        if (!this.getContainerPropertyIds().contains(propertyId) && !this.columnGenerators.containsKey(propertyId)) {
            throw new IllegalArgumentException("Property '" + propertyId + "' was not found in the container");
        }
        if (collapsed) {
            if (this.collapsedColumns.add(propertyId)) {
                this.fireColumnCollapseEvent(propertyId);
            }
        } else if (this.collapsedColumns.remove(propertyId)) {
            this.fireColumnCollapseEvent(propertyId);
        }
        this.refreshRowCache();
    }

    public boolean isColumnCollapsingAllowed() {
        return this.columnCollapsingAllowed;
    }

    public void setColumnCollapsingAllowed(boolean collapsingAllowed) {
        this.columnCollapsingAllowed = collapsingAllowed;
        if (!collapsingAllowed) {
            this.collapsedColumns.clear();
        }
        this.refreshRenderedCells();
    }

    public void setColumnCollapsible(Object propertyId, boolean collapsible) {
        if (collapsible) {
            this.noncollapsibleColumns.remove(propertyId);
        } else {
            this.noncollapsibleColumns.add(propertyId);
            this.collapsedColumns.remove(propertyId);
        }
        this.refreshRowCache();
    }

    public boolean isColumnCollapsible(Object propertyId) {
        return !this.noncollapsibleColumns.contains(propertyId);
    }

    public boolean isColumnReorderingAllowed() {
        return this.columnReorderingAllowed;
    }

    public void setColumnReorderingAllowed(boolean columnReorderingAllowed) {
        if (columnReorderingAllowed != this.columnReorderingAllowed) {
            this.columnReorderingAllowed = columnReorderingAllowed;
            this.markAsDirty();
        }
    }

    private void setColumnOrder(Object[] columnOrder) {
        if (columnOrder == null || !this.isColumnReorderingAllowed()) {
            return;
        }
        LinkedList<Object> newOrder = new LinkedList<Object>();
        for (Object id : columnOrder) {
            if (id == null || !this.visibleColumns.contains(id)) continue;
            this.visibleColumns.remove(id);
            newOrder.add(id);
        }
        for (Object e : this.visibleColumns) {
            if (newOrder.contains(e)) continue;
            newOrder.add(e);
        }
        this.visibleColumns = newOrder;
        this.refreshRowCache();
    }

    public int getCurrentPageFirstItemIndex() {
        return this.currentPageFirstItemIndex;
    }

    void setCurrentPageFirstItemIndex(int newIndex, boolean needsPageBufferReset) {
        int size;
        int maxIndex;
        if (newIndex < 0) {
            newIndex = 0;
        }
        if ((maxIndex = (size = this.size()) - this.pageLength) < 0) {
            maxIndex = 0;
        }
        int indexOnLastPage = -1;
        if (newIndex > maxIndex) {
            indexOnLastPage = newIndex;
            newIndex = maxIndex;
        }
        if (this.items instanceof Container.Indexed) {
            try {
                this.currentPageFirstItemId = this.getIdByIndex(newIndex);
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPageFirstItemId = null;
            }
            this.currentPageFirstItemIndex = newIndex;
            if (needsPageBufferReset) {
                boolean isLastRowPossiblyPartiallyVisible = true;
                if (indexOnLastPage != -1) {
                    isLastRowPossiblyPartiallyVisible = false;
                }
                int extraRows = isLastRowPossiblyPartiallyVisible ? 0 : 1;
                this.currentPageFirstItemIndexOnLastPage = this.currentPageFirstItemIndex + extraRows;
            } else {
                this.currentPageFirstItemIndexOnLastPage = -1;
            }
        } else {
            this.currentPageFirstItemId = this.firstItemId();
            while (this.currentPageFirstItemIndex < newIndex && !this.isLastId(this.currentPageFirstItemId)) {
                ++this.currentPageFirstItemIndex;
                this.currentPageFirstItemId = this.nextItemId(this.currentPageFirstItemId);
            }
            if (this.isLastId(this.currentPageFirstItemId)) {
                this.currentPageFirstItemIndex = size - 1;
            }
            while (this.currentPageFirstItemIndex > newIndex && !this.isFirstId(this.currentPageFirstItemId)) {
                --this.currentPageFirstItemIndex;
                this.currentPageFirstItemId = this.prevItemId(this.currentPageFirstItemId);
            }
            if (this.isFirstId(this.currentPageFirstItemId)) {
                this.currentPageFirstItemIndex = 0;
            }
            while (this.currentPageFirstItemIndex < newIndex && !this.isLastId(this.currentPageFirstItemId)) {
                ++this.currentPageFirstItemIndex;
                this.currentPageFirstItemId = this.nextItemId(this.currentPageFirstItemId);
            }
            if (this.isLastId(this.currentPageFirstItemId)) {
                newIndex = this.currentPageFirstItemIndex = size - 1;
            }
        }
        if (needsPageBufferReset) {
            this.refreshRowCache();
        }
    }

    public void setCurrentPageFirstItemIndex(int newIndex) {
        this.setCurrentPageFirstItemIndex(newIndex, true);
    }

    public boolean isSelectable() {
        if (this.selectable == null) {
            return this.hasListeners(Field.ValueChangeEvent.class);
        }
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        if (!SharedUtil.equals((Object)this.selectable, (Object)selectable)) {
            this.selectable = selectable;
            this.markAsDirty();
        }
    }

    public ColumnHeaderMode getColumnHeaderMode() {
        return this.columnHeaderMode;
    }

    public void setColumnHeaderMode(ColumnHeaderMode columnHeaderMode) {
        if (columnHeaderMode == null) {
            throw new IllegalArgumentException("Column header mode can not be null");
        }
        if (columnHeaderMode != this.columnHeaderMode) {
            this.columnHeaderMode = columnHeaderMode;
            this.markAsDirty();
        }
    }

    protected void refreshRenderedCells() {
        int totalRows;
        if (!this.isAttached()) {
            return;
        }
        if (!this.isContentRefreshesEnabled) {
            return;
        }
        int pagelen = this.getPageLength();
        int rows = totalRows = this.size();
        int firstIndex = Math.min(this.getCurrentPageFirstItemIndex(), totalRows - 1);
        if (rows > 0 && firstIndex >= 0) {
            rows -= firstIndex;
        }
        if (pagelen > 0 && pagelen < rows) {
            rows = pagelen;
        }
        if (this.lastToBeRenderedInClient - this.firstToBeRenderedInClient > 0) {
            rows = this.lastToBeRenderedInClient - this.firstToBeRenderedInClient + 1;
        }
        if (this.firstToBeRenderedInClient >= 0) {
            firstIndex = this.firstToBeRenderedInClient < totalRows ? this.firstToBeRenderedInClient : totalRows - 1;
        } else {
            if (firstIndex > 0) {
                --firstIndex;
                ++rows;
            }
            this.firstToBeRenderedInClient = firstIndex;
        }
        if (totalRows > 0) {
            if (rows + firstIndex > totalRows) {
                rows = totalRows - firstIndex;
            }
        } else {
            rows = 0;
        }
        this.pageBuffer = this.getVisibleCellsNoCache(firstIndex, rows, true);
        if (rows > 0) {
            this.pageBufferFirstIndex = firstIndex;
        }
        this.setRowCacheInvalidated(true);
        this.markAsDirty();
        this.maybeThrowCacheUpdateExceptions();
    }

    private void maybeThrowCacheUpdateExceptions() {
        if (!this.exceptionsDuringCachePopulation.isEmpty()) {
            Throwable[] causes = new Throwable[this.exceptionsDuringCachePopulation.size()];
            this.exceptionsDuringCachePopulation.toArray(causes);
            this.exceptionsDuringCachePopulation.clear();
            throw new CacheUpdateException(this, "Error during Table cache update.", causes);
        }
    }

    @Deprecated
    public void requestRepaint() {
        this.markAsDirty();
    }

    public void markAsDirty() {
        super.markAsDirty();
    }

    public void markAsDirtyRecursive() {
        super.markAsDirtyRecursive();
        this.refreshRowCache();
    }

    private void removeRowsFromCacheAndFillBottom(int firstIndex, int rows) {
        int firstAppendedRowInPageBuffer;
        int firstAppendedRow;
        int maxRowsToRender;
        int rowsToAdd;
        int totalCachedRows = this.pageBuffer[3].length;
        int totalRows = this.size();
        int firstIndexInPageBuffer = firstIndex - this.pageBufferFirstIndex;
        if (firstIndexInPageBuffer + rows > totalCachedRows) {
            rows = totalCachedRows - firstIndexInPageBuffer;
        }
        this.unregisterComponentsAndPropertiesInRows(firstIndex, rows);
        int newCachedRowCount = totalCachedRows;
        if (newCachedRowCount + this.pageBufferFirstIndex > totalRows) {
            newCachedRowCount = totalRows - this.pageBufferFirstIndex;
        }
        if ((rowsToAdd = rows) > (maxRowsToRender = totalRows - (firstAppendedRow = (firstAppendedRowInPageBuffer = totalCachedRows - rows) + this.pageBufferFirstIndex))) {
            rowsToAdd = maxRowsToRender;
        }
        Object[][] cells = null;
        if (rowsToAdd > 0) {
            cells = this.getVisibleCellsNoCache(firstAppendedRow, rowsToAdd, false);
        }
        Object[][] newPageBuffer = new Object[this.pageBuffer.length][newCachedRowCount];
        for (int i = 0; i < this.pageBuffer.length; ++i) {
            int row;
            for (row = 0; row < firstIndexInPageBuffer; ++row) {
                newPageBuffer[i][row] = this.pageBuffer[i][row];
            }
            for (row = firstIndexInPageBuffer; row < firstAppendedRowInPageBuffer; ++row) {
                newPageBuffer[i][row] = this.pageBuffer[i][row + rows];
            }
            for (row = firstAppendedRowInPageBuffer; row < newCachedRowCount; ++row) {
                newPageBuffer[i][row] = cells[i][row - firstAppendedRowInPageBuffer];
            }
        }
        this.pageBuffer = newPageBuffer;
    }

    private Object[][] getVisibleCellsUpdateCacheRows(int firstIndex, int rows) {
        Object[][] cells = this.getVisibleCellsNoCache(firstIndex, rows, false);
        int cacheIx = firstIndex - this.pageBufferFirstIndex;
        int totalCachedRows = this.pageBuffer[3].length;
        int end = Math.min(cacheIx + rows, totalCachedRows);
        for (int ix = cacheIx; ix < end; ++ix) {
            for (int i = 0; i < this.pageBuffer.length; ++i) {
                this.pageBuffer[i][ix] = cells[i][ix - cacheIx];
            }
        }
        return cells;
    }

    private Object[][] getVisibleCellsInsertIntoCache(int firstIndex, int rows) {
        int rowsFromAfter;
        this.getLogger().log(Level.FINEST, "Insert {0} rows at index {1} to existing page buffer requested", new Object[]{rows, firstIndex});
        int minPageBufferIndex = this.getMinPageBufferIndex();
        int maxPageBufferIndex = this.getMaxPageBufferIndex();
        int maxBufferSize = maxPageBufferIndex - minPageBufferIndex + 1;
        if (this.getPageLength() == 0) {
            maxBufferSize = this.pageBuffer[3].length + rows;
        }
        int currentlyCachedRowCount = this.pageBuffer[3].length;
        if (firstIndex + rows - 1 > maxPageBufferIndex) {
            rows = maxPageBufferIndex - firstIndex + 1;
        }
        int lastCacheRowToRemove = minPageBufferIndex - 1;
        int rowsFromBeginning = lastCacheRowToRemove - this.pageBufferFirstIndex + 1;
        if (lastCacheRowToRemove >= this.pageBufferFirstIndex) {
            this.unregisterComponentsAndPropertiesInRows(this.pageBufferFirstIndex, rowsFromBeginning);
        } else {
            rowsFromBeginning = 0;
        }
        int firstCacheRowToRemove = firstIndex;
        int numberOfOldRowsAfterInsertedRows = Math.min(this.pageBufferFirstIndex + currentlyCachedRowCount + rows, maxPageBufferIndex + 1) - (firstIndex + rows - 1);
        if (numberOfOldRowsAfterInsertedRows > 0) {
            firstCacheRowToRemove += numberOfOldRowsAfterInsertedRows;
        }
        if ((rowsFromAfter = currentlyCachedRowCount - (firstCacheRowToRemove - this.pageBufferFirstIndex)) > 0) {
            this.unregisterComponentsAndPropertiesInRows(firstCacheRowToRemove, rowsFromAfter);
        }
        int newCachedRowCount = maxBufferSize;
        if (this.pageBufferFirstIndex + currentlyCachedRowCount + rows - 1 < maxPageBufferIndex) {
            newCachedRowCount -= maxPageBufferIndex - (this.pageBufferFirstIndex + currentlyCachedRowCount + rows - 1);
        } else if (minPageBufferIndex < this.pageBufferFirstIndex) {
            newCachedRowCount -= this.pageBufferFirstIndex - minPageBufferIndex;
        }
        int firstIndexInNewPageBuffer = firstIndex - this.pageBufferFirstIndex - rowsFromBeginning;
        Object[][] cells = this.getVisibleCellsNoCache(firstIndex, rows, false);
        Object[][] newPageBuffer = new Object[this.pageBuffer.length][newCachedRowCount];
        for (int i = 0; i < this.pageBuffer.length; ++i) {
            int row;
            for (row = 0; row < firstIndexInNewPageBuffer; ++row) {
                newPageBuffer[i][row] = this.pageBuffer[i][rowsFromBeginning + row];
            }
            for (row = firstIndexInNewPageBuffer; row < firstIndexInNewPageBuffer + rows; ++row) {
                newPageBuffer[i][row] = cells[i][row - firstIndexInNewPageBuffer];
            }
            for (row = firstIndexInNewPageBuffer + rows; row < newCachedRowCount; ++row) {
                newPageBuffer[i][row] = this.pageBuffer[i][rowsFromBeginning + row - rows];
            }
        }
        this.pageBuffer = newPageBuffer;
        this.pageBufferFirstIndex = Math.max(this.pageBufferFirstIndex + rowsFromBeginning, minPageBufferIndex);
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, "Page Buffer now contains {0} rows ({1}-{2})", new Object[]{this.pageBuffer[3].length, this.pageBufferFirstIndex, this.pageBufferFirstIndex + this.pageBuffer[3].length - 1});
        }
        return cells;
    }

    private int getMaxPageBufferIndex() {
        int total = this.size();
        if (this.getPageLength() == 0) {
            return total - 1;
        }
        int maxPageBufferIndex = this.getCurrentPageFirstItemIndex() + (int)((double)this.getPageLength() * (1.0 + this.getCacheRate()));
        if (this.shouldHideNullSelectionItem()) {
            --total;
        }
        if (maxPageBufferIndex >= total) {
            maxPageBufferIndex = total - 1;
        }
        return maxPageBufferIndex;
    }

    private int getMinPageBufferIndex() {
        if (this.getPageLength() == 0) {
            return 0;
        }
        int minPageBufferIndex = this.getCurrentPageFirstItemIndex() - (int)((double)this.getPageLength() * this.getCacheRate());
        if (minPageBufferIndex < 0) {
            minPageBufferIndex = 0;
        }
        return minPageBufferIndex;
    }

    private Object[][] getVisibleCellsNoCache(int firstIndex, int rows, boolean replaceListeners) {
        int i;
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, "Render visible cells for rows {0}-{1}", new Object[]{firstIndex, firstIndex + rows - 1});
        }
        Object[] colids = this.getVisibleColumns();
        int cols = colids.length;
        HashSet<Property<?>> oldListenedProperties = this.listenedProperties;
        HashSet<Component> oldVisibleComponents = this.visibleComponents;
        if (replaceListeners) {
            this.listenedProperties = new HashSet();
            this.visibleComponents = new HashSet();
        }
        Object[][] cells = new Object[cols + 5][rows];
        if (rows == 0) {
            this.unregisterPropertiesAndComponents(oldListenedProperties, oldVisibleComponents);
            return cells;
        }
        RowHeaderMode headmode = this.getRowHeaderMode();
        boolean[] iscomponent = new boolean[cols];
        for (int i2 = 0; i2 < cols; ++i2) {
            iscomponent[i2] = this.columnGenerators.containsKey(colids[i2]) || Component.class.isAssignableFrom(this.getType(colids[i2]));
        }
        int firstIndexNotInCache = this.pageBuffer != null && this.pageBuffer[3].length > 0 ? this.pageBufferFirstIndex + this.pageBuffer[3].length : -1;
        int filledRows = 0;
        if (this.items instanceof Container.Indexed) {
            List<Object> itemIds = this.getItemIds(firstIndex, rows);
            for (i = 0; i < rows && i < itemIds.size(); ++i) {
                Object id = itemIds.get(i);
                if (id == null) {
                    throw new IllegalStateException("Null itemId returned from container");
                }
                this.parseItemIdToCells(cells, id, i, firstIndex, headmode, cols, colids, firstIndexNotInCache, iscomponent, oldListenedProperties);
                ++filledRows;
            }
        } else {
            Object id = this.firstItemId();
            for (i = 0; i < firstIndex; ++i) {
                id = this.nextItemId(id);
            }
            for (i = 0; i < rows && id != null; ++i) {
                this.parseItemIdToCells(cells, id, i, firstIndex, headmode, cols, colids, firstIndexNotInCache, iscomponent, oldListenedProperties);
                id = this.nextItemId(id);
                ++filledRows;
            }
        }
        if (filledRows != cells[0].length) {
            Object[][] temp = new Object[cells.length][filledRows];
            for (i = 0; i < cells.length; ++i) {
                for (int j = 0; j < filledRows; ++j) {
                    temp[i][j] = cells[i][j];
                }
            }
            cells = temp;
        }
        this.unregisterPropertiesAndComponents(oldListenedProperties, oldVisibleComponents);
        return cells;
    }

    protected List<Object> getItemIds(int firstIndex, int rows) {
        return ((Container.Indexed)this.items).getItemIds(firstIndex, rows);
    }

    private void parseItemIdToCells(Object[][] cells, Object id, int i, int firstIndex, RowHeaderMode headmode, int cols, Object[] colids, int firstIndexNotInCache, boolean[] iscomponent, HashSet<Property<?>> oldListenedProperties) {
        cells[3][i] = id;
        cells[0][i] = this.itemIdMapper.key(id);
        if (headmode != ROW_HEADER_MODE_HIDDEN) {
            switch (headmode) {
                case INDEX: {
                    cells[1][i] = String.valueOf(i + firstIndex + 1);
                    break;
                }
                default: {
                    try {
                        cells[1][i] = this.getItemCaption(id);
                        break;
                    }
                    catch (Exception e) {
                        this.exceptionsDuringCachePopulation.add(e);
                        cells[1][i] = "";
                    }
                }
            }
            try {
                cells[2][i] = this.getItemIcon(id);
            }
            catch (Exception e) {
                this.exceptionsDuringCachePopulation.add(e);
                cells[2][i] = null;
            }
        }
        int index = firstIndex + i;
        int indexInOldBuffer = index - this.pageBufferFirstIndex;
        boolean inPageBuffer = index < firstIndexNotInCache && index >= this.pageBufferFirstIndex && id.equals(this.pageBuffer[3][indexInOldBuffer]);
        GeneratedRow generatedRow = null;
        if (this.rowGenerator != null) {
            generatedRow = inPageBuffer ? (GeneratedRow)this.pageBuffer[4][indexInOldBuffer] : this.rowGenerator.generateRow(this, cells[3][i]);
            cells[4][i] = generatedRow;
        }
        int firstNotCollapsed = -1;
        for (int j = 0; j < cols; ++j) {
            boolean isGenerated;
            if (this.isColumnCollapsed(colids[j])) continue;
            if (firstNotCollapsed == -1) {
                firstNotCollapsed = j;
            }
            Property p = null;
            Object value = "";
            boolean isGeneratedColumn = this.columnGenerators.containsKey(colids[j]);
            boolean bl = isGenerated = isGeneratedColumn || generatedRow != null;
            if (!isGenerated) {
                try {
                    p = this.getContainerProperty(id, colids[j]);
                }
                catch (Exception e) {
                    this.exceptionsDuringCachePopulation.add(e);
                    value = null;
                }
            }
            if (p != null || isGenerated) {
                if (inPageBuffer) {
                    value = generatedRow != null ? this.extractGeneratedValue(generatedRow, j, j == firstNotCollapsed) : this.pageBuffer[5 + j][indexInOldBuffer];
                    if (!isGeneratedColumn && iscomponent[j] || !(value instanceof Component)) {
                        this.listenProperty(p, oldListenedProperties);
                    }
                } else if (generatedRow != null) {
                    value = this.extractGeneratedValue(generatedRow, j, j == firstNotCollapsed);
                } else if (isGeneratedColumn) {
                    ColumnGenerator cg = this.columnGenerators.get(colids[j]);
                    try {
                        value = cg.generateCell(this, id, colids[j]);
                    }
                    catch (Exception e) {
                        this.exceptionsDuringCachePopulation.add(e);
                        value = null;
                    }
                    if (value != null && !(value instanceof Component) && !(value instanceof String)) {
                        value = value.toString();
                    }
                } else if (iscomponent[j]) {
                    try {
                        value = p.getValue();
                    }
                    catch (Exception e) {
                        this.exceptionsDuringCachePopulation.add(e);
                        value = null;
                    }
                    this.listenProperty(p, oldListenedProperties);
                } else if (p != null) {
                    try {
                        value = this.getPropertyValue(id, colids[j], p);
                    }
                    catch (Exception e) {
                        this.exceptionsDuringCachePopulation.add(e);
                        value = null;
                    }
                    if (!(value instanceof Component)) {
                        this.listenProperty(p, oldListenedProperties);
                    }
                } else {
                    try {
                        value = this.getPropertyValue(id, colids[j], null);
                    }
                    catch (Exception e) {
                        this.exceptionsDuringCachePopulation.add(e);
                        value = null;
                    }
                }
            }
            if (value instanceof Component) {
                this.registerComponent((Component)value);
            }
            cells[5 + j][i] = value;
        }
    }

    private Object extractGeneratedValue(GeneratedRow generatedRow, int index, boolean firstVisibleColumn) {
        Object value = generatedRow.getValue();
        String[] text = generatedRow.getText();
        if (generatedRow.isSpanColumns()) {
            if (firstVisibleColumn) {
                if (value instanceof Component) {
                    return value;
                }
                if (text != null && text.length > 0) {
                    return text[0];
                }
            }
            return null;
        }
        if (text != null && text.length > index) {
            return text[index];
        }
        return null;
    }

    protected void registerComponent(Component component) {
        this.getLogger().log(Level.FINEST, "Registered {0}: {1}", new Object[]{component.getClass().getSimpleName(), component.getCaption()});
        if (!this.equals(component.getParent())) {
            component.setParent((HasComponents)this);
        }
        this.visibleComponents.add(component);
    }

    private void listenProperty(Property<?> p, HashSet<Property<?>> oldListenedProperties) {
        if (p instanceof Property.ValueChangeNotifier) {
            if (oldListenedProperties == null || !oldListenedProperties.contains(p)) {
                ((Property.ValueChangeNotifier)((Object)p)).addListener(this);
            }
            this.listenedProperties.add(p);
        }
    }

    private void unregisterComponentsAndPropertiesInRows(int firstIx, int count) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().log(Level.FINEST, "Unregistering components in rows {0}-{1}", new Object[]{firstIx, firstIx + count - 1});
        }
        Object[] colids = this.getVisibleColumns();
        if (this.pageBuffer != null && this.pageBuffer[3].length > 0) {
            int bufSize = this.pageBuffer[3].length;
            int ix = firstIx - this.pageBufferFirstIndex;
            int n = ix = ix < 0 ? 0 : ix;
            if (ix < bufSize) {
                count = count > bufSize - ix ? bufSize - ix : count;
                for (int i = 0; i < count; ++i) {
                    for (int c = 0; c < colids.length; ++c) {
                        Object cellVal = this.pageBuffer[5 + c][i + ix];
                        if (cellVal instanceof Component && this.visibleComponents.contains(cellVal)) {
                            this.visibleComponents.remove(cellVal);
                            this.unregisterComponent((Component)cellVal);
                            continue;
                        }
                        Property p = this.getContainerProperty(this.pageBuffer[3][i + ix], colids[c]);
                        if (!(p instanceof Property.ValueChangeNotifier) || !this.listenedProperties.contains(p)) continue;
                        this.listenedProperties.remove(p);
                        ((Property.ValueChangeNotifier)((Object)p)).removeListener(this);
                    }
                }
            }
        }
    }

    private void unregisterPropertiesAndComponents(HashSet<Property<?>> oldListenedProperties, HashSet<Component> oldVisibleComponents) {
        if (oldVisibleComponents != null) {
            for (Component component : oldVisibleComponents) {
                if (this.visibleComponents.contains(component)) continue;
                this.unregisterComponent(component);
            }
        }
        if (oldListenedProperties != null) {
            for (Property property : oldListenedProperties) {
                Property.ValueChangeNotifier o = (Property.ValueChangeNotifier)((Object)property);
                if (this.listenedProperties.contains(o)) continue;
                o.removeListener(this);
            }
        }
    }

    protected void unregisterComponent(Component component) {
        this.getLogger().log(Level.FINEST, "Unregistered {0}: {1}", new Object[]{component.getClass().getSimpleName(), component.getCaption()});
        component.setParent(null);
        if (component instanceof Field) {
            Field field = (Field)component;
            Property<?> associatedProperty = this.associatedProperties.remove(component);
            if (associatedProperty != null && field.getPropertyDataSource() == associatedProperty) {
                field.setPropertyDataSource(null);
            }
        }
    }

    public void setRowHeaderMode(RowHeaderMode mode) {
        if (mode != null) {
            this.rowHeaderMode = mode;
            if (mode != RowHeaderMode.HIDDEN) {
                this.setItemCaptionMode(mode.getItemCaptionMode());
            }
            this.refreshRenderedCells();
        }
    }

    public RowHeaderMode getRowHeaderMode() {
        return this.rowHeaderMode;
    }

    /*
     * WARNING - void declaration
     */
    public Object addItem(Object[] cells, Object itemId) throws UnsupportedOperationException {
        void var5_7;
        Item item;
        LinkedList availableCols = new LinkedList();
        for (Object e : this.visibleColumns) {
            if (this.columnGenerators.containsKey(e)) continue;
            availableCols.add(e);
        }
        if (cells.length != availableCols.size()) {
            return null;
        }
        if (itemId == null) {
            itemId = this.items.addItem();
            if (itemId == null) {
                return null;
            }
            item = this.items.getItem(itemId);
        } else {
            item = this.items.addItem(itemId);
        }
        if (item == null) {
            return null;
        }
        boolean bl = false;
        while (var5_7 < availableCols.size()) {
            item.getItemProperty(availableCols.get((int)var5_7)).setValue(cells[var5_7]);
            ++var5_7;
        }
        if (!(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.refreshRowCache();
        }
        return itemId;
    }

    public void refreshRowCache() {
        this.resetPageBuffer();
        this.refreshRenderedCells();
    }

    @Override
    public void setContainerDataSource(Container newDataSource) {
        if (newDataSource == null) {
            newDataSource = new IndexedContainer();
        }
        Collection<Object> generated = this.columnGenerators != null ? this.columnGenerators.keySet() : Collections.emptyList();
        ArrayList<Object> visibleIds = new ArrayList<Object>();
        if (generated.isEmpty()) {
            visibleIds.addAll(newDataSource.getContainerPropertyIds());
        } else {
            for (Object id : newDataSource.getContainerPropertyIds()) {
                if (generated.contains(id)) continue;
                visibleIds.add(id);
            }
            visibleIds.addAll(generated);
        }
        this.setContainerDataSource(newDataSource, visibleIds);
    }

    public void setContainerDataSource(Container newDataSource, Collection<?> visibleIds) {
        this.disableContentRefreshing();
        if (newDataSource == null) {
            newDataSource = new IndexedContainer();
        }
        if (visibleIds == null) {
            visibleIds = new ArrayList();
        }
        if (this.propertyValueConverters != null) {
            Collection<?> newPropertyIds = newDataSource.getContainerPropertyIds();
            LinkedList retainableValueConverters = new LinkedList();
            for (Object propertyId : newPropertyIds) {
                Converter<String, Object> converter = this.getConverter(propertyId);
                if (converter == null || !this.typeIsCompatible(converter.getModelType(), newDataSource.getType(propertyId))) continue;
                retainableValueConverters.add(propertyId);
            }
            this.propertyValueConverters.keySet().retainAll(retainableValueConverters);
        }
        if (newDataSource instanceof Container.Ordered) {
            super.setContainerDataSource(newDataSource);
        } else {
            super.setContainerDataSource(new ContainerOrderedWrapper(newDataSource));
        }
        this.currentPageFirstItemId = null;
        this.currentPageFirstItemIndex = 0;
        if (this.collapsedColumns != null) {
            this.collapsedColumns.clear();
        }
        LinkedList col = new LinkedList();
        for (Object id : visibleIds) {
            if (col.contains(id)) continue;
            col.add(id);
        }
        this.setVisibleColumns(col.toArray());
        this.resetPageBuffer();
        this.enableContentRefreshing(true);
    }

    private boolean typeIsCompatible(Class<?> a, Class<?> b) {
        return true;
    }

    private LinkedHashSet<Object> getItemIdsInRange(Object itemId, int length) {
        LinkedHashSet<Object> ids = new LinkedHashSet<Object>();
        for (int i = 0; i < length; ++i) {
            assert (itemId != null);
            ids.add(itemId);
            itemId = this.nextItemId(itemId);
        }
        return ids;
    }

    private void handleSelectedItems(Map<String, Object> variables) {
        String[] ka = (String[])variables.get("selected");
        String[] ranges = (String[])variables.get("selectedRanges");
        Set<Object> renderedButNotSelectedItemIds = this.getCurrentlyRenderedItemIds();
        LinkedHashSet<Object> newValue = new LinkedHashSet<Object>((Collection)this.getValue());
        if (variables.containsKey("clearSelections")) {
            newValue.clear();
        }
        for (String k : ka) {
            Object id = this.itemIdMapper.get(k);
            if (!(this.isNullSelectionAllowed() || id != null && id != this.getNullSelectionItemId())) {
                this.markAsDirty();
                continue;
            }
            if (id == null || !this.containsId(id)) continue;
            newValue.add(id);
            renderedButNotSelectedItemIds.remove(id);
        }
        if (ranges != null) {
            for (String range : ranges) {
                String[] split = range.split("-");
                Object startItemId = this.itemIdMapper.get(split[0]);
                int length = Integer.valueOf(split[1]);
                LinkedHashSet<Object> itemIdsInRange = this.getItemIdsInRange(startItemId, length);
                newValue.addAll(itemIdsInRange);
                renderedButNotSelectedItemIds.removeAll(itemIdsInRange);
            }
        }
        newValue.removeAll(renderedButNotSelectedItemIds);
        if (!this.isNullSelectionAllowed() && newValue.isEmpty()) {
            this.markAsDirty();
            return;
        }
        this.setValue(newValue, true);
    }

    private Set<Object> getCurrentlyRenderedItemIds() {
        HashSet<Object> ids = new HashSet<Object>();
        if (this.pageBuffer != null) {
            for (Object id : this.pageBuffer[3]) {
                ids.add(id);
            }
        }
        return ids;
    }

    @Override
    public void changeVariables(Object source, Map<String, Object> variables) {
        StringTokenizer st;
        Integer value;
        boolean clientNeedsContentRefresh = false;
        this.handleClickEvent(variables);
        this.handleColumnResizeEvent(variables);
        this.handleColumnWidthUpdates(variables);
        this.disableContentRefreshing();
        if (!this.isSelectable() && variables.containsKey("selected")) {
            variables = new HashMap<String, Object>(variables);
            variables.remove("selected");
        } else if (this.isSelectable() && this.isMultiSelect() && variables.containsKey("selected") && this.multiSelectMode == MultiSelectMode.DEFAULT) {
            this.handleSelectedItems(variables);
            variables = new HashMap<String, Object>(variables);
            variables.remove("selected");
        }
        super.changeVariables(source, variables);
        if (variables.containsKey("pagelength")) {
            this.pageLength = (Integer)variables.get("pagelength");
        }
        if (variables.containsKey("firstvisible") && (value = (Integer)variables.get("firstvisible")) != null) {
            this.setCurrentPageFirstItemIndex(value, false);
        }
        if (variables.containsKey("reqfirstrow") || variables.containsKey("reqrows")) {
            try {
                this.firstToBeRenderedInClient = (Integer)variables.get("firstToBeRendered");
                this.lastToBeRenderedInClient = (Integer)variables.get("lastToBeRendered");
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINER, "Could not parse the first and/or last rows.", e);
            }
            if (!this.containerChangeToBeRendered) {
                value = (Integer)variables.get("reqfirstrow");
                if (value != null) {
                    this.reqFirstRowToPaint = value;
                }
                if ((value = (Integer)variables.get("reqrows")) != null) {
                    this.reqRowsToPaint = value;
                    int size = this.size();
                    if (this.reqFirstRowToPaint >= size) {
                        this.reqFirstRowToPaint = size;
                    }
                    if (this.reqFirstRowToPaint + this.reqRowsToPaint > size) {
                        this.reqRowsToPaint = size - this.reqFirstRowToPaint;
                    }
                }
            }
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().log(Level.FINEST, "Client wants rows {0}-{1}", new Object[]{this.reqFirstRowToPaint, this.reqFirstRowToPaint + this.reqRowsToPaint - 1});
            }
            clientNeedsContentRefresh = true;
        }
        if (this.isSortEnabled()) {
            boolean state;
            String colId;
            boolean doSort = false;
            if (variables.containsKey("sortcolumn") && (colId = (String)variables.get("sortcolumn")) != null && !"".equals(colId) && !"null".equals(colId)) {
                Object id = this.columnIdMap.get(colId);
                this.setSortContainerPropertyId(id, false);
                doSort = true;
            }
            if (variables.containsKey("sortascending") && (state = ((Boolean)variables.get("sortascending")).booleanValue()) != this.sortAscending) {
                this.setSortAscending(state, false);
                doSort = true;
            }
            if (doSort) {
                this.sort();
                this.resetPageBuffer();
            }
        }
        if (this.isColumnCollapsingAllowed() && variables.containsKey("collapsedcolumns")) {
            try {
                Object[] ids = (Object[])variables.get("collapsedcolumns");
                HashSet<Object> idSet = new HashSet<Object>();
                for (Object id : ids) {
                    idSet.add(this.columnIdMap.get(id.toString()));
                }
                for (Object e : this.visibleColumns) {
                    if (this.isColumnCollapsed(e)) {
                        if (idSet.contains(e)) continue;
                        this.setColumnCollapsed(e, false);
                        continue;
                    }
                    if (!idSet.contains(e)) continue;
                    this.setColumnCollapsed(e, true);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINER, "Could not determine column collapsing state", e);
            }
            clientNeedsContentRefresh = true;
        }
        if (this.isColumnReorderingAllowed() && variables.containsKey("columnorder")) {
            try {
                Object[] ids = (Object[])variables.get("columnorder");
                Object[] idsTemp = new Object[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    idsTemp[i] = this.columnIdMap.get(ids[i].toString());
                }
                this.setColumnOrder(idsTemp);
                if (this.hasListeners(ColumnReorderEvent.class)) {
                    this.fireEvent((EventObject)((Object)new ColumnReorderEvent((Component)this)));
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINER, "Could not determine column reordering state", e);
            }
            clientNeedsContentRefresh = true;
        }
        this.enableContentRefreshing(clientNeedsContentRefresh);
        if (variables.containsKey("action") && (st = new StringTokenizer((String)variables.get("action"), ",")).countTokens() == 2) {
            Object itemId = this.itemIdMapper.get(st.nextToken());
            Action action = (Action)this.actionMapper.get(st.nextToken());
            if (action != null && (itemId == null || this.containsId(itemId)) && this.actionHandlers != null) {
                for (Action.Handler ah : this.actionHandlers) {
                    ah.handleAction(action, (Object)this, itemId);
                }
            }
        }
    }

    private void handleClickEvent(Map<String, Object> variables) {
        if (variables.containsKey("clickEvent")) {
            String key = (String)variables.get("clickedKey");
            Object itemId = this.itemIdMapper.get(key);
            Object propertyId = null;
            String colkey = (String)variables.get("clickedColKey");
            if (colkey != null) {
                propertyId = this.columnIdMap.get(colkey);
            }
            MouseEventDetails evt = MouseEventDetails.deSerialize((String)((String)variables.get("clickEvent")));
            Item item = this.getItem(itemId);
            if (item != null) {
                this.fireEvent((EventObject)((Object)new ItemClickEvent((Component)this, item, itemId, propertyId, evt)));
            }
        } else if (variables.containsKey("headerClickEvent")) {
            MouseEventDetails details = MouseEventDetails.deSerialize((String)((String)variables.get("headerClickEvent")));
            Object cid = variables.get("headerClickCID");
            Object propertyId = null;
            if (cid != null) {
                propertyId = this.columnIdMap.get(cid.toString());
            }
            this.fireEvent((EventObject)((Object)new HeaderClickEvent((Component)this, propertyId, details)));
        } else if (variables.containsKey("footerClickEvent")) {
            MouseEventDetails details = MouseEventDetails.deSerialize((String)((String)variables.get("footerClickEvent")));
            Object cid = variables.get("footerClickCID");
            Object propertyId = null;
            if (cid != null) {
                propertyId = this.columnIdMap.get(cid.toString());
            }
            this.fireEvent((EventObject)((Object)new FooterClickEvent((Component)this, propertyId, details)));
        }
    }

    private void handleColumnResizeEvent(Map<String, Object> variables) {
        if (variables.containsKey("columnResizeEventColumn")) {
            Object cid = variables.get("columnResizeEventColumn");
            Object propertyId = null;
            if (cid != null) {
                propertyId = this.columnIdMap.get(cid.toString());
                Object prev = variables.get("columnResizeEventPrev");
                int previousWidth = -1;
                if (prev != null) {
                    previousWidth = Integer.valueOf(prev.toString());
                }
                Object curr = variables.get("columnResizeEventCurr");
                int currentWidth = -1;
                if (curr != null) {
                    currentWidth = Integer.valueOf(curr.toString());
                }
                this.fireColumnResizeEvent(propertyId, previousWidth, currentWidth);
            }
        }
    }

    private void fireColumnCollapseEvent(Object propertyId) {
        this.fireEvent((EventObject)((Object)new ColumnCollapseEvent((Component)this, propertyId)));
    }

    private void fireColumnResizeEvent(Object propertyId, int previousWidth, int currentWidth) {
        this.setColumnWidth(propertyId, currentWidth);
        this.fireEvent((EventObject)((Object)new ColumnResizeEvent((Component)this, propertyId, previousWidth, currentWidth)));
    }

    private void handleColumnWidthUpdates(Map<String, Object> variables) {
        if (variables.containsKey("columnWidthUpdates")) {
            String[] events;
            for (String str : events = (String[])variables.get("columnWidthUpdates")) {
                String[] eventDetails = str.split(":");
                Object propertyId = this.columnIdMap.get(eventDetails[0]);
                if (propertyId == null) {
                    propertyId = ROW_HEADER_FAKE_PROPERTY_ID;
                }
                int width = Integer.valueOf(eventDetails[1]);
                this.setColumnWidth(propertyId, width);
            }
        }
    }

    protected boolean disableContentRefreshing() {
        boolean wasDisabled = this.isContentRefreshesEnabled;
        this.isContentRefreshesEnabled = false;
        return wasDisabled;
    }

    protected void enableContentRefreshing(boolean refreshContent) {
        this.isContentRefreshesEnabled = true;
        if (refreshContent) {
            this.refreshRenderedCells();
            this.markAsDirty();
        }
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        this.getVisibleCells();
    }

    @Override
    public void paintContent(PaintTarget target) throws PaintException {
        this.isBeingPainted = true;
        try {
            this.doPaintContent(target);
        }
        finally {
            this.isBeingPainted = false;
        }
    }

    private void doPaintContent(PaintTarget target) throws PaintException {
        Set<Action> actionSet = this.findAndPaintBodyActions(target);
        Object[][] cells = this.getVisibleCells();
        int rows = this.findNumRowsToPaint(target, cells);
        int total = this.size();
        if (this.shouldHideNullSelectionItem()) {
            --total;
            --rows;
        }
        this.paintTableAttributes(target, rows, total);
        this.paintVisibleColumnOrder(target);
        if (this.isPartialRowUpdate() && this.painted && !target.isFullRepaint()) {
            this.paintPartialRowUpdate(target, actionSet);
        } else if (target.isFullRepaint() || this.isRowCacheInvalidated()) {
            this.paintRows(target, cells, actionSet);
            this.setRowCacheInvalidated(false);
        }
        int pageBufferLastIndex = this.pageBufferFirstIndex + this.pageBuffer[3].length - 1;
        target.addAttribute("pb-ft", this.pageBufferFirstIndex);
        target.addAttribute("pb-l", pageBufferLastIndex);
        this.paintSorting(target);
        this.resetVariablesAndPageBuffer(target);
        this.paintActions(target, actionSet);
        this.paintColumnOrder(target);
        this.paintAvailableColumns(target);
        this.paintVisibleColumns(target);
        if (this.keyMapperReset) {
            this.keyMapperReset = false;
            target.addAttribute("clearKeyMap", true);
        }
        if (this.dropHandler != null) {
            this.dropHandler.getAcceptCriterion().paint(target);
        }
        this.painted = true;
    }

    private void setRowCacheInvalidated(boolean invalidated) {
        this.rowCacheInvalidated = invalidated;
    }

    protected boolean isRowCacheInvalidated() {
        return this.rowCacheInvalidated;
    }

    private void paintPartialRowUpdate(PaintTarget target, Set<Action> actionSet) throws PaintException {
        this.paintPartialRowUpdates(target, actionSet);
        this.paintPartialRowAdditions(target, actionSet);
    }

    private void paintPartialRowUpdates(PaintTarget target, Set<Action> actionSet) throws PaintException {
        boolean[] iscomponent = this.findCellsWithComponents();
        int firstIx = this.getFirstUpdatedItemIndex();
        int count = this.getUpdatedRowCount();
        target.startTag("urows");
        target.addAttribute("firsturowix", firstIx);
        target.addAttribute("numurows", count);
        Object[][] cells = this.getVisibleCellsUpdateCacheRows(firstIx, count);
        for (int indexInRowbuffer = 0; indexInRowbuffer < count; ++indexInRowbuffer) {
            Object itemId = cells[3][indexInRowbuffer];
            if (this.shouldHideNullSelectionItem()) continue;
            this.paintRow(target, cells, this.isEditable(), actionSet, iscomponent, indexInRowbuffer, itemId);
        }
        target.endTag("urows");
        this.maybeThrowCacheUpdateExceptions();
    }

    private void paintPartialRowAdditions(PaintTarget target, Set<Action> actionSet) throws PaintException {
        boolean[] iscomponent = this.findCellsWithComponents();
        int firstIx = this.getFirstAddedItemIndex();
        int count = this.getAddedRowCount();
        target.startTag("prows");
        if (!this.shouldHideAddedRows()) {
            this.getLogger().log(Level.FINEST, "Paint rows for add. Index: {0}, count: {1}.", new Object[]{firstIx, count});
            Object[][] cells = this.getVisibleCellsInsertIntoCache(firstIx, count);
            if (cells[0].length < count) {
                target.addAttribute("delbelow", true);
                count = cells[0].length;
            }
            for (int indexInRowbuffer = 0; indexInRowbuffer < count; ++indexInRowbuffer) {
                Object itemId = cells[3][indexInRowbuffer];
                if (this.shouldHideNullSelectionItem()) continue;
                this.paintRow(target, cells, this.isEditable(), actionSet, iscomponent, indexInRowbuffer, itemId);
            }
        } else {
            this.getLogger().log(Level.FINEST, "Paint rows for remove. Index: {0}, count: {1}.", new Object[]{firstIx, count});
            this.removeRowsFromCacheAndFillBottom(firstIx, count);
            target.addAttribute("hide", true);
        }
        target.addAttribute("firstprowix", firstIx);
        target.addAttribute("numprows", count);
        target.endTag("prows");
        this.maybeThrowCacheUpdateExceptions();
    }

    protected boolean isPartialRowUpdate() {
        return false;
    }

    protected int getFirstAddedItemIndex() {
        return 0;
    }

    protected int getAddedRowCount() {
        return 0;
    }

    protected boolean shouldHideAddedRows() {
        return false;
    }

    protected int getFirstUpdatedItemIndex() {
        return 0;
    }

    protected int getUpdatedRowCount() {
        return 0;
    }

    private void paintTableAttributes(PaintTarget target, int rows, int total) throws PaintException {
        this.paintTabIndex(target);
        this.paintDragMode(target);
        this.paintSelectMode(target);
        this.paintTableChildLayoutMeasureMode(target);
        if (this.cacheRate != 2.0) {
            target.addAttribute("cr", this.cacheRate);
        }
        target.addAttribute("cols", this.getVisibleColumns().length);
        target.addAttribute("rows", rows);
        target.addAttribute("firstrow", this.reqFirstRowToPaint >= 0 ? this.reqFirstRowToPaint : this.firstToBeRenderedInClient);
        target.addAttribute("totalrows", total);
        if (this.getPageLength() != 0) {
            target.addAttribute("pagelength", this.getPageLength());
        }
        if (this.areColumnHeadersEnabled()) {
            target.addAttribute("colheaders", true);
        }
        if (this.rowHeadersAreEnabled()) {
            target.addAttribute("rowheaders", true);
        }
        target.addAttribute("colfooters", this.columnFootersVisible);
        if (this.getCurrentPageFirstItemIndex() != 0 || this.getPageLength() > 0) {
            target.addVariable((VariableOwner)this, "firstvisible", this.getCurrentPageFirstItemIndex());
            target.addVariable((VariableOwner)this, "firstvisibleonlastpage", this.currentPageFirstItemIndexOnLastPage);
        }
    }

    private void resetVariablesAndPageBuffer(PaintTarget target) throws PaintException {
        this.reqFirstRowToPaint = -1;
        this.reqRowsToPaint = -1;
        this.containerChangeToBeRendered = false;
        target.addVariable((VariableOwner)this, "reqrows", this.reqRowsToPaint);
        target.addVariable((VariableOwner)this, "reqfirstrow", this.reqFirstRowToPaint);
    }

    private boolean areColumnHeadersEnabled() {
        return this.getColumnHeaderMode() != ColumnHeaderMode.HIDDEN;
    }

    private void paintVisibleColumns(PaintTarget target) throws PaintException {
        target.startTag("visiblecolumns");
        if (this.rowHeadersAreEnabled()) {
            target.startTag("column");
            target.addAttribute("cid", ROW_HEADER_COLUMN_KEY);
            this.paintColumnWidth(target, ROW_HEADER_FAKE_PROPERTY_ID);
            this.paintColumnExpandRatio(target, ROW_HEADER_FAKE_PROPERTY_ID);
            target.endTag("column");
        }
        Collection<?> sortables = this.getSortableContainerPropertyIds();
        for (Object e : this.visibleColumns) {
            if (e == null) continue;
            target.startTag("column");
            target.addAttribute("cid", this.columnIdMap.key(e));
            String head = this.getColumnHeader(e);
            target.addAttribute("caption", head != null ? head : "");
            String foot = this.getColumnFooter(e);
            target.addAttribute("fcaption", foot != null ? foot : "");
            if (this.isColumnCollapsed(e)) {
                target.addAttribute("collapsed", true);
            }
            if (this.areColumnHeadersEnabled()) {
                if (this.getColumnIcon(e) != null) {
                    target.addAttribute("icon", this.getColumnIcon(e));
                }
                if (sortables.contains(e)) {
                    target.addAttribute("sortable", true);
                }
            }
            if (!Align.LEFT.equals((Object)this.getColumnAlignment(e))) {
                target.addAttribute("align", this.getColumnAlignment(e).toString());
            }
            this.paintColumnWidth(target, e);
            this.paintColumnExpandRatio(target, e);
            target.endTag("column");
        }
        target.endTag("visiblecolumns");
    }

    private void paintAvailableColumns(PaintTarget target) throws PaintException {
        if (this.columnCollapsingAllowed) {
            HashSet collapsedCols = new HashSet();
            for (Object e : this.visibleColumns) {
                if (!this.isColumnCollapsed(e)) continue;
                collapsedCols.add(e);
            }
            String[] collapsedKeys = new String[collapsedCols.size()];
            boolean bl = false;
            for (Object e : this.visibleColumns) {
                if (!this.isColumnCollapsed(e)) continue;
                collapsedKeys[++var4_6] = this.columnIdMap.key(e);
            }
            target.addVariable((VariableOwner)this, "collapsedcolumns", collapsedKeys);
            String[] noncollapsibleKeys = new String[this.noncollapsibleColumns.size()];
            boolean bl2 = false;
            for (Object colId : this.noncollapsibleColumns) {
                noncollapsibleKeys[++var4_8] = this.columnIdMap.key(colId);
            }
            target.addVariable((VariableOwner)this, "noncollapsiblecolumns", noncollapsibleKeys);
        }
    }

    private void paintActions(PaintTarget target, Set<Action> actionSet) throws PaintException {
        if (!actionSet.isEmpty()) {
            target.addVariable((VariableOwner)this, "action", "");
            target.startTag("actions");
            for (Action a : actionSet) {
                target.startTag("action");
                if (a.getCaption() != null) {
                    target.addAttribute("caption", a.getCaption());
                }
                if (a.getIcon() != null) {
                    target.addAttribute("icon", a.getIcon());
                }
                target.addAttribute("key", this.actionMapper.key((Object)a));
                target.endTag("action");
            }
            target.endTag("actions");
        }
    }

    private void paintColumnOrder(PaintTarget target) throws PaintException {
        if (this.columnReorderingAllowed) {
            String[] colorder = new String[this.visibleColumns.size()];
            int i = 0;
            for (Object e : this.visibleColumns) {
                colorder[i++] = this.columnIdMap.key(e);
            }
            target.addVariable((VariableOwner)this, "columnorder", colorder);
        }
    }

    private void paintSorting(PaintTarget target) throws PaintException {
        if (this.getContainerDataSource() instanceof Container.Sortable) {
            target.addVariable((VariableOwner)this, "sortcolumn", this.columnIdMap.key(this.sortContainerPropertyId));
            target.addVariable((VariableOwner)this, "sortascending", this.sortAscending);
        }
    }

    private void paintRows(PaintTarget target, Object[][] cells, Set<Action> actionSet) throws PaintException {
        boolean[] iscomponent = this.findCellsWithComponents();
        target.startTag("rows");
        int start = 0;
        if (this.reqFirstRowToPaint != -1 && this.firstToBeRenderedInClient != -1) {
            start = this.reqFirstRowToPaint - this.firstToBeRenderedInClient;
        }
        int end = cells[0].length;
        if (this.reqRowsToPaint != -1) {
            end = start + this.reqRowsToPaint;
        }
        if (this.lastToBeRenderedInClient != -1 && this.lastToBeRenderedInClient < end) {
            end = this.lastToBeRenderedInClient + 1;
        }
        if (start > cells[3].length || start < 0) {
            start = 0;
        }
        if (end > cells[3].length) {
            end = cells[3].length;
        }
        for (int indexInRowbuffer = start; indexInRowbuffer < end; ++indexInRowbuffer) {
            Object itemId = cells[3][indexInRowbuffer];
            if (this.shouldHideNullSelectionItem()) continue;
            this.paintRow(target, cells, this.isEditable(), actionSet, iscomponent, indexInRowbuffer, itemId);
        }
        target.endTag("rows");
    }

    private boolean[] findCellsWithComponents() {
        boolean[] isComponent = new boolean[this.visibleColumns.size()];
        int ix = 0;
        for (Object e : this.visibleColumns) {
            if (this.columnGenerators.containsKey(e)) {
                isComponent[ix++] = true;
                continue;
            }
            Class<?> colType = this.getType(e);
            isComponent[ix++] = colType != null && Component.class.isAssignableFrom(colType);
        }
        return isComponent;
    }

    private void paintVisibleColumnOrder(PaintTarget target) {
        ArrayList<String> visibleColOrder = new ArrayList<String>();
        for (Object e : this.visibleColumns) {
            if (this.isColumnCollapsed(e)) continue;
            visibleColOrder.add(this.columnIdMap.key(e));
        }
        target.addAttribute("vcolorder", visibleColOrder.toArray());
    }

    private Set<Action> findAndPaintBodyActions(PaintTarget target) {
        LinkedHashSet<Action> actionSet = new LinkedHashSet<Action>();
        if (this.actionHandlers != null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (Action.Handler ah : this.actionHandlers) {
                Action[] actions = ah.getActions(null, (Object)this);
                if (actions == null) continue;
                for (Action action : actions) {
                    actionSet.add(action);
                    keys.add(this.actionMapper.key((Object)action));
                }
            }
            target.addAttribute("alb", keys.toArray());
        }
        return actionSet;
    }

    private boolean shouldHideNullSelectionItem() {
        return !this.isNullSelectionAllowed() && this.getNullSelectionItemId() != null && this.containsId(this.getNullSelectionItemId());
    }

    private int findNumRowsToPaint(PaintTarget target, Object[][] cells) throws PaintException {
        int rows;
        if (this.reqRowsToPaint >= 0) {
            rows = this.reqRowsToPaint;
        } else {
            rows = cells[0].length;
            if (this.alwaysRecalculateColumnWidths) {
                target.addAttribute("recalcWidths", true);
            }
        }
        return rows;
    }

    private void paintSelectMode(PaintTarget target) throws PaintException {
        if (this.multiSelectMode != MultiSelectMode.DEFAULT) {
            target.addAttribute("multiselectmode", this.multiSelectMode.ordinal());
        }
        if (this.isSelectable()) {
            target.addAttribute("selectmode", this.isMultiSelect() ? "multi" : "single");
            if (this.isMultiSelect()) {
                target.addAttribute("touchdetection", this.isMultiSelectTouchDetectionEnabled());
            }
        } else {
            target.addAttribute("selectmode", "none");
        }
        if (!this.isNullSelectionAllowed()) {
            target.addAttribute("nsa", false);
        }
        if (this.isSelectable()) {
            target.addVariable((VariableOwner)this, "selected", this.findSelectedKeys());
        }
    }

    private String[] findSelectedKeys() {
        LinkedList<String> selectedKeys = new LinkedList<String>();
        if (this.isMultiSelect()) {
            HashSet sel = new HashSet((Set)this.getValue());
            Collection<?> vids = this.getVisibleItemIds();
            for (Object id : vids) {
                if (!sel.contains(id)) continue;
                selectedKeys.add(this.itemIdMapper.key(id));
            }
        } else {
            Object value = this.getValue();
            if (value == null) {
                value = this.getNullSelectionItemId();
            }
            if (value != null) {
                selectedKeys.add(this.itemIdMapper.key(value));
            }
        }
        return selectedKeys.toArray(new String[selectedKeys.size()]);
    }

    private void paintDragMode(PaintTarget target) throws PaintException {
        if (this.dragMode != TableDragMode.NONE) {
            target.addAttribute("dragmode", this.dragMode.ordinal());
        }
    }

    private void paintTabIndex(PaintTarget target) throws PaintException {
        if (this.getTabIndex() > 0) {
            target.addAttribute("tabindex", this.getTabIndex());
        }
    }

    private void paintColumnWidth(PaintTarget target, Object columnId) throws PaintException {
        if (this.columnWidths.containsKey(columnId)) {
            target.addAttribute("width", this.getColumnWidth(columnId));
        }
    }

    private void paintColumnExpandRatio(PaintTarget target, Object columnId) throws PaintException {
        if (this.columnExpandRatios.containsKey(columnId)) {
            target.addAttribute("er", this.getColumnExpandRatio(columnId));
        }
    }

    private void paintTableChildLayoutMeasureMode(PaintTarget target) throws PaintException {
        target.addAttribute("measurehint", this.getChildMeasurementHint().ordinal());
    }

    protected boolean rowHeadersAreEnabled() {
        return this.getRowHeaderMode() != RowHeaderMode.HIDDEN;
    }

    private void paintRow(PaintTarget target, Object[][] cells, boolean iseditable, Set<Action> actionSet, boolean[] iscomponent, int indexInRowbuffer, Object itemId) throws PaintException {
        target.startTag("tr");
        this.paintRowAttributes(target, cells, actionSet, indexInRowbuffer, itemId);
        int currentColumn = 0;
        for (Object e : this.visibleColumns) {
            if (e != null && !this.isColumnCollapsed(e)) {
                String cellStyle;
                if (this.cellStyleGenerator != null && (cellStyle = this.cellStyleGenerator.getStyle(this, itemId, e)) != null && !cellStyle.equals("")) {
                    target.addAttribute("style-" + this.columnIdMap.key(e), cellStyle);
                }
                if ((iscomponent[currentColumn] || iseditable || cells[4][indexInRowbuffer] != null) && Component.class.isInstance(cells[5 + currentColumn][indexInRowbuffer])) {
                    Component c = (Component)cells[5 + currentColumn][indexInRowbuffer];
                    if (c == null || !LegacyCommunicationManager.isComponentVisibleToClient((Component)c)) {
                        target.addText("");
                    } else {
                        LegacyPaint.paint((Component)c, (PaintTarget)target);
                    }
                } else {
                    target.addText((String)cells[5 + currentColumn][indexInRowbuffer]);
                }
                this.paintCellTooltips(target, itemId, e);
            }
            ++currentColumn;
        }
        target.endTag("tr");
    }

    private void paintCellTooltips(PaintTarget target, Object itemId, Object columnId) throws PaintException {
        String itemDescription;
        if (this.itemDescriptionGenerator != null && (itemDescription = this.itemDescriptionGenerator.generateDescription((Component)this, itemId, columnId)) != null && !itemDescription.equals("")) {
            target.addAttribute("descr-" + this.columnIdMap.key(columnId), itemDescription);
        }
    }

    private void paintRowTooltips(PaintTarget target, Object itemId) throws PaintException {
        String rowDescription;
        if (this.itemDescriptionGenerator != null && (rowDescription = this.itemDescriptionGenerator.generateDescription((Component)this, itemId, null)) != null && !rowDescription.equals("")) {
            target.addAttribute("rowdescr", rowDescription);
        }
    }

    private void paintRowAttributes(PaintTarget target, Object[][] cells, Set<Action> actionSet, int indexInRowbuffer, Object itemId) throws PaintException {
        String rowStyle;
        this.paintRowIcon(target, cells, indexInRowbuffer);
        this.paintRowHeader(target, cells, indexInRowbuffer);
        this.paintGeneratedRowInfo(target, cells, indexInRowbuffer);
        target.addAttribute("key", Integer.parseInt(cells[0][indexInRowbuffer].toString()));
        if (this.isSelected(itemId)) {
            target.addAttribute("selected", true);
        }
        if (this.actionHandlers != null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (Action.Handler ah : this.actionHandlers) {
                Action[] aa = ah.getActions(itemId, (Object)this);
                if (aa == null) continue;
                for (int ai = 0; ai < aa.length; ++ai) {
                    String key = this.actionMapper.key((Object)aa[ai]);
                    actionSet.add(aa[ai]);
                    keys.add(key);
                }
            }
            target.addAttribute("al", keys.toArray());
        }
        if (this.cellStyleGenerator != null && (rowStyle = this.cellStyleGenerator.getStyle(this, itemId, null)) != null && !rowStyle.equals("")) {
            target.addAttribute("rowstyle", rowStyle);
        }
        this.paintRowTooltips(target, itemId);
        this.paintRowAttributes(target, itemId);
    }

    private void paintGeneratedRowInfo(PaintTarget target, Object[][] cells, int indexInRowBuffer) throws PaintException {
        GeneratedRow generatedRow = (GeneratedRow)cells[4][indexInRowBuffer];
        if (generatedRow != null) {
            target.addAttribute("gen_html", generatedRow.isHtmlContentAllowed());
            target.addAttribute("gen_span", generatedRow.isSpanColumns());
            target.addAttribute("gen_widget", cells[5][indexInRowBuffer] instanceof Component);
        }
    }

    protected void paintRowHeader(PaintTarget target, Object[][] cells, int indexInRowbuffer) throws PaintException {
        if (this.rowHeadersAreEnabled() && cells[1][indexInRowbuffer] != null) {
            target.addAttribute("caption", (String)cells[1][indexInRowbuffer]);
        }
    }

    protected void paintRowIcon(PaintTarget target, Object[][] cells, int indexInRowbuffer) throws PaintException {
        if (this.rowHeadersAreEnabled() && cells[2][indexInRowbuffer] != null) {
            target.addAttribute("icon", (Resource)cells[2][indexInRowbuffer]);
        }
    }

    protected void paintRowAttributes(PaintTarget target, Object itemId) throws PaintException {
    }

    private Object[][] getVisibleCells() {
        if (this.pageBuffer == null) {
            this.refreshRenderedCells();
        }
        return this.pageBuffer;
    }

    protected Object getPropertyValue(Object rowId, Object colId, Property property) {
        Field<?> f;
        if (this.isEditable() && this.fieldFactory != null && (f = this.fieldFactory.createField(this.getContainerDataSource(), rowId, colId, (Component)this)) != null) {
            this.associatedProperties.put(f, property);
            this.bindPropertyToField(rowId, colId, property, f);
            return f;
        }
        return this.formatPropertyValue(rowId, colId, property);
    }

    protected void bindPropertyToField(Object rowId, Object colId, Property property, Field field) {
        boolean hasFilterProperty;
        boolean bl = hasFilterProperty = field.getPropertyDataSource() != null && field.getPropertyDataSource() instanceof Property.Viewer;
        if (hasFilterProperty) {
            ((Property.Viewer)((Object)field.getPropertyDataSource())).setPropertyDataSource(property);
        } else {
            field.setPropertyDataSource(property);
        }
    }

    protected String formatPropertyValue(Object rowId, Object colId, Property<?> property) {
        if (property == null) {
            return "";
        }
        Converter<String, Object> converter = null;
        converter = this.hasConverter(colId) ? this.getConverter(colId) : ConverterUtil.getConverter(String.class, property.getType(), this.getSession());
        Object value = property.getValue();
        if (converter != null) {
            return converter.convertToPresentation(value, String.class, this.getLocale());
        }
        return null != value ? value.toString() : "";
    }

    public void addActionHandler(Action.Handler actionHandler) {
        if (actionHandler != null) {
            if (this.actionHandlers == null) {
                this.actionHandlers = new LinkedList();
                this.actionMapper = new KeyMapper();
            }
            if (!this.actionHandlers.contains(actionHandler)) {
                this.actionHandlers.add(actionHandler);
                this.refreshRenderedCells();
            }
        }
    }

    public void removeActionHandler(Action.Handler actionHandler) {
        if (this.actionHandlers != null && this.actionHandlers.contains(actionHandler)) {
            this.actionHandlers.remove(actionHandler);
            if (this.actionHandlers.isEmpty()) {
                this.actionHandlers = null;
                this.actionMapper = null;
            }
            this.refreshRenderedCells();
        }
    }

    public void removeAllActionHandlers() {
        this.actionHandlers = null;
        this.actionMapper = null;
        this.refreshRenderedCells();
    }

    @Override
    public void valueChange(Property.ValueChangeEvent event) {
        if (this.equals(event.getProperty()) || event.getProperty() == this.getPropertyDataSource()) {
            super.valueChange(event);
        } else {
            this.refreshRowCache();
            this.containerChangeToBeRendered = true;
        }
        this.markAsDirty();
    }

    protected void resetPageBuffer() {
        this.firstToBeRenderedInClient = -1;
        this.lastToBeRenderedInClient = -1;
        this.reqFirstRowToPaint = -1;
        this.reqRowsToPaint = -1;
        this.pageBuffer = null;
    }

    @Override
    public void attach() {
        super.attach();
        this.refreshRenderedCells();
    }

    @Override
    public void detach() {
        super.detach();
    }

    @Override
    public boolean removeAllItems() {
        this.currentPageFirstItemId = null;
        this.currentPageFirstItemIndex = 0;
        return super.removeAllItems();
    }

    @Override
    public boolean removeItem(Object itemId) {
        Object nextItemId = this.nextItemId(itemId);
        boolean ret = super.removeItem(itemId);
        if (ret && itemId != null && itemId.equals(this.currentPageFirstItemId)) {
            this.currentPageFirstItemId = nextItemId;
        }
        if (!(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.refreshRowCache();
        }
        return ret;
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        this.visibleColumns.remove(propertyId);
        this.columnAlignments.remove(propertyId);
        this.columnIcons.remove(propertyId);
        this.columnHeaders.remove(propertyId);
        this.columnFooters.remove(propertyId);
        this.propertyValueConverters.remove(propertyId);
        return super.removeContainerProperty(propertyId);
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        boolean visibleColAdded = false;
        if (!this.visibleColumns.contains(propertyId)) {
            this.visibleColumns.add(propertyId);
            visibleColAdded = true;
        }
        if (!super.addContainerProperty(propertyId, type, defaultValue)) {
            if (visibleColAdded) {
                this.visibleColumns.remove(propertyId);
            }
            return false;
        }
        if (!(this.items instanceof Container.PropertySetChangeNotifier)) {
            this.refreshRowCache();
        }
        return true;
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue, String columnHeader, Resource columnIcon, Align columnAlignment) throws UnsupportedOperationException {
        if (!this.addContainerProperty(propertyId, type, defaultValue)) {
            return false;
        }
        this.setColumnAlignment(propertyId, columnAlignment);
        this.setColumnHeader(propertyId, columnHeader);
        this.setColumnIcon(propertyId, columnIcon);
        return true;
    }

    public void addGeneratedColumn(Object id, ColumnGenerator generatedColumn) {
        if (generatedColumn == null) {
            throw new IllegalArgumentException("Can not add null as a GeneratedColumn");
        }
        if (this.columnGenerators.containsKey(id)) {
            throw new IllegalArgumentException("Can not add the same GeneratedColumn twice, id:" + id);
        }
        this.columnGenerators.put(id, generatedColumn);
        if (!this.visibleColumns.contains(id)) {
            this.visibleColumns.add(id);
        }
        this.refreshRowCache();
    }

    public ColumnGenerator getColumnGenerator(Object columnId) throws IllegalArgumentException {
        return this.columnGenerators.get(columnId);
    }

    public boolean removeGeneratedColumn(Object columnId) {
        if (this.columnGenerators.containsKey(columnId)) {
            this.columnGenerators.remove(columnId);
            if (!this.items.getContainerPropertyIds().contains(columnId)) {
                this.visibleColumns.remove(columnId);
            }
            this.refreshRowCache();
            return true;
        }
        return false;
    }

    @Override
    public Collection<?> getVisibleItemIds() {
        LinkedList<Object> visible = new LinkedList<Object>();
        Object[][] cells = this.getVisibleCells();
        if (null != cells) {
            for (Object id : cells[3]) {
                visible.add(id);
            }
        }
        return visible;
    }

    @Override
    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        if (this.isBeingPainted) {
            return;
        }
        super.containerItemSetChange(event);
        this.keyMapperReset = true;
        int currentFirstItemIndex = this.getCurrentPageFirstItemIndex();
        if (event.getContainer().size() == 0) {
            this.repairOnReAddAllRowsDataScrollPositionItemIndex = this.getCurrentPageFirstItemIndex();
        } else if (this.repairOnReAddAllRowsDataScrollPositionItemIndex != -1) {
            currentFirstItemIndex = this.repairOnReAddAllRowsDataScrollPositionItemIndex;
            this.repairOnReAddAllRowsDataScrollPositionItemIndex = -1;
        }
        this.setCurrentPageFirstItemIndex(currentFirstItemIndex, false);
        this.refreshRowCache();
    }

    @Override
    public void containerPropertySetChange(Container.PropertySetChangeEvent event) {
        Object id;
        if (this.isBeingPainted) {
            return;
        }
        this.disableContentRefreshing();
        super.containerPropertySetChange(event);
        Collection<?> containerPropertyIds = this.getContainerDataSource().getContainerPropertyIds();
        LinkedList<Object> newVisibleColumns = new LinkedList<Object>(this.visibleColumns);
        Iterator<Object> iterator = newVisibleColumns.iterator();
        while (iterator.hasNext()) {
            id = iterator.next();
            if (containerPropertyIds.contains(id) || this.columnGenerators.containsKey(id)) continue;
            iterator.remove();
        }
        this.setVisibleColumns(newVisibleColumns.toArray());
        iterator = this.collapsedColumns.iterator();
        while (iterator.hasNext()) {
            id = iterator.next();
            if (containerPropertyIds.contains(id) || this.columnGenerators.containsKey(id)) continue;
            iterator.remove();
        }
        this.resetPageBuffer();
        this.enableContentRefreshing(true);
    }

    @Override
    public void setNewItemsAllowed(boolean allowNewOptions) throws UnsupportedOperationException {
        if (allowNewOptions) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Object nextItemId(Object itemId) {
        return ((Container.Ordered)this.items).nextItemId(itemId);
    }

    @Override
    public Object prevItemId(Object itemId) {
        return ((Container.Ordered)this.items).prevItemId(itemId);
    }

    @Override
    public Object firstItemId() {
        return ((Container.Ordered)this.items).firstItemId();
    }

    @Override
    public Object lastItemId() {
        return ((Container.Ordered)this.items).lastItemId();
    }

    @Override
    public boolean isFirstId(Object itemId) {
        return ((Container.Ordered)this.items).isFirstId(itemId);
    }

    @Override
    public boolean isLastId(Object itemId) {
        return ((Container.Ordered)this.items).isLastId(itemId);
    }

    @Override
    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        Object itemId = ((Container.Ordered)this.items).addItemAfter(previousItemId);
        if (!(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.refreshRowCache();
        }
        return itemId;
    }

    @Override
    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        Item item = ((Container.Ordered)this.items).addItemAfter(previousItemId, newItemId);
        if (!(this.items instanceof Container.ItemSetChangeNotifier)) {
            this.refreshRowCache();
        }
        return item;
    }

    public void setTableFieldFactory(TableFieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
        this.refreshRowCache();
    }

    public TableFieldFactory getTableFieldFactory() {
        return this.fieldFactory;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.refreshRowCache();
    }

    @Override
    public void sort(Object[] propertyId, boolean[] ascending) throws UnsupportedOperationException {
        Container c = this.getContainerDataSource();
        if (c instanceof Container.Sortable) {
            int pageIndex = this.getCurrentPageFirstItemIndex();
            boolean refreshingPreviouslyEnabled = this.disableContentRefreshing();
            ((Container.Sortable)c).sort(propertyId, ascending);
            this.setCurrentPageFirstItemIndex(pageIndex);
            if (refreshingPreviouslyEnabled) {
                this.enableContentRefreshing(true);
            }
            if (propertyId.length > 0 && ascending.length > 0) {
                this.sortAscending = ascending[0];
                this.sortContainerPropertyId = propertyId[0];
            } else {
                this.sortAscending = true;
                this.sortContainerPropertyId = null;
            }
        } else if (c != null) {
            throw new UnsupportedOperationException("Underlying Data does not allow sorting");
        }
    }

    public void sort() {
        if (this.getSortContainerPropertyId() == null) {
            return;
        }
        this.sort(new Object[]{this.sortContainerPropertyId}, new boolean[]{this.sortAscending});
    }

    @Override
    public Collection<?> getSortableContainerPropertyIds() {
        Container c = this.getContainerDataSource();
        if (c instanceof Container.Sortable && this.isSortEnabled()) {
            return ((Container.Sortable)c).getSortableContainerPropertyIds();
        }
        return Collections.EMPTY_LIST;
    }

    public Object getSortContainerPropertyId() {
        return this.sortContainerPropertyId;
    }

    public void setSortContainerPropertyId(Object propertyId) {
        this.setSortContainerPropertyId(propertyId, true);
    }

    private void setSortContainerPropertyId(Object propertyId, boolean doSort) {
        if (this.sortContainerPropertyId != null && !this.sortContainerPropertyId.equals(propertyId) || this.sortContainerPropertyId == null && propertyId != null) {
            this.sortContainerPropertyId = propertyId;
            if (doSort) {
                this.sort();
                this.refreshRenderedCells();
            }
        }
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean ascending) {
        this.setSortAscending(ascending, true);
    }

    private void setSortAscending(boolean ascending, boolean doSort) {
        if (this.sortAscending != ascending) {
            this.sortAscending = ascending;
            if (doSort) {
                this.sort();
                this.refreshRenderedCells();
            }
        }
    }

    @Deprecated
    public boolean isSortDisabled() {
        return !this.isSortEnabled();
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    @Deprecated
    public void setSortDisabled(boolean sortDisabled) {
        this.setSortEnabled(!sortDisabled);
    }

    public void setSortEnabled(boolean sortEnabled) {
        if (this.sortEnabled != sortEnabled) {
            this.sortEnabled = sortEnabled;
            this.markAsDirty();
        }
    }

    public void setCellStyleGenerator(CellStyleGenerator cellStyleGenerator) {
        this.cellStyleGenerator = cellStyleGenerator;
        this.refreshRenderedCells();
    }

    public CellStyleGenerator getCellStyleGenerator() {
        return this.cellStyleGenerator;
    }

    @Override
    public void addItemClickListener(ItemClickEvent.ItemClickListener listener) {
        this.addListener("itemClick", ItemClickEvent.class, listener, ItemClickEvent.ITEM_CLICK_METHOD);
    }

    @Override
    @Deprecated
    public void addListener(ItemClickEvent.ItemClickListener listener) {
        this.addItemClickListener(listener);
    }

    @Override
    public void removeItemClickListener(ItemClickEvent.ItemClickListener listener) {
        this.removeListener("itemClick", ItemClickEvent.class, listener);
    }

    @Override
    @Deprecated
    public void removeListener(ItemClickEvent.ItemClickListener listener) {
        this.removeItemClickListener(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getParent() != null && !this.getParent().isEnabled()) {
            return;
        }
        this.markAsDirtyRecursive();
    }

    public void setDragMode(TableDragMode newDragMode) {
        this.dragMode = newDragMode;
        this.markAsDirty();
    }

    public TableDragMode getDragMode() {
        return this.dragMode;
    }

    public TableTransferable getTransferable(Map<String, Object> rawVariables) {
        TableTransferable transferable = new TableTransferable(rawVariables);
        return transferable;
    }

    public DropHandler getDropHandler() {
        return this.dropHandler;
    }

    public void setDropHandler(DropHandler dropHandler) {
        this.dropHandler = dropHandler;
    }

    public AbstractSelect.AbstractSelectTargetDetails translateDropTargetDetails(Map<String, Object> clientVariables) {
        return new AbstractSelect.AbstractSelectTargetDetails(clientVariables);
    }

    public void setMultiSelectMode(MultiSelectMode mode) {
        this.multiSelectMode = mode;
        this.markAsDirty();
    }

    public MultiSelectMode getMultiSelectMode() {
        return this.multiSelectMode;
    }

    public void setMultiSelectTouchDetectionEnabled(boolean multiSelectTouchDetectionEnabled) {
        this.multiSelectTouchDetectionEnabled = multiSelectTouchDetectionEnabled;
        this.markAsDirty();
    }

    public boolean isMultiSelectTouchDetectionEnabled() {
        return this.multiSelectTouchDetectionEnabled;
    }

    public void addHeaderClickListener(HeaderClickListener listener) {
        this.addListener("handleHeaderClick", HeaderClickEvent.class, listener, HeaderClickEvent.HEADER_CLICK_METHOD);
    }

    @Deprecated
    public void addListener(HeaderClickListener listener) {
        this.addHeaderClickListener(listener);
    }

    public void removeHeaderClickListener(HeaderClickListener listener) {
        this.removeListener("handleHeaderClick", HeaderClickEvent.class, listener);
    }

    @Deprecated
    public void removeListener(HeaderClickListener listener) {
        this.removeHeaderClickListener(listener);
    }

    public void addFooterClickListener(FooterClickListener listener) {
        this.addListener("handleFooterClick", FooterClickEvent.class, listener, FooterClickEvent.FOOTER_CLICK_METHOD);
    }

    @Deprecated
    public void addListener(FooterClickListener listener) {
        this.addFooterClickListener(listener);
    }

    public void removeFooterClickListener(FooterClickListener listener) {
        this.removeListener("handleFooterClick", FooterClickEvent.class, listener);
    }

    @Deprecated
    public void removeListener(FooterClickListener listener) {
        this.removeFooterClickListener(listener);
    }

    public String getColumnFooter(Object propertyId) {
        return this.columnFooters.get(propertyId);
    }

    public void setColumnFooter(Object propertyId, String footer) {
        if (footer == null) {
            this.columnFooters.remove(propertyId);
        } else {
            this.columnFooters.put(propertyId, footer);
        }
        this.markAsDirty();
    }

    public void setFooterVisible(boolean visible) {
        if (visible != this.columnFootersVisible) {
            this.columnFootersVisible = visible;
            this.markAsDirty();
        }
    }

    public boolean isFooterVisible() {
        return this.columnFootersVisible;
    }

    public void addColumnResizeListener(ColumnResizeListener listener) {
        this.addListener("columnResize", ColumnResizeEvent.class, listener, ColumnResizeEvent.COLUMN_RESIZE_METHOD);
    }

    @Deprecated
    public void addListener(ColumnResizeListener listener) {
        this.addColumnResizeListener(listener);
    }

    public void removeColumnResizeListener(ColumnResizeListener listener) {
        this.removeListener("columnResize", ColumnResizeEvent.class, listener);
    }

    @Deprecated
    public void removeListener(ColumnResizeListener listener) {
        this.removeColumnResizeListener(listener);
    }

    public void addColumnReorderListener(ColumnReorderListener listener) {
        this.addListener("columnReorder", ColumnReorderEvent.class, listener, ColumnReorderEvent.METHOD);
    }

    @Deprecated
    public void addListener(ColumnReorderListener listener) {
        this.addColumnReorderListener(listener);
    }

    public void removeColumnReorderListener(ColumnReorderListener listener) {
        this.removeListener("columnReorder", ColumnReorderEvent.class, listener);
    }

    @Deprecated
    public void removeListener(ColumnReorderListener listener) {
        this.removeColumnReorderListener(listener);
    }

    public void addColumnCollapseListener(ColumnCollapseListener listener) {
        this.addListener("columnCollapse", ColumnCollapseEvent.class, listener, ColumnCollapseEvent.METHOD);
    }

    public void removeColumnCollapseListener(ColumnCollapseListener listener) {
        this.removeListener("columnCollapse", ColumnCollapseEvent.class, listener);
    }

    public void setItemDescriptionGenerator(AbstractSelect.ItemDescriptionGenerator generator) {
        if (generator != this.itemDescriptionGenerator) {
            this.itemDescriptionGenerator = generator;
            this.refreshRenderedCells();
        }
    }

    public AbstractSelect.ItemDescriptionGenerator getItemDescriptionGenerator() {
        return this.itemDescriptionGenerator;
    }

    public void setRowGenerator(RowGenerator generator) {
        this.rowGenerator = generator;
        this.refreshRowCache();
    }

    public RowGenerator getRowGenerator() {
        return this.rowGenerator;
    }

    public void setConverter(Object propertyId, Converter<String, ?> converter) {
        if (!this.getContainerPropertyIds().contains(propertyId)) {
            throw new IllegalArgumentException("PropertyId " + propertyId + " must be in the container");
        }
        if (!this.typeIsCompatible(converter.getModelType(), this.getType(propertyId))) {
            throw new IllegalArgumentException("Property type (" + this.getType(propertyId) + ") must match converter source type (" + converter.getModelType() + ")");
        }
        this.propertyValueConverters.put(propertyId, converter);
        this.refreshRowCache();
    }

    protected boolean hasConverter(Object propertyId) {
        return this.propertyValueConverters.containsKey(propertyId);
    }

    public Converter<String, Object> getConverter(Object propertyId) {
        return this.propertyValueConverters.get(propertyId);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setRowCacheInvalidated(true);
        }
        super.setVisible(visible);
    }

    public Iterator<Component> iterator() {
        if (this.visibleComponents == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return this.visibleComponents.iterator();
    }

    @Deprecated
    public Iterator<Component> getComponentIterator() {
        return this.iterator();
    }

    @Override
    public void readDesign(Element design, DesignContext context) {
        super.readDesign(design, context);
        if (design.hasAttr("sortable")) {
            this.setSortEnabled((Boolean)DesignAttributeHandler.readAttribute((String)"sortable", (Attributes)design.attributes(), Boolean.TYPE));
        }
        this.readColumns(design);
        this.readHeader(design);
        this.readBody(design, context);
        this.readFooter(design);
    }

    private void readColumns(Element design) {
        Element colgroup = design.select("> table > colgroup").first();
        if (colgroup != null) {
            int i = 0;
            ArrayList<String> pIds = new ArrayList<String>();
            for (Element col : colgroup.children()) {
                if (!col.tagName().equals("col")) {
                    throw new DesignException("invalid column");
                }
                String id = (String)DesignAttributeHandler.readAttribute((String)"property-id", (Attributes)col.attributes(), (Object)("property-" + i++), String.class);
                pIds.add(id);
                this.addContainerProperty(id, String.class, null);
                if (col.hasAttr("width")) {
                    this.setColumnWidth(id, (Integer)DesignAttributeHandler.readAttribute((String)"width", (Attributes)col.attributes(), Integer.class));
                }
                if (col.hasAttr("center")) {
                    this.setColumnAlignment(id, Align.CENTER);
                } else if (col.hasAttr("right")) {
                    this.setColumnAlignment(id, Align.RIGHT);
                }
                if (col.hasAttr("expand")) {
                    if (col.attr("expand").isEmpty()) {
                        this.setColumnExpandRatio(id, 1.0f);
                    } else {
                        this.setColumnExpandRatio(id, ((Float)DesignAttributeHandler.readAttribute((String)"expand", (Attributes)col.attributes(), Float.TYPE)).floatValue());
                    }
                }
                if (col.hasAttr("collapsible")) {
                    this.setColumnCollapsible(id, (Boolean)DesignAttributeHandler.readAttribute((String)"collapsible", (Attributes)col.attributes(), Boolean.TYPE));
                }
                if (!col.hasAttr("collapsed")) continue;
                this.setColumnCollapsed(id, (Boolean)DesignAttributeHandler.readAttribute((String)"collapsed", (Attributes)col.attributes(), Boolean.TYPE));
            }
            this.setVisibleColumns(pIds.toArray());
        }
    }

    private void readFooter(Element design) {
        this.readHeaderOrFooter(design, false);
    }

    private void readHeader(Element design) {
        this.readHeaderOrFooter(design, true);
    }

    @Override
    protected void readItems(Element design, DesignContext context) {
    }

    private void readHeaderOrFooter(Element design, boolean header) {
        String selector = header ? "> table > thead" : "> table > tfoot";
        Element elem = design.select(selector).first();
        if (elem != null) {
            if (!header) {
                this.setFooterVisible(true);
            }
            if (elem.children().size() != 1) {
                throw new DesignException("Table header and footer should contain exactly one <tr> element");
            }
            Element tr = elem.child(0);
            Elements elems = tr.children();
            LinkedList<Object> propertyIds = this.visibleColumns;
            if (elems.size() != propertyIds.size()) {
                throw new DesignException("Table header and footer should contain as many items as there are columns in the Table.");
            }
            Iterator propertyIt = propertyIds.iterator();
            for (Element e : elems) {
                String columnValue = DesignFormatter.decodeFromTextNode((String)e.html());
                Object propertyId = propertyIt.next();
                if (header) {
                    this.setColumnHeader(propertyId, columnValue);
                    if (!e.hasAttr("icon")) continue;
                    this.setColumnIcon(propertyId, (Resource)DesignAttributeHandler.readAttribute((String)"icon", (Attributes)e.attributes(), Resource.class));
                    continue;
                }
                this.setColumnFooter(propertyId, columnValue);
            }
        }
    }

    protected void readBody(Element design, DesignContext context) {
        Element tbody = design.select("> table > tbody").first();
        if (tbody == null) {
            return;
        }
        HashSet<String> selected = new HashSet<String>();
        for (Element tr : tbody.children()) {
            this.readItem(tr, selected, context);
        }
    }

    @Override
    protected Object readItem(Element tr, Set<String> selected, DesignContext context) {
        Elements cells = tr.children();
        if (this.visibleColumns.size() != cells.size()) {
            throw new DesignException("Wrong number of columns in a Table row. Expected " + this.visibleColumns.size() + ", was " + cells.size() + ".");
        }
        Object[] data = new String[cells.size()];
        for (int c = 0; c < cells.size(); ++c) {
            data[c] = DesignFormatter.decodeFromTextNode((String)((Element)cells.get(c)).html());
        }
        Object itemId = this.addItem(data, tr.hasAttr("item-id") ? tr.attr("item-id") : null);
        if (itemId == null) {
            throw new DesignException("Failed to add a Table row: " + data);
        }
        return itemId;
    }

    @Override
    public void writeDesign(Element design, DesignContext context) {
        boolean hasColumns;
        Table def = (Table)context.getDefaultInstance((Component)this);
        DesignAttributeHandler.writeAttribute((String)"sortable", (Attributes)design.attributes(), (Object)this.isSortEnabled(), (Object)def.isSortEnabled(), Boolean.TYPE, (DesignContext)context);
        Element table = null;
        boolean bl = hasColumns = this.getVisibleColumns().length != 0;
        if (hasColumns) {
            table = design.appendElement("table");
            this.writeColumns(table, def, context);
            this.writeHeader(table, def, context);
        }
        super.writeDesign(design, context);
        if (hasColumns) {
            this.writeFooter(table);
        }
    }

    private void writeColumns(Element table, Table def, DesignContext context) {
        Object[] columns = this.getVisibleColumns();
        if (columns.length == 0) {
            return;
        }
        Element colgroup = table.appendElement("colgroup");
        for (Object id : columns) {
            Element col = colgroup.appendElement("col");
            col.attr("property-id", id.toString());
            if (this.getColumnAlignment(id) == Align.CENTER) {
                col.attr("center", true);
            } else if (this.getColumnAlignment(id) == Align.RIGHT) {
                col.attr("right", true);
            }
            DesignAttributeHandler.writeAttribute((String)"width", (Attributes)col.attributes(), (Object)this.getColumnWidth(id), (Object)def.getColumnWidth(null), Integer.TYPE, (DesignContext)context);
            DesignAttributeHandler.writeAttribute((String)"expand", (Attributes)col.attributes(), (Object)Float.valueOf(this.getColumnExpandRatio(id)), (Object)Float.valueOf(def.getColumnExpandRatio(null)), Float.TYPE, (DesignContext)context);
            DesignAttributeHandler.writeAttribute((String)"collapsible", (Attributes)col.attributes(), (Object)this.isColumnCollapsible(id), (Object)def.isColumnCollapsible(null), Boolean.TYPE, (DesignContext)context);
            DesignAttributeHandler.writeAttribute((String)"collapsed", (Attributes)col.attributes(), (Object)this.isColumnCollapsed(id), (Object)def.isColumnCollapsed(null), Boolean.TYPE, (DesignContext)context);
        }
    }

    private void writeHeader(Element table, Table def, DesignContext context) {
        Object[] columns = this.getVisibleColumns();
        if (columns.length == 0 || this.columnIcons.isEmpty() && this.columnHeaders.isEmpty()) {
            return;
        }
        Element header = table.appendElement("thead").appendElement("tr");
        for (Object id : columns) {
            Element th = header.appendElement("th");
            th.html(this.getColumnHeader(id));
            DesignAttributeHandler.writeAttribute((String)"icon", (Attributes)th.attributes(), (Object)this.getColumnIcon(id), (Object)def.getColumnIcon(null), Resource.class, (DesignContext)context);
        }
    }

    private void writeFooter(Element table) {
        Object[] columns = this.getVisibleColumns();
        if (columns.length == 0 || this.columnFooters.isEmpty()) {
            return;
        }
        Element footer = table.appendElement("tfoot").appendElement("tr");
        for (Object id : columns) {
            footer.appendElement("td").text(this.getColumnFooter(id));
        }
    }

    @Override
    protected void writeItems(Element design, DesignContext context) {
        if (this.getVisibleColumns().length == 0) {
            return;
        }
        Element tbody = design.child(0).appendElement("tbody");
        super.writeItems(tbody, context);
    }

    @Override
    protected Element writeItem(Element tbody, Object itemId, DesignContext context) {
        Element tr = tbody.appendElement("tr");
        tr.attr("item-id", String.valueOf(itemId));
        Item item = this.getItem(itemId);
        for (Object id : this.getVisibleColumns()) {
            Element td = tr.appendElement("td");
            Object value = item.getItemProperty(id).getValue();
            td.html(value != null ? value.toString() : "");
        }
        return tr;
    }

    @Override
    protected Collection<String> getCustomAttributes() {
        Collection<String> result = super.getCustomAttributes();
        result.add("sortable");
        result.add("sort-enabled");
        result.add("sort-disabled");
        result.add("footer-visible");
        result.add("item-caption-mode");
        result.add("current-page-first-item-id");
        result.add("current-page-first-item-index");
        return result;
    }

    protected TableState getState() {
        return this.getState(true);
    }

    protected TableState getState(boolean markAsDirty) {
        return (TableState)super.getState(markAsDirty);
    }

    private final Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(Table.class.getName());
        }
        return this.logger;
    }

    public void setChildMeasurementHint(HasChildMeasurementHint.ChildMeasurementHint hint) {
        this.childMeasurementHint = hint == null ? HasChildMeasurementHint.ChildMeasurementHint.MEASURE_ALWAYS : hint;
    }

    public HasChildMeasurementHint.ChildMeasurementHint getChildMeasurementHint() {
        return this.childMeasurementHint;
    }

    public void setCollapseMenuContent(CollapseMenuContent content) {
        this.getState().collapseMenuContent = content;
    }

    public CollapseMenuContent getCollapseMenuContent() {
        return this.getState((boolean)false).collapseMenuContent;
    }

    @Deprecated
    public static class TableContextClickEvent
    extends ContextClickEvent {
        private final Object itemId;
        private final Object propertyId;
        private final TableConstants.Section section;

        public TableContextClickEvent(Table source, MouseEventDetails mouseEventDetails, Object itemId, Object propertyId, TableConstants.Section section) {
            super((Component)source, mouseEventDetails);
            this.itemId = itemId;
            this.propertyId = propertyId;
            this.section = section;
        }

        public Object getItemId() {
            return this.itemId;
        }

        public Object getPropertyId() {
            return this.propertyId;
        }

        public TableConstants.Section getSection() {
            return this.section;
        }

        public Table getComponent() {
            return (Table)super.getComponent();
        }
    }

    @Deprecated
    public static class GeneratedRow
    implements Serializable {
        private boolean htmlContentAllowed = false;
        private boolean spanColumns = false;
        private String[] text = null;

        public GeneratedRow(String ... text) {
            this.setHtmlContentAllowed(false);
            this.setSpanColumns(text == null || text.length == 1);
            this.setText(text);
        }

        public void setText(String ... text) {
            if (text == null || text.length == 1 && text[0] == null) {
                text = new String[]{""};
            }
            this.text = text;
        }

        protected String[] getText() {
            return this.text;
        }

        protected Object getValue() {
            return this.getText();
        }

        protected boolean isHtmlContentAllowed() {
            return this.htmlContentAllowed;
        }

        public void setHtmlContentAllowed(boolean htmlContentAllowed) {
            this.htmlContentAllowed = htmlContentAllowed;
        }

        protected boolean isSpanColumns() {
            return this.spanColumns;
        }

        public void setSpanColumns(boolean spanColumns) {
            this.spanColumns = spanColumns;
        }
    }

    @Deprecated
    public static interface RowGenerator
    extends Serializable {
        public GeneratedRow generateRow(Table var1, Object var2);
    }

    @Deprecated
    public static interface ColumnCollapseListener
    extends SerializableEventListener {
        public void columnCollapseStateChange(ColumnCollapseEvent var1);
    }

    @Deprecated
    public static class ColumnCollapseEvent
    extends Component.Event {
        public static final Method METHOD = ReflectTools.findMethod(ColumnCollapseListener.class, (String)"columnCollapseStateChange", (Class[])new Class[]{ColumnCollapseEvent.class});
        private Object propertyId;

        public ColumnCollapseEvent(Component source, Object propertyId) {
            super(source);
            this.propertyId = propertyId;
        }

        public Object getPropertyId() {
            return this.propertyId;
        }
    }

    @Deprecated
    public static interface ColumnReorderListener
    extends SerializableEventListener {
        public void columnReorder(ColumnReorderEvent var1);
    }

    @Deprecated
    public static class ColumnReorderEvent
    extends Component.Event {
        public static final Method METHOD;

        public ColumnReorderEvent(Component source) {
            super(source);
        }

        static {
            try {
                METHOD = ColumnReorderListener.class.getDeclaredMethod("columnReorder", ColumnReorderEvent.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public static interface ColumnResizeListener
    extends SerializableEventListener {
        public void columnResize(ColumnResizeEvent var1);
    }

    @Deprecated
    public static class ColumnResizeEvent
    extends Component.Event {
        public static final Method COLUMN_RESIZE_METHOD;
        private final int previousWidth;
        private final int currentWidth;
        private final Object columnPropertyId;

        public ColumnResizeEvent(Component source, Object propertyId, int previous, int current) {
            super(source);
            this.previousWidth = previous;
            this.currentWidth = current;
            this.columnPropertyId = propertyId;
        }

        public Object getPropertyId() {
            return this.columnPropertyId;
        }

        public int getPreviousWidth() {
            return this.previousWidth;
        }

        public int getCurrentWidth() {
            return this.currentWidth;
        }

        static {
            try {
                COLUMN_RESIZE_METHOD = ColumnResizeListener.class.getDeclaredMethod("columnResize", ColumnResizeEvent.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public static interface FooterClickListener
    extends SerializableEventListener {
        public void footerClick(FooterClickEvent var1);
    }

    @Deprecated
    public static interface HeaderClickListener
    extends SerializableEventListener {
        public void headerClick(HeaderClickEvent var1);
    }

    @Deprecated
    public static class FooterClickEvent
    extends MouseEvents.ClickEvent {
        public static final Method FOOTER_CLICK_METHOD;
        private final Object columnPropertyId;

        public FooterClickEvent(Component source, Object propertyId, MouseEventDetails details) {
            super(source, details);
            this.columnPropertyId = propertyId;
        }

        public Object getPropertyId() {
            return this.columnPropertyId;
        }

        static {
            try {
                FOOTER_CLICK_METHOD = FooterClickListener.class.getDeclaredMethod("footerClick", FooterClickEvent.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public static class HeaderClickEvent
    extends MouseEvents.ClickEvent {
        public static final Method HEADER_CLICK_METHOD;
        private final Object columnPropertyId;

        public HeaderClickEvent(Component source, Object propertyId, MouseEventDetails details) {
            super(source, details);
            this.columnPropertyId = propertyId;
        }

        public Object getPropertyId() {
            return this.columnPropertyId;
        }

        static {
            try {
                HEADER_CLICK_METHOD = HeaderClickListener.class.getDeclaredMethod("headerClick", HeaderClickEvent.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public static abstract class TableDropCriterion
    extends ServerSideCriterion {
        private Table table;
        private Set<Object> allowedItemIds;

        protected String getIdentifier() {
            return TableDropCriterion.class.getCanonicalName();
        }

        public boolean accept(DragAndDropEvent dragEvent) {
            AbstractSelect.AbstractSelectTargetDetails dropTargetData = (AbstractSelect.AbstractSelectTargetDetails)dragEvent.getTargetDetails();
            this.table = (Table)dragEvent.getTargetDetails().getTarget();
            Collection<Object> visibleItemIds = this.table.getVisibleItemIds();
            this.allowedItemIds = this.getAllowedItemIds(dragEvent, this.table, visibleItemIds);
            return this.allowedItemIds.contains(dropTargetData.getItemIdOver());
        }

        public void paintResponse(PaintTarget target) throws PaintException {
            Object[] array = this.allowedItemIds.toArray();
            for (int i = 0; i < array.length; ++i) {
                String key = this.table.itemIdMapper.key(array[i]);
                array[i] = key;
            }
            target.addAttribute("allowedIds", array);
        }

        protected abstract Set<Object> getAllowedItemIds(DragAndDropEvent var1, Table var2, Collection<Object> var3);
    }

    @Deprecated
    public class TableTransferable
    extends DataBoundTransferable {
        protected TableTransferable(Map<String, Object> rawVariables) {
            super((Component)Table.this, rawVariables);
            Object object = rawVariables.get("itemId");
            if (object != null) {
                this.setData("itemId", Table.this.itemIdMapper.get((String)object));
            }
            if ((object = rawVariables.get("propertyId")) != null) {
                this.setData("propertyId", Table.this.columnIdMap.get((String)object));
            }
        }

        @Override
        public Object getItemId() {
            return this.getData("itemId");
        }

        @Override
        public Object getPropertyId() {
            return this.getData("propertyId");
        }

        public Table getSourceComponent() {
            return (Table)super.getSourceComponent();
        }
    }

    @Deprecated
    public static interface CellStyleGenerator
    extends Serializable {
        public String getStyle(Table var1, Object var2, Object var3);
    }

    @Deprecated
    public static interface ColumnGenerator
    extends Serializable {
        public Object generateCell(Table var1, Object var2, Object var3);
    }

    @Deprecated
    public static class CacheUpdateException
    extends RuntimeException {
        private Throwable[] causes;
        private Table table;

        public CacheUpdateException(Table table, String message, Throwable[] causes) {
            super(CacheUpdateException.maybeSupplementMessage(message, causes.length), causes[0]);
            this.table = table;
            this.causes = causes;
        }

        private static String maybeSupplementMessage(String message, int causeCount) {
            if (causeCount > 1) {
                return message + " Additional causes not shown.";
            }
            return message;
        }

        public Throwable[] getCauses() {
            return this.causes;
        }

        public Table getTable() {
            return this.table;
        }
    }

    @Deprecated
    public static enum RowHeaderMode {
        HIDDEN(null),
        ID(AbstractSelect.ItemCaptionMode.ID),
        ITEM(AbstractSelect.ItemCaptionMode.ITEM),
        INDEX(AbstractSelect.ItemCaptionMode.INDEX),
        EXPLICIT_DEFAULTS_ID(AbstractSelect.ItemCaptionMode.EXPLICIT_DEFAULTS_ID),
        EXPLICIT(AbstractSelect.ItemCaptionMode.EXPLICIT),
        ICON_ONLY(AbstractSelect.ItemCaptionMode.ICON_ONLY),
        PROPERTY(AbstractSelect.ItemCaptionMode.PROPERTY);

        AbstractSelect.ItemCaptionMode mode;

        private RowHeaderMode(AbstractSelect.ItemCaptionMode mode) {
            this.mode = mode;
        }

        public AbstractSelect.ItemCaptionMode getItemCaptionMode() {
            return this.mode;
        }
    }

    @Deprecated
    public static enum ColumnHeaderMode {
        HIDDEN,
        ID,
        EXPLICIT,
        EXPLICIT_DEFAULTS_ID;

    }

    @Deprecated
    public static enum Align {
        LEFT("b"),
        CENTER("c"),
        RIGHT("e");

        private String alignment;

        private Align(String alignment) {
            this.alignment = alignment;
        }

        public String toString() {
            return this.alignment;
        }

        public Align convertStringToAlign(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("b")) {
                return LEFT;
            }
            if (string.equals("c")) {
                return CENTER;
            }
            if (string.equals("e")) {
                return RIGHT;
            }
            return null;
        }
    }

    @Deprecated
    public static enum TableDragMode {
        NONE,
        ROW,
        MULTIROW;

    }
}

