/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.fieldgroup;

import com.vaadin.data.util.BeanUtil;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.fieldgroup.FieldGroup;
import com.vaadin.v7.data.util.BeanItem;
import com.vaadin.v7.data.validator.BeanValidator;
import com.vaadin.v7.ui.Field;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class BeanFieldGroup<T>
extends FieldGroup {
    private final Class<T> beanType;
    private static Boolean beanValidationImplementationAvailable = null;
    private final Map<Field<?>, BeanValidator> defaultValidators;

    public BeanFieldGroup(Class<T> beanType) {
        this.beanType = beanType;
        this.defaultValidators = new HashMap();
    }

    @Override
    protected Class<?> getPropertyType(Object propertyId) {
        if (this.getItemDataSource() != null) {
            return super.getPropertyType(propertyId);
        }
        try {
            Class type = BeanUtil.getPropertyType(this.beanType, (String)propertyId.toString());
            if (type == null) {
                throw new FieldGroup.BindException("Cannot determine type of propertyId '" + propertyId + "'. The propertyId was not found in " + this.beanType.getName());
            }
            return type;
        }
        catch (IntrospectionException e) {
            throw new FieldGroup.BindException("Cannot determine type of propertyId '" + propertyId + "'. Unable to introspect " + this.beanType, e);
        }
    }

    @Override
    protected Object findPropertyId(java.lang.reflect.Field memberField) {
        String fieldName = memberField.getName();
        Item dataSource = this.getItemDataSource();
        if (dataSource != null && dataSource.getItemProperty(fieldName) != null) {
            return fieldName;
        }
        String minifiedFieldName = BeanFieldGroup.minifyFieldName(fieldName);
        try {
            return BeanFieldGroup.getFieldName(this.beanType, minifiedFieldName);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    private static String getFieldName(Class<?> cls, String propertyId) throws SecurityException, NoSuchFieldException {
        for (java.lang.reflect.Field field1 : cls.getDeclaredFields()) {
            if (!propertyId.equals(BeanFieldGroup.minifyFieldName(field1.getName()))) continue;
            return field1.getName();
        }
        Class<?> superClass = cls.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return BeanFieldGroup.getFieldName(superClass, propertyId);
        }
        throw new NoSuchFieldException();
    }

    public void setItemDataSource(T bean) {
        if (bean == null) {
            this.setItemDataSource((Item)null);
        } else {
            this.setItemDataSource(new BeanItem<T>(bean, this.beanType));
        }
    }

    @Override
    public void setItemDataSource(Item item) {
        if (item != null && !(item instanceof BeanItem)) {
            throw new RuntimeException(this.getClass().getSimpleName() + " only supports BeanItems as item data source");
        }
        super.setItemDataSource(item);
    }

    @Override
    public BeanItem<T> getItemDataSource() {
        return (BeanItem)super.getItemDataSource();
    }

    private void ensureNestedPropertyAdded(Object propertyId) {
        if (this.getItemDataSource() != null) {
            try {
                this.getItemProperty(propertyId);
            }
            catch (FieldGroup.BindException e) {
                ((BeanItem)this.getItemDataSource()).addNestedProperty((String)propertyId);
            }
        }
    }

    public void bind(Field field, Object propertyId) {
        this.ensureNestedPropertyAdded(propertyId);
        super.bind(field, propertyId);
    }

    @Override
    public <T extends Field> T buildAndBind(String caption, Object propertyId, Class<T> fieldType) throws FieldGroup.BindException {
        this.ensureNestedPropertyAdded(propertyId);
        return super.buildAndBind(caption, propertyId, fieldType);
    }

    @Override
    public void unbind(Field<?> field) throws FieldGroup.BindException {
        super.unbind(field);
        BeanValidator removed = this.defaultValidators.remove(field);
        if (removed != null) {
            field.removeValidator(removed);
        }
    }

    @Override
    protected void configureField(Field<?> field) {
        super.configureField(field);
        if (BeanFieldGroup.isBeanValidationImplementationAvailable() && !this.defaultValidators.containsKey(field)) {
            BeanValidator validator = new BeanValidator(this.beanType, this.getPropertyId(field).toString());
            field.addValidator(validator);
            if (field.getLocale() != null) {
                validator.setLocale(field.getLocale());
            }
            this.defaultValidators.put(field, validator);
        }
    }

    protected static boolean isBeanValidationImplementationAvailable() {
        if (beanValidationImplementationAvailable != null) {
            return beanValidationImplementationAvailable;
        }
        try {
            Class<?> validationClass = Class.forName("javax.validation.Validation");
            Method buildFactoryMethod = validationClass.getMethod("buildDefaultValidatorFactory", new Class[0]);
            Object factory = buildFactoryMethod.invoke(null, new Object[0]);
            beanValidationImplementationAvailable = factory != null;
        }
        catch (Exception e) {
            beanValidationImplementationAvailable = false;
        }
        return beanValidationImplementationAvailable;
    }

    public static <T> BeanFieldGroup<T> bindFieldsUnbuffered(T bean, Object objectWithMemberFields) {
        return BeanFieldGroup.createAndBindFields(bean, objectWithMemberFields, false);
    }

    public static <T> BeanFieldGroup<T> bindFieldsBuffered(T bean, Object objectWithMemberFields) {
        return BeanFieldGroup.createAndBindFields(bean, objectWithMemberFields, true);
    }

    private static <T> BeanFieldGroup<T> createAndBindFields(T bean, Object objectWithMemberFields, boolean buffered) {
        BeanFieldGroup beanFieldGroup = new BeanFieldGroup(bean.getClass());
        beanFieldGroup.setItemDataSource(bean);
        beanFieldGroup.setBuffered(buffered);
        beanFieldGroup.bindMemberFields(objectWithMemberFields);
        return beanFieldGroup;
    }
}

