/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.converter;

import com.vaadin.v7.data.util.converter.Converter;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

@Deprecated
public class StringToCollectionConverter
implements Converter<String, Collection> {
    private final String delimiter;
    private final Converter<String, ?> tokenConverter;
    private final Class<?> tokenType;
    private final CollectionFactory factory;

    public StringToCollectionConverter() {
        this(", ", null, String.class);
    }

    public StringToCollectionConverter(String delimiter) {
        this(delimiter, null, String.class);
    }

    public StringToCollectionConverter(Converter<String, ?> tokenConverter, Class<?> tokenType) {
        this(", ", tokenConverter, tokenType);
    }

    public StringToCollectionConverter(String delimiter, Converter<String, ?> tokenConverter, Class<?> tokenClass) {
        this(delimiter, tokenConverter, tokenClass, new DefaultCollectionFactory());
    }

    public StringToCollectionConverter(String delimiter, Converter<String, ?> tokenConverter, Class<?> tokenClass, CollectionFactory factory) {
        if (delimiter == null || delimiter.isEmpty()) {
            throw new IllegalArgumentException("Delimiter should be non-empty string");
        }
        this.delimiter = delimiter;
        this.tokenConverter = tokenConverter;
        this.tokenType = tokenClass;
        this.factory = factory;
    }

    @Override
    public Class<Collection> getModelType() {
        return Collection.class;
    }

    @Override
    public Class<String> getPresentationType() {
        return String.class;
    }

    @Override
    public Collection convertToModel(String value, Class<? extends Collection> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(this.delimiter);
        int previous = 0;
        Collection<?> result = this.factory.createCollection(targetType);
        Converter<String, ?> converter = this.tokenConverter;
        while (index != -1) {
            this.collectToken(value.substring(previous, index), result, converter, locale);
            previous = index + this.delimiter.length();
            index = value.indexOf(this.delimiter, previous);
        }
        this.collectToken(value.substring(previous), result, converter, locale);
        return result;
    }

    @Override
    public String convertToPresentation(Collection value, Class<? extends String> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Converter<String, ?> converter = this.tokenConverter;
        Iterator iterator = value.iterator();
        while (iterator.hasNext()) {
            if (converter == null) {
                builder.append(iterator.next());
            } else {
                builder.append((Object)converter.convertToPresentation(iterator.next(), targetType, locale));
            }
            builder.append(this.delimiter);
        }
        if (builder.length() > 0) {
            return builder.substring(0, builder.length() - this.delimiter.length());
        }
        return builder.toString();
    }

    private void collectToken(String token, Collection collection, Converter converter, Locale locale) {
        if (converter == null) {
            collection.add(token);
        } else {
            collection.add(converter.convertToModel(token, this.tokenType, locale));
        }
    }

    @Deprecated
    public static interface CollectionFactory
    extends Serializable {
        public Collection<?> createCollection(Class<? extends Collection> var1);
    }

    @Deprecated
    public static class DefaultCollectionFactory
    implements CollectionFactory {
        @Override
        public Collection<?> createCollection(Class<? extends Collection> type) {
            if (type.isAssignableFrom(ArrayList.class)) {
                return new ArrayList();
            }
            if (type.isAssignableFrom(HashSet.class)) {
                return new HashSet();
            }
            if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
                try {
                    return type.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return new ArrayList();
        }
    }
}

