/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.v7.client.connectors;

import com.google.web.bindery.event.shared.HandlerRegistration;
import com.vaadin.client.MouseEventDetailsBuilder;
import com.vaadin.v7.client.renderers.ClickableRenderer;
import com.vaadin.v7.client.renderers.ClickableRenderer.RendererClickEvent;
import com.vaadin.v7.client.renderers.ClickableRenderer.RendererClickHandler;
import com.vaadin.v7.shared.ui.grid.renderers.RendererClickRpc;

import elemental.json.JsonObject;

/**
 * An abstract base class for {@link ClickableRenderer} connectors.
 *
 * @param <T>
 *            the presentation type of the renderer
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
public abstract class ClickableRendererConnector<T>
        extends AbstractGridRendererConnector<T> {

    HandlerRegistration clickRegistration;

    @Override
    protected void init() {
        clickRegistration = addClickHandler(
                new RendererClickHandler<JsonObject>() {
                    @Override
                    public void onClick(RendererClickEvent<JsonObject> event) {
                        if (((GridConnector) getParent()).isReadOnly()) {
                            // NO-OP
                            return;
                        }
                        getRpcProxy(RendererClickRpc.class).click(
                                getRowKey(event.getCell().getRow()),
                                getColumnId(event.getCell().getColumn()),
                                MouseEventDetailsBuilder.buildMouseEventDetails(
                                        event.getNativeEvent()));
                    }
                });
    }

    @Override
    public void onUnregister() {
        clickRegistration.removeHandler();
    }

    protected abstract HandlerRegistration addClickHandler(
            RendererClickHandler<JsonObject> handler);
}
