/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox.testbench;

import com.vaadin.testbench.HasLabel;
import com.vaadin.testbench.HasSelectByText;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;

@Element(value="vaadin-combo-box")
public class ComboBoxElement
extends TestBenchElement
implements HasLabel,
HasSelectByText {
    public void selectByText(String text) {
        this.setFilter(text);
        this.waitForVaadin();
        Boolean success = (Boolean)this.executeScript("var combobox = arguments[0];var text = arguments[1];var matches = combobox.filteredItems.filter(function(item) {return combobox._getItemLabel(item) == text;});if (matches.length == 0) {  return false;} else {  var value = combobox._getItemValue(matches[0]);  combobox.value = value;  return true;}", new Object[]{this, text});
        this.closePopup();
        if (!success.booleanValue()) {
            throw new IllegalArgumentException("Value '" + text + "' not found in the combobox");
        }
    }

    public String getSelectedText() {
        return (String)this.executeScript("var combobox = arguments[0];var selectedItem = combobox.selectedItem;if (!selectedItem)   return '';else   return selectedItem.label;", new Object[]{this});
    }

    public void openPopup() {
        this.callFunction("open", new Object[0]);
    }

    public void closePopup() {
        this.callFunction("close", new Object[0]);
    }

    public boolean isPopupOpen() {
        return this.getPropertyBoolean(new String[]{"opened"});
    }

    public List<String> getOptions() {
        this.openPopup();
        return (List)this.executeScript("var combobox=arguments[0];return combobox.filteredItems.map(function(item) { return combobox._getItemLabel(item);});", new Object[]{this});
    }

    public void setFilter(String filter) {
        this.openPopup();
        this.setProperty("filter", filter);
        this.waitUntil(driver -> this.getPropertyBoolean(new String[]{"loading"}) == false);
    }

    public String getFilter() {
        return this.getPropertyString(new String[]{"filter"});
    }

    public boolean isAutoOpen() {
        return this.getPropertyBoolean(new String[]{"autoOpenDisabled"}) == false;
    }
}

