/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.component.combobox.ComboBoxVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiPredicate;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;

@Tag(value="vaadin-combo-box")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.3.32"), @NpmPackage(value="@vaadin/combo-box", version="23.3.32"), @NpmPackage(value="@vaadin/vaadin-combo-box", version="23.3.32")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/combo-box/src/vaadin-combo-box.js"), @JsModule(value="@vaadin/polymer-legacy-adapter/template-renderer.js"), @JsModule(value="./flow-component-renderer.js"), @JsModule(value="./comboBoxConnector.js")})
public class ComboBox<T>
extends ComboBoxBase<ComboBox<T>, T, T>
implements HasThemeVariant<ComboBoxVariant> {
    private static final String PROP_SELECTED_ITEM = "selectedItem";
    private static final String PROP_VALUE = "value";

    public ComboBox(int pageSize) {
        super(PROP_VALUE, null, String.class, ComboBox::presentationToModel, ComboBox::modelToPresentation);
        this.setPageSize(pageSize);
        this.setItems(new DataCommunicator.EmptyDataProvider());
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (event.isFromClient()) {
                this.refreshValue();
            }
        });
    }

    public ComboBox() {
        this(50);
    }

    public ComboBox(String label) {
        this();
        this.setLabel(label);
    }

    public ComboBox(String label, Collection<T> items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    @SafeVarargs
    public ComboBox(String label, T ... items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    public ComboBox(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<ComboBox<T>, T>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public ComboBox(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<ComboBox<T>, T>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    @SafeVarargs
    public ComboBox(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<ComboBox<T>, T>> listener, T ... items) {
        this(label, listener);
        this.setItems(items);
    }

    private static <T> T presentationToModel(ComboBox<T> comboBox, String presentation) {
        DataKeyMapper keyMapper = comboBox.getKeyMapper();
        if (presentation == null || keyMapper == null) {
            return comboBox.getEmptyValue();
        }
        return (T)keyMapper.get(presentation);
    }

    private static <T> String modelToPresentation(ComboBox<T> comboBox, T model) {
        DataKeyMapper keyMapper = comboBox.getKeyMapper();
        if (model == null || keyMapper == null) {
            return null;
        }
        return keyMapper.key(model);
    }

    @Deprecated
    public boolean isPreventInvalidInput() {
        return this.getElement().getProperty("preventInvalidInput", false);
    }

    @Deprecated
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        this.getElement().setProperty("preventInvalidInput", preventInvalidInput);
    }

    public String getPattern() {
        return this.getElement().getProperty("pattern");
    }

    public void setPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern == null ? "" : pattern);
    }

    @Override
    protected void refreshValue() {
        Object value = this.getValue();
        DataKeyMapper keyMapper = this.getKeyMapper();
        if (value != null && keyMapper.has(value)) {
            value = keyMapper.get(keyMapper.key(value));
        }
        if (value == null) {
            this.getElement().setProperty(PROP_SELECTED_ITEM, null);
            this.getElement().setProperty(PROP_VALUE, "");
            this.getElement().executeJs("this._inputElementValue = $0", new Serializable[]{""});
            return;
        }
        JsonObject json = Json.createObject();
        json.put("key", keyMapper.key(value));
        this.getDataGenerator().generateData(value, json);
        this.getElement().setPropertyJson(PROP_SELECTED_ITEM, (JsonValue)json);
        this.getElement().setProperty(PROP_VALUE, keyMapper.key(value));
        this.getElement().executeJs("this._inputElementValue = $0", new Serializable[]{this.generateLabel(value)});
    }

    @Override
    protected boolean isSelected(T item) {
        Object value = this.getValue();
        DataProvider dataProvider = this.getDataProvider();
        if (dataProvider == null || item == null || value == null) {
            return false;
        }
        return Objects.equals(dataProvider.getId(item), dataProvider.getId(value));
    }

    public T getEmptyValue() {
        return null;
    }

    public void addThemeVariants(ComboBoxVariant ... variants) {
        super.addThemeVariants((ThemeVariant[])variants);
    }

    public void removeThemeVariants(ComboBoxVariant ... variants) {
        super.removeThemeVariants((ThemeVariant[])variants);
    }

    @Deprecated
    protected void addToPrefix(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "prefix");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    @Deprecated
    protected void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    @Deprecated
    protected void removeAll() {
        this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
    }

    @FunctionalInterface
    public static interface ItemFilter<T>
    extends SerializableBiPredicate<T, String> {
        public boolean test(T var1, String var2);
    }

    @FunctionalInterface
    public static interface FetchItemsCallback<T>
    extends Serializable {
        public Stream<T> fetchItems(String var1, int var2, int var3);
    }
}

