/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.GeneratedVaadinCheckbox;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import java.io.Serializable;

public class Checkbox
extends GeneratedVaadinCheckbox<Checkbox, Boolean>
implements HasSize,
HasLabel {
    private final Label labelElement;
    private static final PropertyChangeListener NO_OP = (PropertyChangeListener & Serializable)event -> {};

    public Checkbox() {
        super(false, false, false, true);
        this.getElement().addPropertyChangeListener("indeterminate", "indeterminate-changed", NO_OP);
        this.getElement().addPropertyChangeListener("checked", "checked-changed", NO_OP);
        this.setIndeterminate(false);
        this.labelElement = new Label();
        this.labelElement.getElement().setAttribute("slot", "label");
    }

    public Checkbox(String labelText) {
        this();
        this.setLabel(labelText);
    }

    public Checkbox(boolean initialValue) {
        this();
        this.setValue(initialValue);
    }

    public Checkbox(String labelText, boolean initialValue) {
        this(labelText);
        this.setValue(initialValue);
    }

    public Checkbox(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public Checkbox(boolean initialValue, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(initialValue);
        this.addValueChangeListener(listener);
    }

    public Checkbox(String labelText, boolean initialValue, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Checkbox, Boolean>> listener) {
        this(labelText, initialValue);
        this.addValueChangeListener(listener);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setLabel(String label) {
        if (this.getElement().equals((Object)this.labelElement.getElement().getParent())) {
            this.getElement().removeChild(new Element[]{this.labelElement.getElement()});
        }
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    @Deprecated
    public void setLabelAsHtml(String htmlContent) {
        this.setLabel("");
        this.labelElement.getElement().setProperty("innerHTML", htmlContent);
        this.getElement().appendChild(new Element[]{this.labelElement.getElement()});
    }

    public void setLabelComponent(Component component) {
        this.setLabel("");
        this.getElement().appendChild(new Element[]{this.labelElement.getElement()});
        this.labelElement.removeAll();
        this.labelElement.add(new Component[]{component});
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setAttribute("aria-label", ariaLabel);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
    }

    public boolean isIndeterminate() {
        return this.isIndeterminateBoolean();
    }
}

