/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.checkbox.FieldValidationUtil;
import com.vaadin.flow.component.checkbox.GeneratedVaadinCheckbox;
import com.vaadin.flow.component.checkbox.GeneratedVaadinCheckboxGroup;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.binder.HasItemsAndComponents;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CheckboxGroup<T>
extends GeneratedVaadinCheckboxGroup<CheckboxGroup<T>, Set<T>>
implements HasItemsAndComponents<T>,
HasSize,
HasValidation,
MultiSelect<CheckboxGroup<T>, T>,
HasDataProvider<T>,
HasHelper,
HasLabel {
    private static final String VALUE = "value";
    private final KeyMapper<T> keyMapper = new KeyMapper(this::getItemId);
    private DataProvider<T, ?> dataProvider = DataProvider.ofItems((Object[])new Object[0]);
    private boolean isReadOnly;
    private SerializablePredicate<T> itemEnabledProvider = (SerializablePredicate & Serializable)item -> this.isEnabled();
    private ItemLabelGenerator<T> itemLabelGenerator = String::valueOf;
    private final PropertyChangeListener validationListener = this::validateSelectionEnabledState;
    private Registration validationRegistration;
    private Registration dataProviderListenerRegistration;

    public CheckboxGroup() {
        super(Collections.emptySet(), Collections.emptySet(), JsonArray.class, CheckboxGroup::presentationToModel, CheckboxGroup::modelToPresentation);
        this.registerValidation();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        FieldValidationUtil.disableClientValidation(this);
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider = dataProvider;
        this.reset();
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                Object otherItem = ((DataChangeEvent.DataRefreshEvent)event).getItem();
                this.getCheckboxItems().filter(item -> Objects.equals(this.getItemId(((CheckBoxItem)item).item), this.getItemId(otherItem))).findFirst().ifPresent(this::updateCheckbox);
            } else {
                this.reset();
            }
        });
    }

    public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        HashSet<T> value = new HashSet<T>((Collection)this.getValue());
        value.addAll(addedItems);
        value.removeAll(removedItems);
        this.setValue(value);
    }

    public void setValue(Set<T> value) {
        Objects.requireNonNull(value, "Cannot set a null value to checkbox group. Use the clear-method to reset the component's value to an empty set.");
        super.setValue(value);
        this.refreshCheckboxes();
    }

    public Set<T> getSelectedItems() {
        return (Set)this.getValue();
    }

    public Registration addSelectionListener(MultiSelectionListener<CheckboxGroup<T>, T> listener) {
        return this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listener.selectionChange(new MultiSelectionEvent((Component)this, (HasValue)this, (Set)event.getOldValue(), event.isFromClient())));
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider;
    }

    public void onEnabledStateChanged(boolean enabled) {
        if (this.isReadOnly()) {
            this.setDisabled(true);
        } else {
            this.setDisabled(!enabled);
        }
        this.getCheckboxItems().forEach(this::updateEnabled);
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        if (this.isEnabled()) {
            this.setDisabled(readOnly);
            this.refreshCheckboxes();
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = Objects.requireNonNull(itemEnabledProvider);
        this.refreshCheckboxes();
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.reset();
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return super.getLabelString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    protected boolean valueEquals(Set<T> value1, Set<T> value2) {
        assert (value1 != null && value2 != null);
        if (value1.size() != value2.size()) {
            return false;
        }
        if (this.getDataProvider() == null) {
            return super.valueEquals(value1, value2);
        }
        Set ids1 = value1.stream().map(arg_0 -> this.getDataProvider().getId(arg_0)).collect(Collectors.toSet());
        Set ids2 = value2.stream().map(arg_0 -> this.getDataProvider().getId(arg_0)).collect(Collectors.toSet());
        return ids1.equals(ids2);
    }

    protected boolean hasValidValue() {
        Set value = CheckboxGroup.presentationToModel(this, (JsonArray)this.getElement().getPropertyRaw(VALUE));
        Set oldValue = (Set)this.getValue();
        return this.getCheckboxItems().filter(GeneratedVaadinCheckbox::isDisabledBoolean).noneMatch(item -> oldValue.contains(item.getItem()) != value.contains(item.getItem()));
    }

    private void reset() {
        Component helperComponent = this.getHelperComponent();
        this.keyMapper.removeAll();
        this.removeAll();
        this.clear();
        this.setHelperComponent(helperComponent);
        this.getDataProvider().fetch(new Query()).map(this::createCheckBox).forEach(xva$0 -> this.add(new Component[]{xva$0}));
    }

    private void refreshCheckboxes() {
        this.getCheckboxItems().forEach(this::updateCheckbox);
    }

    private Stream<CheckBoxItem<T>> getCheckboxItems() {
        return this.getChildren().filter(CheckBoxItem.class::isInstance).map(child -> (CheckBoxItem)((Object)child));
    }

    private Checkbox createCheckBox(T item) {
        CheckBoxItem checkbox = new CheckBoxItem(this.keyMapper.key(item), item);
        this.updateCheckbox(checkbox);
        return checkbox;
    }

    private void updateCheckbox(CheckBoxItem<T> checkbox) {
        checkbox.setLabel(this.getItemLabelGenerator().apply(checkbox.getItem()));
        checkbox.setValue(((Set)this.getValue()).stream().anyMatch(selectedItem -> Objects.equals(this.getItemId(selectedItem), this.getItemId(checkbox.getItem()))));
        this.updateEnabled(checkbox);
    }

    private void updateEnabled(CheckBoxItem<T> checkbox) {
        boolean disabled = this.isDisabledBoolean() || !this.getItemEnabledProvider().test(checkbox.getItem());
        checkbox.setDisabled(disabled);
        checkbox.getElement().executeJs("this.disabled = $0", new Serializable[]{Boolean.valueOf(disabled)});
    }

    private void validateSelectionEnabledState(PropertyChangeEvent event) {
        if (!this.hasValidValue()) {
            Set<T> oldValue = CheckboxGroup.presentationToModel(this, (JsonArray)event.getOldValue());
            try {
                this.validationRegistration.remove();
                this.getElement().setPropertyJson(VALUE, (JsonValue)CheckboxGroup.modelToPresentation(this, oldValue));
            }
            finally {
                this.registerValidation();
            }
            Set value = CheckboxGroup.presentationToModel(this, (JsonArray)event.getValue());
            this.getCheckboxItems().filter(checkbox -> value.contains(checkbox.getItem())).forEach(this::updateEnabled);
        }
    }

    private void registerValidation() {
        if (this.validationRegistration != null) {
            this.validationRegistration.remove();
        }
        this.validationRegistration = this.getElement().addPropertyChangeListener(VALUE, this.validationListener);
    }

    private static <T> Set<T> presentationToModel(CheckboxGroup<T> group, JsonArray presentation) {
        JsonArray array = presentation;
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < array.length(); ++i) {
            set.add(group.keyMapper.get(array.getString(i)));
        }
        return set;
    }

    private static <T> JsonArray modelToPresentation(CheckboxGroup<T> group, Set<T> model) {
        JsonArray array = Json.createArray();
        if (model.isEmpty()) {
            return array;
        }
        model.stream().map(arg_0 -> group.keyMapper.key(arg_0)).forEach(key -> array.set(array.length(), key));
        return array;
    }

    private Object getItemId(T item) {
        if (this.getDataProvider() == null) {
            return item;
        }
        return this.getDataProvider().getId(item);
    }

    private static class CheckBoxItem<T>
    extends Checkbox
    implements HasItemsAndComponents.ItemComponent<T> {
        private final T item;

        private CheckBoxItem(String id, T item) {
            this.item = item;
            this.getElement().setProperty(CheckboxGroup.VALUE, id);
        }

        public T getItem() {
            return this.item;
        }
    }
}

