/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.button;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.button.GeneratedVaadinButton;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Button
extends GeneratedVaadinButton<Button>
implements HasSize,
HasEnabled {
    private Component iconComponent;
    private boolean iconAfterText;
    private boolean disableOnClick = false;
    private boolean disableOnClickConfigured = false;
    private Registration disableListener = this.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> {
        if (this.disableOnClick) {
            this.doDisableOnClick();
        }
    });

    public Button() {
    }

    public Button(String text) {
        this.setText(text);
    }

    public Button(Component icon) {
        this.setIcon(icon);
    }

    public Button(String text, Component icon) {
        this.setIcon(icon);
        this.setText(text);
    }

    public Button(String text, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this.setText(text);
        this.addClickListener(clickListener);
    }

    public Button(Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this.setIcon(icon);
        this.addClickListener(clickListener);
    }

    public Button(String text, Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this.setIcon(icon);
        this.setText(text);
        this.addClickListener(clickListener);
    }

    public void setText(String text) {
        this.removeAll(this.getNonTextNodes());
        if (text != null && !text.isEmpty()) {
            this.getElement().appendChild(new Element[]{Element.createText((String)text)});
        }
        this.updateThemeAttribute();
    }

    public void setIcon(Component icon) {
        if (icon != null && icon.getElement().isTextNode()) {
            throw new IllegalArgumentException("Text node can't be used as an icon.");
        }
        if (this.iconComponent != null) {
            this.remove(this.iconComponent);
        }
        this.iconComponent = icon;
        if (icon != null) {
            this.add(icon);
            this.updateIconSlot();
        }
        this.updateThemeAttribute();
    }

    public Component getIcon() {
        return this.iconComponent;
    }

    public void setIconAfterText(boolean iconAfterText) {
        this.iconAfterText = iconAfterText;
        if (this.iconComponent != null) {
            this.updateIconSlot();
        }
    }

    public boolean isIconAfterText() {
        return this.iconAfterText;
    }

    public void click() {
        this.fireEvent((ComponentEvent)new ClickEvent((Component)this, false, 0, 0, 0, 0, 0, 0, false, false, false, false));
    }

    public void clickInClient() {
        this.getElement().callJsFunction("click", new Serializable[0]);
    }

    private void add(Component ... components) {
        assert (components != null);
        for (Component component : components) {
            assert (component != null);
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    public void setDisableOnClick(boolean disableOnClick) {
        this.disableOnClick = disableOnClick;
        if (disableOnClick) {
            this.initDisableOnClick();
            this.getElement().setAttribute("disableOnClick", "true");
        } else {
            this.getElement().removeAttribute("disableOnClick");
        }
    }

    public boolean isDisableOnClick() {
        return this.disableOnClick;
    }

    private void initDisableOnClick() {
        if (!this.disableOnClickConfigured) {
            this.getElement().executeJs("var disableEvent = function () {if($0.getAttribute('disableOnClick')){ $0.setAttribute('disabled', 'true');}};$0.addEventListener('click', disableEvent)", new Serializable[0]);
            this.disableOnClickConfigured = true;
        }
    }

    private void updateIconSlot() {
        this.iconComponent.getElement().setAttribute("slot", this.iconAfterText ? "suffix" : "prefix");
    }

    private void removeAll(Element ... exclusion) {
        Set toExclude = Stream.of(exclusion).collect(Collectors.toSet());
        Predicate<Element> filter = toExclude::contains;
        this.getElement().getChildren().filter(filter.negate()).forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
        this.getElement().appendChild(exclusion);
    }

    private Element[] getNonTextNodes() {
        return (Element[])this.getElement().getChildren().filter(element -> !element.isTextNode()).toArray(Element[]::new);
    }

    private void updateThemeAttribute() {
        if (this.getElement().getChildCount() == 1 && this.iconComponent != null) {
            this.getThemeNames().add((Object)"icon");
        } else {
            this.getThemeNames().remove((Object)"icon");
        }
    }

    private void doDisableOnClick() {
        ElementAttributeMap elementAttributeMap = (ElementAttributeMap)this.getElement().getNode().getFeature(ElementAttributeMap.class);
        elementAttributeMap.set("disabled", "true");
        Map changes = (Map)((Object)this.getElement().getNode().getChangeTracker((NodeFeature)elementAttributeMap, () -> null));
        if (changes != null) {
            changes.remove("disabled");
            this.setEnabled(false);
            this.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)executionContext -> {
                if (this.isEnabled()) {
                    executionContext.getUI().getPage().executeJs("$0.disabled = false;", new Serializable[]{this.getElement()});
                }
            }));
        }
    }
}

