/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.button;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.button.GeneratedVaadinButton;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import java.io.Serializable;

public class Button
extends GeneratedVaadinButton<Button>
implements HasSize,
HasEnabled {
    private static final String THEME_ATTRIBUTE = "theme";
    private Element span;
    private Component iconComponent;
    private boolean iconAfterText;

    public Button() {
    }

    public Button(String text) {
        this.setText(text);
    }

    public Button(Component icon) {
        this.setIcon(icon);
    }

    public Button(String text, Component icon) {
        this.setIcon(icon);
        this.setText(text);
    }

    public Button(String text, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this.setText(text);
        this.addClickListener(clickListener);
    }

    public Button(Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this.setIcon(icon);
        this.addClickListener(clickListener);
    }

    public Button(String text, Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        this.setIcon(icon);
        this.setText(text);
        this.addClickListener(clickListener);
    }

    public void setText(String text) {
        Element[] nonTextNodes = this.getNonTextNodes();
        this.removeAll();
        this.getElement().appendChild(nonTextNodes);
        if (text == null || text.isEmpty()) {
            if (this.span != null) {
                this.getElement().removeChild(new Element[]{this.span});
                this.span = null;
            }
        } else if (this.span != null) {
            this.span.setText(text);
        } else if (this.iconComponent == null) {
            this.getElement().appendChild(new Element[]{Element.createText((String)text)});
        } else {
            this.span = ElementFactory.createSpan((String)text);
            if (this.iconAfterText) {
                this.getElement().insertChild(0, new Element[]{this.span});
            } else {
                this.getElement().appendChild(new Element[]{this.span});
            }
        }
        this.updateThemeAttribute();
    }

    public String getText() {
        if (this.span == null) {
            return super.getText();
        }
        return this.span.getText();
    }

    public void setIcon(Component icon) {
        if (icon != null && icon.getElement().isTextNode()) {
            throw new IllegalArgumentException("Text node can't be used as an icon.");
        }
        if (this.iconComponent != null) {
            this.remove(this.iconComponent);
        }
        this.iconComponent = icon;
        if (this.iconComponent == null) {
            this.updateThemeAttribute();
            return;
        }
        if (this.iconAfterText) {
            this.add(this.iconComponent);
        } else {
            this.getElement().insertChild(0, new Element[]{this.iconComponent.getElement()});
        }
        if (this.span == null && !this.getText().isEmpty()) {
            this.wrapTextInSpan();
        }
        this.updateThemeAttribute();
    }

    public Component getIcon() {
        return this.iconComponent;
    }

    public void setIconAfterText(boolean iconAfterText) {
        this.iconAfterText = iconAfterText;
        Element[] textNodes = this.getTextNodes();
        if (this.span == null && textNodes.length == 0 || this.iconComponent == null) {
            return;
        }
        int iconIndex = this.getElement().indexOfChild(this.iconComponent.getElement());
        int textIndex = this.span != null ? this.getElement().indexOfChild(this.span) : (iconAfterText ? this.getElement().indexOfChild(textNodes[textNodes.length - 1]) : this.getElement().indexOfChild(textNodes[0]));
        if (iconAfterText && iconIndex < textIndex) {
            this.add(this.iconComponent);
        } else if (!iconAfterText && textIndex < iconIndex) {
            this.getElement().insertChild(0, new Element[]{this.iconComponent.getElement()});
        }
    }

    public boolean isIconAfterText() {
        return this.iconAfterText;
    }

    public void click() {
        this.getElement().callFunction("click", new Serializable[0]);
    }

    private void add(Component ... components) {
        assert (components != null);
        for (Component component : components) {
            assert (component != null);
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    private void wrapTextInSpan() {
        String text = this.getText();
        this.getElement().removeChild(this.getTextNodes());
        this.span = ElementFactory.createSpan((String)text);
        if (this.iconAfterText) {
            this.getElement().insertChild(0, new Element[]{this.span});
        } else {
            this.getElement().appendChild(new Element[]{this.span});
        }
    }

    private Element[] getNonTextNodes() {
        return (Element[])this.getElement().getChildren().filter(element -> !element.isTextNode()).toArray(Element[]::new);
    }

    private Element[] getTextNodes() {
        return (Element[])this.getElement().getChildren().filter(Element::isTextNode).toArray(Element[]::new);
    }

    private void updateThemeAttribute() {
        String theme = this.getElement().getAttribute(THEME_ATTRIBUTE);
        if (theme == null && this.getElement().getChildCount() == 1 && this.iconComponent != null) {
            this.getElement().setAttribute(THEME_ATTRIBUTE, "icon");
        } else if ("icon".equals(theme)) {
            this.getElement().removeAttribute(THEME_ATTRIBUTE);
        }
    }
}

