/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.applayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.RouterLayout;
import java.util.Objects;

@Tag(value="vaadin-app-layout")
@NpmPackage(value="@vaadin/vaadin-app-layout", version="21.0.2")
@JsModule(value="@vaadin/vaadin-app-layout/src/vaadin-app-layout.js")
public class AppLayout
extends Component
implements RouterLayout {
    private static final PropertyDescriptor<String, String> primarySectionProperty = PropertyDescriptors.propertyWithDefault((String)"primarySection", (String)Section.NAVBAR.toWebcomponentValue());
    private static final PropertyDescriptor<Boolean, Boolean> overlayProperty = PropertyDescriptors.propertyWithDefault((String)"overlay", (Boolean)false);
    private Component content;

    @Synchronize(value={"primary-section-changed"})
    public Section getPrimarySection() {
        return Section.fromWebcomponentValue((String)primarySectionProperty.get((HasElement)this));
    }

    public void setPrimarySection(Section primarySection) {
        Objects.requireNonNull(primarySection, "primary section must not be null");
        primarySectionProperty.set((HasElement)this, (Object)primarySection.toWebcomponentValue());
    }

    @Synchronize(value={"drawer-opened-changed"})
    public boolean isDrawerOpened() {
        return this.getElement().getProperty("drawerOpened", true);
    }

    public void setDrawerOpened(boolean drawerOpened) {
        this.getElement().setProperty("drawerOpened", drawerOpened);
    }

    @Synchronize(value={"overlay-changed"})
    public boolean isOverlay() {
        return (Boolean)overlayProperty.get((HasElement)this);
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        this.removeContent();
        if (content != null) {
            this.content = content;
            content.getElement().removeAttribute("slot");
            this.add(content);
        }
    }

    public void addToDrawer(Component ... components) {
        this.addToSlot("drawer", components);
    }

    public void addToNavbar(Component ... components) {
        boolean touchOptimized = false;
        this.addToNavbar(false, components);
    }

    public void addToNavbar(boolean touchOptimized, Component ... components) {
        String slot = "navbar" + (touchOptimized ? " touch-optimized" : "");
        this.addToSlot(slot, components);
    }

    public void remove(Component ... components) {
        for (Component component : components) {
            if (this.content != null && this.content.equals(component)) {
                this.content = null;
            }
            this.remove(component);
        }
    }

    public void showRouterLayoutContent(HasElement content) {
        Component target = null;
        if (content != null) {
            target = (Component)content.getElement().getComponent().orElseThrow(() -> new IllegalArgumentException("AppLayout content must be a Component"));
        }
        this.setContent(target);
        this.afterNavigation();
    }

    protected void afterNavigation() {
        if (this.isOverlay()) {
            this.setDrawerOpened(false);
        }
    }

    private void addToSlot(String slot, Component ... components) {
        for (Component component : components) {
            AppLayout.setSlot(component, slot);
            this.add(component);
        }
    }

    private void add(Component component) {
        this.getElement().appendChild(new Element[]{component.getElement()});
    }

    private static void setSlot(Component component, String slot) {
        component.getElement().setAttribute("slot", slot);
    }

    private void removeContent() {
        this.remove(this.content);
        this.content = null;
    }

    private void remove(Component component) {
        if (component != null) {
            component.getElement().removeFromParent();
        }
    }

    public static enum Section {
        NAVBAR,
        DRAWER;


        public String toWebcomponentValue() {
            return this.name().toLowerCase();
        }

        public static Section fromWebcomponentValue(String webcomponentValue) {
            return webcomponentValue != null ? Section.valueOf(webcomponentValue.toUpperCase()) : null;
        }
    }
}

