package com.vaadin.uitest.model.scenario;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TestScenarios {
    private List<TestScenario> scenarios;

    public TestScenarios() {
    }

    public TestScenarios(List<TestScenario> scenarios) {
        this.scenarios = scenarios;
    }

    public List<TestScenario> getScenarios() {
        return scenarios;
    }

    public void setScenarios(List<TestScenario> scenarios) {
        this.scenarios = scenarios;
    }

    public static TestScenarios parse(String gherkinTestScenarios) {
        // TODO implement a more stable parser
        List<TestScenario> scenarioList = new ArrayList<>();
        String[] scenarios = gherkinTestScenarios.split("Scenario: ");
        for (int scenarioIndex = 1; scenarioIndex < scenarios.length; scenarioIndex++) {
            String[] scenario = scenarios[scenarioIndex].trim()
                    .split("\\r?\\n");
            String scenarioDescription = scenario[0].trim();
            List<TestScenarioStep> scenarioStepList = new ArrayList<>();
            for (int stepIndex = 1; stepIndex < scenario.length; stepIndex++) {
                String step = scenario[stepIndex].trim();
                TestScenarioStepType testScenarioStepType = null;
                if (step.startsWith("Given")) {
                    testScenarioStepType = TestScenarioStepType.STATE;
                } else if (step.startsWith("When")) {
                    testScenarioStepType = TestScenarioStepType.ACTION;
                } else if (step.startsWith("Then")) {
                    testScenarioStepType = TestScenarioStepType.ASSERTION;
                } else if (step.startsWith("And")) {
                    testScenarioStepType = scenarioStepList
                            .get(scenarioStepList.size() - 1).getType();
                }
                if (testScenarioStepType != null) {
                    scenarioStepList.add(
                            new TestScenarioStep(testScenarioStepType, step));
                }
            }
            scenarioList.add(
                    new TestScenario(scenarioDescription, scenarioStepList));
        }
        return new TestScenarios(scenarioList);
    }

    @Override
    public String toString() {
        return scenarios.stream().map(scenario -> {
            String steps = scenario.getSteps().stream()
                    .map(TestScenarioStep::toString).map("  "::concat)
                    .collect(Collectors.joining("\n"));
            return "Scenario: " + scenario.getDescription() + "\n" + steps;
        }).collect(Collectors.joining("\n\n"));
    }
}
