/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.vaadin.signals.impl.ComputedSignal;
import com.vaadin.signals.impl.Effect;
import com.vaadin.signals.impl.Transaction;
import com.vaadin.signals.impl.UsageTracker;
import com.vaadin.signals.operations.TransactionOperation;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface Signal<T> {
    public T value();

    default public T peek() {
        return (T)Signal.untracked(() -> this.value());
    }

    default public <C> Signal<C> map(Function<T, C> mapper) {
        return () -> mapper.apply(this.value());
    }

    public static Runnable effect(Runnable action) {
        Effect effect = new Effect(Objects.requireNonNull(action));
        return effect::dispose;
    }

    public static <T> Signal<T> computed(Supplier<T> computation) {
        return new ComputedSignal<T>(computation);
    }

    public static Signal<Boolean> not(Signal<Boolean> signal) {
        return Objects.requireNonNull(signal).map(value -> value == null ? null : Boolean.valueOf(value == false));
    }

    public static <T> TransactionOperation<T> runInTransaction(Supplier<T> transactionTask) {
        return Transaction.runInTransaction(transactionTask);
    }

    public static TransactionOperation<Void> runInTransaction(Runnable transactionTask) {
        return Transaction.runInTransaction(transactionTask);
    }

    public static <T> T runWithoutTransaction(Supplier<T> task) {
        return Transaction.runWithoutTransaction(task);
    }

    public static void runWithoutTransaction(Runnable task) {
        Transaction.runWithoutTransaction(task);
    }

    public static <T> T untracked(Supplier<T> task) {
        return UsageTracker.untracked(task);
    }
}

