/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.AbstractSignal;
import com.vaadin.signals.Id;
import com.vaadin.signals.Node;
import com.vaadin.signals.NodeSignal;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.impl.SynchronousSignalTree;
import com.vaadin.signals.impl.Transaction;
import com.vaadin.signals.impl.TransientListener;
import com.vaadin.signals.impl.UsageTracker;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.POJONode;

public class ComputedSignal<T>
extends AbstractSignal<T> {
    private final Supplier<T> computation;
    private int dependentCount = 0;
    private Runnable dependencyRegistration;

    public ComputedSignal(Supplier<T> computation) {
        super(new SynchronousSignalTree(true), Id.ZERO, ANYTHING_GOES);
        this.computation = Objects.requireNonNull(computation);
    }

    private synchronized void revalidateAndListen() {
        if (this.dependencyRegistration != null) {
            this.dependencyRegistration.run();
        }
        ComputedState state = this.getValidState(this.data(Transaction.getCurrent()));
        this.dependencyRegistration = state.dependencies.onNextChange(immediate -> {
            this.revalidateAndListen();
            return false;
        });
    }

    private synchronized Runnable countActiveExternalListener() {
        if (this.dependentCount++ == 0) {
            this.revalidateAndListen();
        }
        AtomicBoolean removed = new AtomicBoolean();
        return () -> {
            if (!removed.getAndSet(true)) {
                ComputedSignal computedSignal = this;
                synchronized (computedSignal) {
                    if (--this.dependentCount == 0) {
                        this.dependencyRegistration.run();
                        this.dependencyRegistration = null;
                    }
                }
            }
        };
    }

    @Override
    protected UsageTracker.Usage createUsage(Transaction transaction) {
        final UsageTracker.Usage superUsage = super.createUsage(transaction);
        return new UsageTracker.Usage(){

            @Override
            public boolean hasChanges() {
                return superUsage.hasChanges();
            }

            @Override
            public Runnable onNextChange(TransientListener listener) {
                Runnable uncount = ComputedSignal.this.countActiveExternalListener();
                Runnable superCleanup = superUsage.onNextChange(immediate -> {
                    boolean listenToNext = listener.invoke(immediate);
                    if (!listenToNext) {
                        uncount.run();
                    }
                    return listenToNext;
                });
                return () -> {
                    superCleanup.run();
                    uncount.run();
                };
            }
        };
    }

    private ComputedState getValidState(Node.Data data) {
        ComputedState state = ComputedSignal.readState(data);
        if (state == null || state.dependencies.hasChanges()) {
            Object[] holder = new Object[2];
            UsageTracker.Usage dependencies = UsageTracker.track(() -> {
                try {
                    holder[0] = this.computation.get();
                }
                catch (RuntimeException e) {
                    holder[1] = e;
                }
            });
            Object value = holder[0];
            RuntimeException exception = (RuntimeException)holder[1];
            state = new ComputedState(value, exception, dependencies);
            this.submit(new SignalCommand.SetCommand(Id.random(), this.id(), (JsonNode)new POJONode((Object)state)));
        }
        return state;
    }

    private static ComputedState readState(Node.Data data) {
        if (data == null) {
            return null;
        }
        JsonNode value = data.value();
        if (value == null) {
            return null;
        }
        return ComputedSignal.extractState(value);
    }

    private static ComputedState extractState(JsonNode json) {
        POJONode pojoNode = (POJONode)json;
        return (ComputedState)pojoNode.getPojo();
    }

    @Override
    protected T extractValue(Node.Data data) {
        ComputedState state = this.getValidState(data);
        if (state.exception != null) {
            throw state.exception;
        }
        Object value = state.value;
        return (T)value;
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return ComputedSignal.extractState((JsonNode)data.value()).value;
    }

    @Override
    public T peekConfirmed() {
        throw new UnsupportedOperationException("Cannot peek a computed signal");
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException("Cannot peek a computed signal");
    }

    @Override
    public NodeSignal asNode() {
        throw new UnsupportedOperationException("Cannot use a computed signal as a node signal");
    }

    private record ComputedState(Object value, RuntimeException exception, UsageTracker.Usage dependencies) {
    }
}

