/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigInteger;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;

public record Id(long value) implements Comparable<Id>
{
    public static final Id ZERO;
    public static final Id EDGE;
    public static final Id MAX;
    private static final Base64.Encoder base64Encoder;

    public static Id random() {
        long value;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((value = random.nextLong()) == 0L || value == Long.MAX_VALUE) {
        }
        return new Id(value);
    }

    @JsonCreator
    public static Id parse(String base64) {
        if (base64.equals("")) {
            return ZERO;
        }
        byte[] bytes = Base64.getDecoder().decode(base64);
        return new Id(new BigInteger(bytes).longValue());
    }

    @JsonValue
    public final String asBase64() {
        if (this.value == 0L) {
            return "";
        }
        byte[] bytes = BigInteger.valueOf(this.value).toByteArray();
        return base64Encoder.encodeToString(bytes);
    }

    @Override
    public int compareTo(Id other) {
        return Long.compare(this.value, other.value);
    }

    static {
        EDGE = ZERO = new Id(0L);
        MAX = new Id(Long.MAX_VALUE);
        base64Encoder = Base64.getEncoder().withoutPadding();
    }
}

