/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.json.impl;

import com.vaadin.pro.licensechecker.json.LicenseCheckerJson;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonArray;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonException;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonObject;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonValue;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonContext;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LicenseCheckerJsonUtil {
    public static String escapeControlChars(String text) {
        StringBuilder toReturn = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (LicenseCheckerJsonUtil.isControlChar(c)) {
                toReturn.append(LicenseCheckerJsonUtil.escapeCharAsUnicode(c));
                continue;
            }
            toReturn.append(c);
        }
        return toReturn.toString();
    }

    public static <T extends LicenseCheckerJsonValue> T parse(String json) throws LicenseCheckerJsonException {
        return LicenseCheckerJson.instance().parse(json);
    }

    public static String quote(String value) {
        StringBuilder toReturn = new StringBuilder("\"");
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String toAppend = String.valueOf(c);
            switch (c) {
                case '\b': {
                    toAppend = "\\b";
                    break;
                }
                case '\t': {
                    toAppend = "\\t";
                    break;
                }
                case '\n': {
                    toAppend = "\\n";
                    break;
                }
                case '\f': {
                    toAppend = "\\f";
                    break;
                }
                case '\r': {
                    toAppend = "\\r";
                    break;
                }
                case '\"': {
                    toAppend = "\\\"";
                    break;
                }
                case '\\': {
                    toAppend = "\\\\";
                    break;
                }
                default: {
                    if (!LicenseCheckerJsonUtil.isControlChar(c)) break;
                    toAppend = LicenseCheckerJsonUtil.escapeCharAsUnicode(c);
                }
            }
            toReturn.append(toAppend);
        }
        toReturn.append("\"");
        return toReturn.toString();
    }

    public static String stringify(LicenseCheckerJsonValue jsonValue) {
        return LicenseCheckerJsonUtil.stringify(jsonValue, 0);
    }

    public static String stringify(LicenseCheckerJsonValue jsonValue, int spaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            sb.append(' ');
        }
        return LicenseCheckerJsonUtil.stringify(jsonValue, sb.toString());
    }

    public static String stringify(LicenseCheckerJsonValue jsonValue, String indent) {
        StringBuilder sb = new StringBuilder();
        boolean isPretty = indent != null && !"".equals(indent);
        new StringifyJsonVisitor(indent, sb, isPretty).accept(jsonValue);
        return sb.toString();
    }

    private static String escapeCharAsUnicode(char toEscape) {
        String hexValue = Integer.toString(toEscape, 16);
        int padding = 4 - hexValue.length();
        return "\\u" + "0000".substring(0, padding) + hexValue;
    }

    private static boolean isControlChar(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c == '\u00ad' || c == '\u070f' || c == '\u17b4' || c == '\u17b5' || c == '\ufeff' || c >= '\u0600' && c <= '\u0604' || c >= '\u200c' && c <= '\u200f' || c >= '\u2028' && c <= '\u202f' || c >= '\u2060' && c <= '\u206f' || c >= '\ufff0' && c <= '\uffff';
    }

    private static class StringifyJsonVisitor
    extends LicenseCheckerJsonVisitor {
        private static final Set<String> skipKeys;
        private String indentLevel;
        private Set<LicenseCheckerJsonValue> visited;
        private final String indent;
        private final StringBuilder sb;
        private final boolean pretty;

        public StringifyJsonVisitor(String indent, StringBuilder sb, boolean pretty) {
            this.indent = indent;
            this.sb = sb;
            this.pretty = pretty;
            this.indentLevel = "";
            this.visited = new HashSet<LicenseCheckerJsonValue>();
        }

        @Override
        public void endVisit(LicenseCheckerJsonArray array, LicenseCheckerJsonContext ctx) {
            if (this.pretty) {
                this.indentLevel = this.indentLevel.substring(0, this.indentLevel.length() - this.indent.length());
                this.sb.append('\n');
                this.sb.append(this.indentLevel);
            }
            this.sb.append("]");
            this.visited.remove(array);
        }

        @Override
        public void endVisit(LicenseCheckerJsonObject object, LicenseCheckerJsonContext ctx) {
            if (this.pretty) {
                this.indentLevel = this.indentLevel.substring(0, this.indentLevel.length() - this.indent.length());
                this.sb.append('\n');
                this.sb.append(this.indentLevel);
            }
            this.sb.append("}");
            this.visited.remove(object);
            assert (!this.visited.contains(object));
        }

        @Override
        public void visit(double number, LicenseCheckerJsonContext ctx) {
            this.sb.append(Double.isInfinite(number) || Double.isNaN(number) ? "null" : this.format(number));
        }

        @Override
        public void visit(String string, LicenseCheckerJsonContext ctx) {
            this.sb.append(LicenseCheckerJsonUtil.quote(string));
        }

        @Override
        public void visit(boolean bool, LicenseCheckerJsonContext ctx) {
            this.sb.append(bool);
        }

        @Override
        public boolean visit(LicenseCheckerJsonArray array, LicenseCheckerJsonContext ctx) {
            this.checkCycle(array);
            this.sb.append("[");
            if (this.pretty) {
                this.sb.append('\n');
                this.indentLevel = this.indentLevel + this.indent;
                this.sb.append(this.indentLevel);
            }
            return true;
        }

        @Override
        public boolean visit(LicenseCheckerJsonObject object, LicenseCheckerJsonContext ctx) {
            this.checkCycle(object);
            this.sb.append("{");
            if (this.pretty) {
                this.sb.append('\n');
                this.indentLevel = this.indentLevel + this.indent;
                this.sb.append(this.indentLevel);
            }
            return true;
        }

        @Override
        public boolean visitIndex(int index, LicenseCheckerJsonContext ctx) {
            this.commaIfNotFirst(ctx);
            return true;
        }

        @Override
        public boolean visitKey(String key, LicenseCheckerJsonContext ctx) {
            if ("".equals(key)) {
                return true;
            }
            if (skipKeys.contains(key)) {
                return false;
            }
            this.commaIfNotFirst(ctx);
            this.sb.append(LicenseCheckerJsonUtil.quote(key) + ":");
            if (this.pretty) {
                this.sb.append(' ');
            }
            return true;
        }

        @Override
        public void visitNull(LicenseCheckerJsonContext ctx) {
            this.sb.append("null");
        }

        private void checkCycle(LicenseCheckerJsonValue value) {
            if (this.visited.contains(value)) {
                throw new LicenseCheckerJsonException("Cycled detected during stringify");
            }
            this.visited.add(value);
        }

        private void commaIfNotFirst(LicenseCheckerJsonContext ctx) {
            if (!ctx.isFirst()) {
                this.sb.append(",");
                if (this.pretty) {
                    this.sb.append('\n');
                    this.sb.append(this.indentLevel);
                }
            }
        }

        private String format(double number) {
            String n = String.valueOf(number);
            if (n.endsWith(".0")) {
                n = n.substring(0, n.length() - 2);
            }
            return n;
        }

        static {
            HashSet<String> toSkip = new HashSet<String>();
            toSkip.add("$H");
            toSkip.add("__gwt_ObjectId");
            skipKeys = Collections.unmodifiableSet(toSkip);
        }
    }
}

