/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.open.Open;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.Capabilities;
import com.vaadin.pro.licensechecker.History;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalOfflineKey;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.LocalSubscriptionKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.MissingLicenseKeyException;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.OfflineKeyValidator;
import com.vaadin.pro.licensechecker.OnlineKeyValidator;
import com.vaadin.pro.licensechecker.PreTrial;
import com.vaadin.pro.licensechecker.PreTrialCreationException;
import com.vaadin.pro.licensechecker.PreTrialValidator;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.SubscriptionKey;
import com.vaadin.pro.licensechecker.UserKey;
import com.vaadin.pro.licensechecker.VaadinComIntegration;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseChecker {
    static final int DEFAULT_KEY_URL_HANDLER_TIMEOUT_SECONDS = 60;
    private static boolean strictOffline = false;
    static String loggedLicenseOwner = null;
    static Consumer<String> systemBrowserUrlHandler = url -> {
        try {
            LicenseChecker.getLogger().info("Opening system browser to validate license. If the browser is not opened, please open " + url + " manually");
            Open.open((String)url);
            LicenseChecker.getLogger().info("For CI/CD build servers, you need to download a server license key, which can only be used for production builds. You can download a server license key from https://vaadin.com/myaccount/licenses.\nIf you are working offline in development mode, please visit " + OfflineKeyValidator.getOfflineUrl(MachineId.get()) + " for an offline development mode license.");
        }
        catch (Exception e) {
            LicenseChecker.getLogger().error("Error opening system browser to validate license. Please open " + url + " manually", (Throwable)e);
        }
    };

    @Deprecated
    public static void checkLicenseFromStaticBlock(String productName, String productVersion) {
        LicenseChecker.checkLicenseFromStaticBlock(productName, productVersion, BuildType.DEVELOPMENT);
    }

    public static void checkLicenseFromStaticBlock(String productName, String productVersion, BuildType buildType) {
        try {
            LicenseChecker.checkLicense(productName, productVersion, buildType);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Deprecated
    public static void checkLicense(String productName, String productVersion) {
        LicenseChecker.checkLicense(productName, productVersion, BuildType.DEVELOPMENT, systemBrowserUrlHandler);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType) {
        LicenseChecker.checkLicense(productName, productVersion, Capabilities.none(), buildType);
    }

    public static void checkLicense(String productName, String productVersion, Capabilities capabilities, BuildType buildType) {
        LicenseChecker.checkLicense(productName, productVersion, buildType, systemBrowserUrlHandler, capabilities);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType, Consumer<String> noKeyUrlHandler, String machineId, ProKey proKey, SubscriptionKey subscriptionKey, OfflineKey offlineKey) {
        LicenseChecker.checkLicense(new Product(productName, productVersion), buildType, noKeyUrlHandler, machineId, proKey, subscriptionKey, offlineKey, new OnlineKeyValidator(), new OfflineKeyValidator(), null, new VaadinComIntegration(), 60, Capabilities.none());
    }

    @Deprecated
    public static void checkLicense(String productName, String productVersion, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.checkLicense(productName, productVersion, BuildType.DEVELOPMENT, noKeyUrlHandler);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.checkLicense(productName, productVersion, buildType, noKeyUrlHandler, Capabilities.none());
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType, Consumer<String> noKeyUrlHandler, Capabilities capabilities) {
        LicenseChecker.checkLicense(productName, productVersion, buildType, noKeyUrlHandler, 60, capabilities);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType, Consumer<String> noKeyUrlHandler, int timeoutKeyUrlHandler) {
        LicenseChecker.checkLicense(productName, productVersion, buildType, noKeyUrlHandler, timeoutKeyUrlHandler, Capabilities.none());
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType, Consumer<String> noKeyUrlHandler, int timeoutKeyUrlHandler, Capabilities capabilities) {
        LicenseChecker.checkLicense(new Product(productName, productVersion), buildType, noKeyUrlHandler, timeoutKeyUrlHandler, capabilities);
    }

    public static boolean isValidLicense(String productName, String productVersion, BuildType buildType) {
        try {
            LicenseChecker.checkLicense(productName, productVersion, buildType, (Consumer<String>)null);
            return true;
        }
        catch (LicenseException e) {
            return false;
        }
    }

    @Deprecated
    public static void checkLicenseAsync(String productName, String productVersion, Callback callback) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, BuildType.DEVELOPMENT, callback);
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, buildType, callback, Capabilities.none());
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Capabilities capabilities) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, buildType, callback, systemBrowserUrlHandler, capabilities);
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler, String machineId, ProKey proKey, SubscriptionKey subscriptionKey, OfflineKey offlineKey) {
        LicenseChecker.checkLicenseAsync(new Product(productName, productVersion), buildType, callback, noKeyUrlHandler, machineId, proKey, subscriptionKey, offlineKey, new OnlineKeyValidator(), new OfflineKeyValidator(), null, new VaadinComIntegration(), 60);
    }

    @Deprecated
    public static void checkLicenseAsync(String productName, String productVersion, Callback callback, Consumer<String> noKeyUrlHandler) {
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, buildType, callback, noKeyUrlHandler, Capabilities.none());
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler, Capabilities capabilities) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, buildType, callback, noKeyUrlHandler, 60, capabilities);
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler, int timeoutKeyUrlHandler, Capabilities capabilities) {
        LicenseChecker.checkLicenseAsync(new Product(productName, productVersion), buildType, callback, noKeyUrlHandler, MachineId.get(), LocalProKey.get(), LocalSubscriptionKey.get(), LocalOfflineKey.get(), new OnlineKeyValidator(), new OfflineKeyValidator(), capabilities.getPreTrialValidator().orElse(null), new VaadinComIntegration(), timeoutKeyUrlHandler);
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler, int timeoutKeyUrlHandler) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, buildType, callback, noKeyUrlHandler, timeoutKeyUrlHandler, Capabilities.none());
    }

    static void checkLicenseAsync(Product product, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler, String machineId, ProKey proKey, SubscriptionKey subscriptionKey, OfflineKey offlineKey, OnlineKeyValidator proKeyValidator, OfflineKeyValidator offlineKeyValidator, PreTrialValidator preTrialValidator, VaadinComIntegration vaadinComIntegration, int timeoutKeyUrlHandler) {
        new Thread(() -> {
            try {
                LicenseChecker.checkLicense(product, buildType, noKeyUrlHandler, machineId, proKey, subscriptionKey, offlineKey, proKeyValidator, offlineKeyValidator, preTrialValidator, vaadinComIntegration, timeoutKeyUrlHandler, Capabilities.none());
                callback.ok();
            }
            catch (Exception e) {
                callback.failed(e);
            }
        }).start();
    }

    static void checkLicense(Product product, BuildType buildType, Consumer<String> noKeyUrlHandler, int timeoutKeyUrlHandler, Capabilities capabilities) {
        LicenseChecker.getLogger().debug("Checking license for " + product);
        LicenseChecker.checkLicense(product, buildType, noKeyUrlHandler, MachineId.get(), LocalProKey.get(), LocalSubscriptionKey.get(), LocalOfflineKey.get(), new OnlineKeyValidator(), new OfflineKeyValidator(), capabilities.getPreTrialValidator().orElse(null), new VaadinComIntegration(), timeoutKeyUrlHandler, capabilities);
    }

    public static PreTrial startPreTrial() throws PreTrialCreationException {
        return LicenseChecker.startPreTrial(MachineId.get(), UserKey.get(), new PreTrialValidator());
    }

    public static Optional<PreTrial> checkPreTrial(Product product) {
        UserKey userKey = UserKey.get();
        return new PreTrialValidator().check(product, MachineId.get(), userKey != null ? userKey.getKey() : null);
    }

    static void checkLicense(Product product, BuildType buildType, Consumer<String> noKeyUrlHandler, String machineId, ProKey proKey, SubscriptionKey subscriptionKey, OfflineKey offlineKey, OnlineKeyValidator proKeyValidator, OfflineKeyValidator offlineKeyValidator, PreTrialValidator preTrialValidator, VaadinComIntegration vaadinComIntegration, int timeoutKeyUrlHandler, Capabilities capabilities) {
        OnlineKeyValidator.Result onlineCheckResult;
        if (subscriptionKey == null && offlineKey != null && offlineKey.getSubscriptionKey() != null) {
            subscriptionKey = new SubscriptionKey(offlineKey.getSubscriptionKey());
        }
        if ((onlineCheckResult = proKeyValidator.validate(product, subscriptionKey, buildType, noKeyUrlHandler == null)) == OnlineKeyValidator.Result.OK) {
            return;
        }
        if (subscriptionKey != null) {
            if (onlineCheckResult == OnlineKeyValidator.Result.CANNOT_REACH_SERVER) {
                if (offlineKey != null && offlineKey.getSubscriptionKey() != null && offlineKeyValidator.validate(null, null, offlineKey, machineId)) {
                    return;
                }
                if (LicenseChecker.canWorkOffline(product, buildType, machineId, new ProKey(null, subscriptionKey.getKey()))) {
                    return;
                }
            }
            throw new LicenseException("The provided license subscription key does not allow usage of " + product.getName() + " " + product.getVersion() + ". Check that the license has not expired.");
        }
        onlineCheckResult = proKeyValidator.validate(product, proKey, machineId, buildType, noKeyUrlHandler == null);
        if (onlineCheckResult == OnlineKeyValidator.Result.OK) {
            return;
        }
        if (onlineCheckResult == OnlineKeyValidator.Result.NO_ACCESS && proKey != null) {
            throw new LicenseException("The provided license key does not allow usage of " + product.getName() + " " + product.getVersion() + ". Check that the license has not expired and that the product you are trying to use does not require another type of subscription.");
        }
        if (offlineKeyValidator.validate(product, buildType, offlineKey, machineId)) {
            if (loggedLicenseOwner == null && offlineKey.getName() != null) {
                LocalDateTime expires = LocalDateTime.ofEpochSecond(offlineKey.getExpires() / 1000L, 0, ZoneOffset.UTC);
                long expiresInDays = Duration.between(LocalDateTime.now(), expires).toDays();
                loggedLicenseOwner = "Using offline license registered to " + offlineKey.getName() + " / " + offlineKey.getAccount() + ". Expires in " + expiresInDays + " days.";
                LicenseChecker.getLogger().info(loggedLicenseOwner);
            }
            return;
        }
        if (onlineCheckResult == OnlineKeyValidator.Result.CANNOT_REACH_SERVER && (proKey != null || machineId == null) && LicenseChecker.canWorkOffline(product, buildType, machineId, proKey)) {
            return;
        }
        if (preTrialValidator != null && proKey == null && offlineKey == null && machineId != null && BuildType.PRODUCTION != buildType) {
            PreTrialValidator.Result preTrialResult = preTrialValidator.validate(product, machineId, noKeyUrlHandler == null);
            PreTrialValidator.Access access = preTrialResult.verifyAccess(noKeyUrlHandler != null);
            if (access == PreTrialValidator.Access.OK) {
                LicenseChecker.getLogger().debug("Pre-trial active for {}", (Object)product);
                return;
            }
            if (access == PreTrialValidator.Access.CANNOT_REACH_SERVER && LicenseChecker.canWorkOfflineWithPreTrial(product, machineId)) {
                return;
            }
        }
        if (proKey == null) {
            if (noKeyUrlHandler != null) {
                proKey = vaadinComIntegration.openBrowserAndWaitForKey(product, noKeyUrlHandler, timeoutKeyUrlHandler);
                if (proKey != null) {
                    LocalProKey.write(proKey);
                    if (proKeyValidator.validate(product, proKey, machineId, buildType, false) == OnlineKeyValidator.Result.OK) {
                        return;
                    }
                }
            } else if (BuildType.PRODUCTION == buildType) {
                throw new MissingLicenseKeyException(product, "If you have an active subscription, please download the license key from https://vaadin.com/myaccount/licenses. Otherwise go to https://vaadin.com/pricing to obtain a license.");
            }
        }
        throw new LicenseException("Unable to validate the license, please check your internet connection. If you need to work offline then " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId));
    }

    private static boolean canWorkOffline(Product product, BuildType buildType, String machineId, ProKey proKey) {
        return LicenseChecker.canWorkOffline(() -> History.isRecentlyValidated(product, Period.ofDays(2), buildType, proKey), machineId, strictOffline);
    }

    private static boolean canWorkOfflineWithPreTrial(Product product, String machineId) {
        return LicenseChecker.canWorkOffline(() -> History.isPreTrialRecentlyValidated(product, machineId), machineId, true);
    }

    private static boolean canWorkOffline(BooleanSupplier recentlyValidatedTest, String machineId, boolean enforceStrictOffline) {
        boolean recentlyValidated = recentlyValidatedTest.getAsBoolean();
        if (!recentlyValidated && enforceStrictOffline) {
            throw new LicenseException(OfflineKeyValidator.getMissingOfflineKeyMessage(machineId));
        }
        if (!recentlyValidated) {
            LicenseChecker.getLogger().warn("Unable to validate the license, please check your internet connection");
        }
        return true;
    }

    static PreTrial startPreTrial(String machineId, UserKey userKey, PreTrialValidator preTrialValidator) {
        return preTrialValidator.create(machineId, userKey != null ? userKey.getKey() : null);
    }

    static Logger getLogger() {
        return LoggerFactory.getLogger(LicenseChecker.class);
    }

    public static void setStrictOffline(boolean strictOffline) {
        LicenseChecker.strictOffline = strictOffline;
    }

    public static interface Callback {
        public void ok();

        public void failed(Exception var1);
    }
}

