/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.History;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.Util;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProKeyValidator {
    private static final String UNABLE_TO_VALIDATE_SUBSCRIPTION = "Unable to validate subscription. Please go to https://vaadin.com/pro/validate-license to check that your subscription is active. You can also find instructions for installing the license on a build server at https://vaadin.com/pro/validate-license";
    private static final String LICENSE_VALIDATION_URL = "https://tools.vaadin.com/vaadin-license-server/licenses/pro";
    private static final String[] PROPERTIES = new String[]{"java.vendor", "java.version", "os.arch", "os.name", "os.version"};

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    public static void validate(Product product, ProKey proKey) {
        if (proKey == null) {
            ProKeyValidator.getLogger().fine("No pro key found to validate");
            throw new RuntimeException(UNABLE_TO_VALIDATE_SUBSCRIPTION);
        }
        ProKeyValidator.getLogger().fine("Validating pro key for " + product);
        if (History.isRecentlyValidated(product)) {
            ProKeyValidator.getLogger().fine("Skipping check as product license was recently validated.");
            return;
        }
        try {
            if (ProKeyValidator.validateWithServer(product, proKey)) {
                History.setLastCheckTimeNow(product);
                return;
            }
        }
        catch (ConnectException | UnknownHostException e) {
            ProKeyValidator.getLogger().log(Level.INFO, "Unable to validate the license, please check your internet connection");
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(UNABLE_TO_VALIDATE_SUBSCRIPTION, e);
        }
        throw new RuntimeException(UNABLE_TO_VALIDATE_SUBSCRIPTION);
    }

    private static boolean validateWithServer(Product product, ProKey proKey) throws IOException {
        ProKeyValidator.getLogger().fine("Validating license for " + product + " with server");
        JsonObject json = ProKeyValidator.queryServer(product, proKey);
        String result = json.getString("result");
        String message = json.getString("message");
        if (message != null && !message.isEmpty()) {
            ProKeyValidator.getLogger().info(message);
        }
        return "ok".equals(result);
    }

    private static JsonObject queryServer(Product product, ProKey proKey) throws IOException {
        URL url = new URL(LICENSE_VALIDATION_URL);
        URLConnection http = url.openConnection();
        http.setRequestProperty("check-source", "java");
        http.setRequestProperty("product-name", product.getName());
        http.setRequestProperty("product-version", product.getVersion());
        for (String property : PROPERTIES) {
            String value = System.getProperty(property);
            if (value == null) continue;
            http.setRequestProperty("prop-" + property.replace(".", "-"), value);
        }
        http.setRequestProperty("product-version", product.getVersion());
        http.setRequestProperty("Cookie", "proKey=" + proKey.getProKey());
        http.connect();
        try (InputStream in = http.getInputStream();){
            String response = Util.toString(in);
            JsonObject jsonObject = Json.parse((String)response);
            return jsonObject;
        }
    }
}

