/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.jackson;

import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.module.SimpleModule;

public class ByteArrayModule
extends SimpleModule {
    public ByteArrayModule() {
        this.addSerializer(byte[].class, new ByteArraySerializer());
        this.addDeserializer(byte[].class, new ByteArrayDeSerializer());
    }

    private static class ByteArraySerializer
    extends ValueSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        public void serialize(byte[] value, JsonGenerator jgen, SerializationContext provider) {
            int[] arr = new int[value.length];
            for (int i = 0; i < value.length; ++i) {
                arr[i] = value[i];
            }
            jgen.writeArray(arr, 0, arr.length);
        }
    }

    private static class ByteArrayDeSerializer
    extends ValueDeserializer<byte[]> {
        private ByteArrayDeSerializer() {
        }

        public byte[] deserialize(JsonParser jp, DeserializationContext ctxt) {
            return (byte[])new ObjectMapper().readValue(jp.readValueAsTree().toString(), byte[].class);
        }
    }
}

