/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import tools.jackson.core.JacksonException;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.util.DefaultIndenter;
import tools.jackson.core.util.DefaultPrettyPrinter;

public final class JsonPrinter {
    private final tools.jackson.databind.ObjectMapper mapper = new tools.jackson.databind.ObjectMapper();
    private final ObjectMapper jacksonV2Mapper = Json.mapper();
    private final Pretty pretty;

    public JsonPrinter() {
        this.jacksonV2Mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.jacksonV2Mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, false);
        this.jacksonV2Mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, false);
        this.pretty = new Pretty(this);
    }

    public Pretty pretty() {
        return this.pretty;
    }

    public String writeAsString(Object value) throws JacksonException {
        if (value instanceof OpenAPI) {
            try {
                return this.jacksonV2Mapper.writeValueAsString(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to serialize OpenAPI object", e);
            }
        }
        return this.mapper.writeValueAsString(value);
    }

    public final class Pretty {
        private final tools.jackson.databind.ObjectWriter writer;
        private final ObjectWriter jacksonV2Writer;

        private Pretty(JsonPrinter this$0) {
            DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
            DefaultIndenter indenter = new DefaultIndenter("  ", "\n");
            printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
            printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
            this.writer = this$0.mapper.writer().with((PrettyPrinter)printer);
            com.fasterxml.jackson.core.util.DefaultPrettyPrinter j2Printer = new com.fasterxml.jackson.core.util.DefaultPrettyPrinter();
            com.fasterxml.jackson.core.util.DefaultIndenter j2Indenter = new com.fasterxml.jackson.core.util.DefaultIndenter("  ", "\n");
            j2Printer.indentArraysWith((DefaultPrettyPrinter.Indenter)j2Indenter);
            j2Printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)j2Indenter);
            this.jacksonV2Writer = this$0.jacksonV2Mapper.writer().with((com.fasterxml.jackson.core.PrettyPrinter)j2Printer);
        }

        public String writeAsString(Object value) throws JacksonException {
            if (value instanceof OpenAPI) {
                try {
                    return this.jacksonV2Writer.writeValueAsString(value);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to serialize OpenAPI object", e);
                }
            }
            return this.writer.writeValueAsString(value);
        }
    }
}

