/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.model;

import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.Plugin;
import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.models.AnnotatedModel;
import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.AnnotationParameterModel;
import com.vaadin.hilla.parser.models.ArraySignatureModel;
import com.vaadin.hilla.parser.models.BaseSignatureModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.NamedModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.models.jackson.JacksonPropertyModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePlugin;
import com.vaadin.hilla.parser.plugins.backbone.nodes.AnnotatedNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.PropertyNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import com.vaadin.hilla.parser.plugins.model.Annotation;
import com.vaadin.hilla.parser.plugins.model.ValidationConstraint;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.AnnotatedArrayType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public final class ModelPlugin
extends AbstractPlugin<PluginConfiguration> {
    private static final String VALIDATION_CONSTRAINTS_KEY = "x-validation-constraints";
    private static final String ANNOTATIONS_KEY = "x-annotations";
    private static final String JAVA_TYPE_KEY = "x-java-type";
    private static final String VALIDATION_CONSTRAINTS_PACKAGE_NAME = "jakarta.validation.constraints";
    private static final Set<String> INCLUDED_ANNOTATIONS = Set.of("jakarta.persistence.Id", "jakarta.persistence.Version", "jakarta.persistence.OneToOne", "jakarta.persistence.ManyToOne", "jakarta.persistence.OneToMany", "jakarta.persistence.ManyToMany");

    private static ValidationConstraint convertValidationConstraintAnnotation(AnnotationInfoModel annotation) {
        String simpleName = ModelPlugin.extractSimpleName(annotation.getName());
        Map<String, Object> attributes = annotation.getParameters().stream().filter(Predicate.not(AnnotationParameterModel::isDefault)).collect(Collectors.toMap(NamedModel::getName, AnnotationParameterModel::getValue));
        return new ValidationConstraint(simpleName, !attributes.isEmpty() ? attributes : null);
    }

    private static Annotation convertAnnotation(AnnotationInfoModel annotation) {
        return new Annotation(annotation.getName(), null);
    }

    private static String extractSimpleName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(".") + 1);
    }

    private static boolean isValidationConstraintAnnotation(AnnotationInfoModel annotation) {
        return annotation.getName().startsWith(VALIDATION_CONSTRAINTS_PACKAGE_NAME);
    }

    private static boolean isIncludedAnnotation(AnnotationInfoModel annotation) {
        return INCLUDED_ANNOTATIONS.contains(annotation.getName());
    }

    public void enter(NodePath<?> nodePath) {
        Node node;
        Node node2 = nodePath.getNode();
        if (!(node2 instanceof TypedNode)) {
            return;
        }
        TypedNode typedNode = (TypedNode)node2;
        SignatureModel signature = typedNode.getType();
        if (signature.isTypeArgument() || signature.isTypeParameter()) {
            return;
        }
        Schema schema = typedNode.getTarget();
        this.addConstraintsToSchema((AnnotatedNode)typedNode, schema);
        this.addJavaTypeToSchema(typedNode, schema);
        if (nodePath.getParentPath() != null && (node = nodePath.getParentPath().getNode()) instanceof PropertyNode) {
            PropertyNode propertyNode = (PropertyNode)node;
            JacksonPropertyModel propertyModel = (JacksonPropertyModel)propertyNode.getSource();
            this.addAnnotationsToSchema((AnnotatedModel)propertyModel, schema);
        }
    }

    public void exit(NodePath<?> nodePath) {
    }

    public Collection<Class<? extends Plugin>> getRequiredPlugins() {
        return List.of(BackbonePlugin.class);
    }

    public @NonNull NodeDependencies scan(@NonNull NodeDependencies nodeDependencies) {
        return nodeDependencies;
    }

    private void addConstraintsToSchema(AnnotatedNode annotatedNode, Schema<?> schema) {
        List constraints = annotatedNode.getAnnotations().stream().filter(ModelPlugin::isValidationConstraintAnnotation).map(ModelPlugin::convertValidationConstraintAnnotation).collect(Collectors.toList());
        if (!constraints.isEmpty()) {
            schema.addExtension(VALIDATION_CONSTRAINTS_KEY, constraints);
        }
    }

    private void addAnnotationsToSchema(AnnotatedModel annotatedModel, Schema<?> schema) {
        List annotations = annotatedModel.getAnnotations().stream().filter(ModelPlugin::isIncludedAnnotation).map(ModelPlugin::convertAnnotation).collect(Collectors.toList());
        if (!annotations.isEmpty()) {
            schema.addExtension(ANNOTATIONS_KEY, annotations);
        }
    }

    private void addJavaTypeToSchema(TypedNode typedNode, Schema<?> schema) {
        SignatureModel signature = typedNode.getType();
        String typeName = null;
        if (signature instanceof BaseSignatureModel) {
            BaseSignatureModel baseSignatureModel = (BaseSignatureModel)signature;
            typeName = baseSignatureModel.getType().getName();
        } else if (signature instanceof ClassRefSignatureModel) {
            ClassRefSignatureModel classRefSignatureModel = (ClassRefSignatureModel)signature;
            typeName = classRefSignatureModel.getName();
        } else if (signature instanceof ArraySignatureModel) {
            ArraySignatureModel arraySignatureModel = (ArraySignatureModel)signature;
            AnnotatedArrayType o = (AnnotatedArrayType)arraySignatureModel.get();
            typeName = o.toString();
        }
        if (this.includeJavaType(typeName)) {
            schema.addExtension(JAVA_TYPE_KEY, (Object)typeName);
        }
    }

    private boolean includeJavaType(String typeName) {
        if (typeName == null) {
            return false;
        }
        if (typeName.endsWith("[]")) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if (typeName.equals("boolean") || typeName.equals("byte") || typeName.equals("char") || typeName.equals("double") || typeName.equals("float") || typeName.equals("int") || typeName.equals("long") || typeName.equals("short")) {
            return true;
        }
        return typeName.startsWith("java.");
    }
}

