/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone;

import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.Parser;
import com.vaadin.hilla.parser.core.RootNode;
import com.vaadin.hilla.parser.core.ScanResult;
import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.MethodInfoModel;
import com.vaadin.hilla.parser.models.SpecializedModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EndpointNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);

    private static void checkIfJavaCompilerParametersFlagIsEnabled(Collection<ClassInfoModel> endpoints) {
        endpoints.stream().map(ClassInfoModel::getMethods).flatMap(Collection::stream).map(MethodInfoModel::getParameters).flatMap(Collection::stream).findFirst().ifPresent(parameter -> {
            if (parameter.getName() == null) {
                logger.info("Missing endpoint method parameter names in JVM bytecode, probably because they were not enabled during compilation. For the Java compiler, set the \"parameters\" flag to true to enable them.");
            }
        });
    }

    public void enter(NodePath<?> nodePath) {
        if (nodePath.getNode() instanceof EndpointNode) {
            EndpointNode endpointNode = (EndpointNode)nodePath.getNode();
            String name = this.getEndpointName((ClassInfoModel)endpointNode.getSource());
            endpointNode.setTarget(new Tag().name(name));
        }
    }

    public void exit(NodePath<?> nodePath) {
        Node node = nodePath.getNode();
        Node parentNode = nodePath.getParentPath().getNode();
        if (node instanceof EndpointNode && parentNode instanceof RootNode) {
            ((OpenAPI)((RootNode)parentNode).getTarget()).addTagsItem((Tag)((EndpointNode)node).getTarget());
        }
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        if (nodeDependencies.getNode() instanceof RootNode) {
            RootNode rootNode = (RootNode)nodeDependencies.getNode();
            String endpointAnnotationName = this.getStorage().getParserConfig().getEndpointAnnotationName();
            List<ClassInfoModel> endpoints = ((ScanResult)rootNode.getSource()).getClassesWithAnnotation(new String[]{endpointAnnotationName, "com.vaadin.hilla.BrowserCallable"}).stream().map(ClassInfoModel::of).toList();
            EndpointPlugin.checkIfJavaCompilerParametersFlagIsEnabled(endpoints);
            return nodeDependencies.appendChildNodes(endpoints.stream().filter(SpecializedModel::isNonJDKClass).map(EndpointNode::of));
        }
        return nodeDependencies;
    }

    private String getEndpointName(ClassInfoModel endpointCls) {
        String endpointAnnotationName = this.getStorage().getParserConfig().getEndpointAnnotationName();
        Optional<AnnotationInfoModel> endpointAnnotation = endpointCls.getAnnotations().stream().filter(annotation -> annotation.getName().equals(endpointAnnotationName)).findFirst();
        return endpointAnnotation.flatMap(this::getEndpointAnnotationValue).filter(name -> !name.isEmpty()).orElseGet(() -> ((ClassInfoModel)endpointCls).getSimpleName());
    }

    private Optional<String> getEndpointAnnotationValue(AnnotationInfoModel endpointAnnotation) {
        return endpointAnnotation.getParameters().stream().filter(param -> param.getName().equals("value")).findFirst().map(param -> (String)param.getValue());
    }
}

