/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.core;

import com.vaadin.hilla.parser.core.Node;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

public final class NodeDependencies {
    private final Stream<Node<?, ?>> childNodes;
    private final Node<?, ?> node;
    private final Stream<Node<?, ?>> relatedNodes;

    NodeDependencies(@NonNull Node<?, ?> node, @NonNull Stream<Node<?, ?>> childNodes, @NonNull Stream<Node<?, ?>> relatedNodes) {
        this.node = Objects.requireNonNull(node);
        this.childNodes = Objects.requireNonNull(childNodes);
        this.relatedNodes = Objects.requireNonNull(relatedNodes);
    }

    public @NonNull NodeDependencies appendChildNodes(@NonNull Stream<Node<?, ?>> childNodesToAppend) {
        return this.withChildNodes(Stream.concat(this.getChildNodes(), childNodesToAppend));
    }

    public @NonNull NodeDependencies appendRelatedNodes(@NonNull Stream<Node<?, ?>> relatedNodesToAppend) {
        return this.withRelatedNodes(Stream.concat(this.getRelatedNodes(), relatedNodesToAppend));
    }

    public Stream<Node<?, ?>> getChildNodes() {
        return this.childNodes;
    }

    public Node<?, ?> getNode() {
        return this.node;
    }

    public Stream<Node<?, ?>> getRelatedNodes() {
        return this.relatedNodes;
    }

    public @NonNull NodeDependencies prependChildNodes(@NonNull Stream<Node<?, ?>> childNodesToPrepend) {
        return this.withChildNodes(Stream.concat(childNodesToPrepend, this.getChildNodes()));
    }

    public @NonNull NodeDependencies prependRelatedNodes(@NonNull Stream<Node<?, ?>> relatedNodesToPrepend) {
        return this.withRelatedNodes(Stream.concat(relatedNodesToPrepend, this.getRelatedNodes()));
    }

    public @NonNull NodeDependencies processChildNodes(@NonNull UnaryOperator<Stream<Node<?, ?>>> childNodesProcessor) {
        return new NodeDependencies(this.getNode(), (Stream)childNodesProcessor.apply(this.getChildNodes()), this.getRelatedNodes());
    }

    public @NonNull NodeDependencies processRelatedNodes(@NonNull UnaryOperator<Stream<Node<?, ?>>> relatedNodesProcessor) {
        return new NodeDependencies(this.getNode(), this.getChildNodes(), (Stream)relatedNodesProcessor.apply(this.getRelatedNodes()));
    }

    private @NonNull NodeDependencies withChildNodes(@NonNull Stream<Node<?, ?>> childNodes) {
        return new NodeDependencies(this.getNode(), childNodes, this.getRelatedNodes());
    }

    private @NonNull NodeDependencies withRelatedNodes(@NonNull Stream<Node<?, ?>> relatedNodes) {
        return new NodeDependencies(this.getNode(), this.getChildNodes(), relatedNodes);
    }
}

