/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.core;

import com.vaadin.hilla.parser.core.Node;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class NodeDependencies {
    private final Stream<Node<?, ?>> childNodes;
    private final Node<?, ?> node;
    private final Stream<Node<?, ?>> relatedNodes;

    NodeDependencies(@Nonnull Node<?, ?> node, @Nonnull Stream<Node<?, ?>> childNodes, @Nonnull Stream<Node<?, ?>> relatedNodes) {
        this.node = Objects.requireNonNull(node);
        this.childNodes = Objects.requireNonNull(childNodes);
        this.relatedNodes = Objects.requireNonNull(relatedNodes);
    }

    @Nonnull
    public NodeDependencies appendChildNodes(@Nonnull Stream<Node<?, ?>> childNodesToAppend) {
        return this.withChildNodes(Stream.concat(this.getChildNodes(), childNodesToAppend));
    }

    @Nonnull
    public NodeDependencies appendRelatedNodes(@Nonnull Stream<Node<?, ?>> relatedNodesToAppend) {
        return this.withRelatedNodes(Stream.concat(this.getRelatedNodes(), relatedNodesToAppend));
    }

    public Stream<Node<?, ?>> getChildNodes() {
        return this.childNodes;
    }

    public Node<?, ?> getNode() {
        return this.node;
    }

    public Stream<Node<?, ?>> getRelatedNodes() {
        return this.relatedNodes;
    }

    @Nonnull
    public NodeDependencies prependChildNodes(@Nonnull Stream<Node<?, ?>> childNodesToPrepend) {
        return this.withChildNodes(Stream.concat(childNodesToPrepend, this.getChildNodes()));
    }

    @Nonnull
    public NodeDependencies prependRelatedNodes(@Nonnull Stream<Node<?, ?>> relatedNodesToPrepend) {
        return this.withRelatedNodes(Stream.concat(relatedNodesToPrepend, this.getRelatedNodes()));
    }

    @Nonnull
    public NodeDependencies processChildNodes(@Nonnull UnaryOperator<Stream<Node<?, ?>>> childNodesProcessor) {
        return new NodeDependencies(this.getNode(), (Stream)childNodesProcessor.apply(this.getChildNodes()), this.getRelatedNodes());
    }

    @Nonnull
    public NodeDependencies processRelatedNodes(@Nonnull UnaryOperator<Stream<Node<?, ?>>> relatedNodesProcessor) {
        return new NodeDependencies(this.getNode(), this.getChildNodes(), (Stream)relatedNodesProcessor.apply(this.getRelatedNodes()));
    }

    @Nonnull
    private NodeDependencies withChildNodes(@Nonnull Stream<Node<?, ?>> childNodes) {
        return new NodeDependencies(this.getNode(), childNodes, this.getRelatedNodes());
    }

    @Nonnull
    private NodeDependencies withRelatedNodes(@Nonnull Stream<Node<?, ?>> relatedNodes) {
        return new NodeDependencies(this.getNode(), this.getChildNodes(), relatedNodes);
    }
}

