/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.maven;

import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.hilla.engine.EngineAutoConfiguration;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

interface Configurable {
    public Map getPluginContext();

    public File getFrontend();

    public File getGenerated();

    public String getNode();

    public String getMainClass();

    default public EngineAutoConfiguration configure() {
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        boolean isProduction = project.getActiveProfiles().stream().map(Profile::getId).anyMatch("production"::equals);
        String mainClass = this.getMainClass();
        if (mainClass == null) {
            mainClass = Configurable.getPluginConfigurationProperty(project, "org.springframework.boot", "spring-boot-maven-plugin", "mainClass");
        }
        EngineAutoConfiguration conf = new EngineAutoConfiguration.Builder().baseDir(project.getBasedir().toPath()).buildDir(project.getBuild().getDirectory()).outputDir(this.generatedOrOldLocation().toPath()).groupId(project.getGroupId()).artifactId(project.getArtifactId()).classpath((Collection)FlowModeAbstractMojo.getClasspathElements((MavenProject)project)).withDefaultAnnotations().mainClass(mainClass).nodeCommand(this.getNode()).productionMode(isProduction).build();
        EngineAutoConfiguration.setDefault((EngineAutoConfiguration)conf);
        return conf;
    }

    private File generatedOrOldLocation() {
        if (this.getGenerated() != null) {
            return this.getGenerated();
        }
        return new File(this.getFrontend(), "generated/");
    }

    public static String getPluginConfigurationProperty(MavenProject project, String pluginGroupId, String pluginArtifactId, String propertyName) {
        for (Plugin plugin : project.getBuild().getPlugins()) {
            Object configuration;
            if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId()) || !((configuration = plugin.getConfiguration()) instanceof Xpp3Dom)) continue;
            Xpp3Dom configDom = (Xpp3Dom)configuration;
            Xpp3Dom propertyNode = configDom.getChild(propertyName);
            return Optional.ofNullable(propertyNode).map(Xpp3Dom::getValue).filter(v -> v.indexOf(123) < 0).orElse(null);
        }
        return null;
    }
}

