/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.internal;

import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import com.vaadin.hilla.ApplicationContextProvider;
import com.vaadin.hilla.EndpointCodeGenerator;
import com.vaadin.hilla.engine.EngineAutoConfiguration;
import com.vaadin.hilla.engine.ParserProcessor;
import com.vaadin.hilla.internal.AbstractTaskEndpointGenerator;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class TaskGenerateOpenAPIImpl
extends AbstractTaskEndpointGenerator
implements TaskGenerateOpenAPI {
    TaskGenerateOpenAPIImpl(EngineAutoConfiguration engineConfiguration) {
        super(engineConfiguration);
    }

    public void execute() throws ExecutionFailedException {
        EngineAutoConfiguration engineConfiguration = this.getEngineConfiguration();
        if (engineConfiguration.isProductionMode()) {
            try {
                List browserCallables = engineConfiguration.getBrowserCallableFinder().find(engineConfiguration);
                ParserProcessor processor = new ParserProcessor(engineConfiguration);
                processor.process(browserCallables);
            }
            catch (Exception e) {
                throw new ExecutionFailedException("Failed to generate OpenAPI spec", (Throwable)e);
            }
        } else {
            ApplicationContextProvider.runOnContext(applicationContext -> {
                List browserCallables = EndpointCodeGenerator.findBrowserCallables((EngineAutoConfiguration)engineConfiguration, (ApplicationContext)applicationContext);
                ParserProcessor processor = new ParserProcessor(engineConfiguration);
                processor.process(browserCallables);
            });
        }
    }
}

